/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gadgets;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.apiculture.IHiveFrame;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryAPI;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.TileMachine;
import forestry.core.genetics.ClimateHelper;
import forestry.core.network.GuiId;
import forestry.core.network.PacketInventoryStack;
import forestry.core.proxy.Proxies;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.GenericInventoryAdapter;
import forestry.core.utils.StackUtils;
import forestry.core.utils.StringUtil;
import forestry.plugins.PluginForestryApiculture;
import java.util.LinkedList;
import net.minecraftforge.common.ForgeDirection;

public class MachineApiary
extends Machine
implements IBeeHousing {
    public static final int SLOT_QUEEN = 0;
    public static final int SLOT_DRONE = 1;
    public static final int SLOT_INVENTORY_1 = 2;
    private static int SLOT_PRODUCT_1 = 2;
    private static int SLOT_PRODUCT_COUNT = 7;
    public static final int SLOT_FRAMES_1 = 9;
    public static final int SLOT_INVENTORY_COUNT = 7;
    public static final int SLOT_FRAMES_COUNT = 3;
    public GenericInventoryAdapter inventory = new GenericInventoryAdapter(12, "Items");
    private IBeekeepingLogic logic;
    private int biomeId;
    private float temperature;
    private float humidity;
    private int displayHealthMax = 0;
    private int displayHealth = 0;

    public MachineApiary(TileMachine tile) {
        super(tile);
        this.setHints((String[])Config.hints.get("apiary"));
        if (tile.k != null) {
            yy biome = tile.k.a(tile.l, tile.n);
            this.biomeId = biome.N;
            this.temperature = biome.F;
            this.humidity = biome.G;
            this.setErrorState(EnumErrorCode.OK);
        }
        this.logic = BeeManager.breedingManager.createBeekeepingLogic(this);
    }

    @Override
    public String getName() {
        return StringUtil.localize("tile.machine.7");
    }

    @Override
    public void openGui(qx player, la tile) {
        player.openGui(ForestryAPI.instance, GuiId.ApiaryGUI.ordinal(), this.tile.k, this.tile.l, this.tile.m, this.tile.n);
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("Temp", this.temperature);
        nbttagcompound.a("Humidity", this.humidity);
        nbttagcompound.a("BiomeId", this.biomeId);
        this.inventory.writeToNBT(nbttagcompound);
        this.logic.writeToNBT(nbttagcompound);
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.temperature = nbttagcompound.g("Temp");
        this.humidity = nbttagcompound.g("Humidity");
        this.biomeId = nbttagcompound.e("BiomeId");
        this.inventory.readFromNBT(nbttagcompound);
        this.logic.readFromNBT(nbttagcompound);
    }

    @Override
    public boolean isClimatized() {
        return true;
    }

    @Override
    public EnumTemperature getTemperature() {
        if (this.biomeId == yy.j.N) {
            return EnumTemperature.HELLISH;
        }
        return ClimateHelper.getTemperature(this.temperature);
    }

    @Override
    public EnumHumidity getHumidity() {
        return ClimateHelper.getHumidity(this.humidity);
    }

    @Override
    public void updateClientSide() {
        if (BeeManager.beeInterface.isMated(this.inventory.a(0)) && this.getErrorState() == EnumErrorCode.OK && this.tile.k.G() % 2L % 2L == 0L) {
            IBee displayQueen = BeeManager.beeInterface.getBee(this.inventory.a(0));
            displayQueen.doFX(this.logic.getEffectData(), this);
        }
    }

    @Override
    public void updateServerSide() {
        if (this.logic == null) {
            return;
        }
        this.logic.update();
        IBee queen = this.logic.getQueen();
        if (queen == null) {
            return;
        }
        if (this.tile.k.G() % 200L * 10L == 0L) {
            this.onQueenChange(this.inventory.a(0));
        }
        if (this.getErrorState() == EnumErrorCode.OK && this.tile.k.G() % 2L % 2L == 0L) {
            queen.doFX(this.logic.getEffectData(), this);
        }
        if (this.getErrorState() == EnumErrorCode.OK && this.tile.k.G() % 50L == 0L) {
            float f = (float)this.tile.l + 0.5f;
            float f1 = (float)this.tile.m + 0.0f + this.tile.k.t.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)this.tile.n + 0.5f;
            float f3 = 0.52f;
            float f4 = this.tile.k.t.nextFloat() * 0.6f - 0.3f;
            Proxies.common.addEntitySwarmFX(this.tile.k, f - f3, f1, f2 + f4, 0.0f, 0.0f, 0.0f);
            Proxies.common.addEntitySwarmFX(this.tile.k, f + f3, f1, f2 + f4, 0.0f, 0.0f, 0.0f);
            Proxies.common.addEntitySwarmFX(this.tile.k, f + f4, f1, f2 - f3, 0.0f, 0.0f, 0.0f);
            Proxies.common.addEntitySwarmFX(this.tile.k, f + f4, f1, f2 + f3, 0.0f, 0.0f, 0.0f);
        }
    }

    @Override
    public boolean doWork() {
        return false;
    }

    @Override
    public boolean isWorking() {
        return this.getErrorState() == EnumErrorCode.OK;
    }

    @Override
    public boolean addProduct(ur product, boolean all) {
        return this.inventory.tryAddStack(product, SLOT_PRODUCT_1, SLOT_PRODUCT_COUNT, all, true);
    }

    @Override
    public void onQueenChange(ur queenStack) {
        if (!Proxies.common.isSimulating(this.tile.k)) {
            return;
        }
        Proxies.net.sendNetworkPacket(new PacketInventoryStack(2, this.tile.l, this.tile.m, this.tile.n, 0, queenStack), this.tile.l, this.tile.m, this.tile.n);
    }

    private int getHealthDisplay() {
        if (this.inventory.a(0) == null) {
            return 0;
        }
        if (this.inventory.a((int)0).c == ForestryItem.beeQueenGE.cj) {
            return BeeManager.beeInterface.getBee(this.inventory.a(0)).getHealth();
        }
        if (this.inventory.a((int)0).c == ForestryItem.beePrincessGE.cj) {
            return this.displayHealth;
        }
        return 0;
    }

    private int getMaxHealthDisplay() {
        if (this.inventory.a(0) == null) {
            return 0;
        }
        if (this.inventory.a((int)0).c == ForestryItem.beeQueenGE.cj) {
            return BeeManager.beeInterface.getBee(this.inventory.a(0)).getMaxHealth();
        }
        if (this.inventory.a((int)0).c == ForestryItem.beePrincessGE.cj) {
            return this.displayHealthMax;
        }
        return 0;
    }

    public int getHealthScaled(int i) {
        if (this.getMaxHealthDisplay() == 0) {
            return 0;
        }
        return this.getHealthDisplay() * i / this.getMaxHealthDisplay();
    }

    public int getTemperatureScaled(int i) {
        return Math.round((float)i * (this.temperature / 2.0f));
    }

    public int getHumidityScaled(int i) {
        return Math.round((float)i * this.humidity);
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        if (this.logic == null) {
            return;
        }
        switch (i) {
            case 0: {
                this.displayHealth = j;
                break;
            }
            case 1: {
                this.displayHealthMax = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(rq container, rw iCrafting) {
        if (this.logic == null) {
            return;
        }
        iCrafting.a(container, 0, this.logic.getBreedingTime());
        iCrafting.a(container, 1, this.logic.getTotalBreedingTime());
    }

    @Override
    public int k_() {
        return this.inventory.k_();
    }

    @Override
    public ur a(int i) {
        return this.inventory.a(i);
    }

    @Override
    public ur a(int i, int j) {
        return this.inventory.a(i, j);
    }

    @Override
    public void a(int i, ur itemstack) {
        this.inventory.a(i, itemstack);
    }

    @Override
    public ur a_(int slot) {
        return this.inventory.a_(slot);
    }

    @Override
    public int getStartInventorySide(int side) {
        if (side == 0) {
            return 1;
        }
        if (side == 1) {
            return 0;
        }
        return SLOT_PRODUCT_1;
    }

    @Override
    public int getSizeInventorySide(int side) {
        if (side == 0 || side == 1) {
            return 1;
        }
        return SLOT_PRODUCT_COUNT;
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        ur product = null;
        for (int i = SLOT_PRODUCT_1; i < SLOT_PRODUCT_1 + SLOT_PRODUCT_COUNT; ++i) {
            if (this.inventory.a(i) == null) continue;
            if (this.inventory.a((int)i).c == ForestryItem.beePrincessGE.cj) {
                if (PluginForestryApiculture.apiarySideSensitive && from != ForgeDirection.UP) continue;
                product = this.inventory.a(i).l();
                if (!doRemove) break;
                this.inventory.a((int)i).a = 0;
                this.inventory.a(i, null);
                break;
            }
            if (this.inventory.a((int)i).c == ForestryItem.beeDroneGE.cj) {
                if (PluginForestryApiculture.apiarySideSensitive && from != ForgeDirection.DOWN) continue;
                product = this.inventory.a(i).l();
                if (!doRemove) break;
                --this.inventory.a((int)i).a;
                if (this.inventory.a((int)i).a > 0) break;
                this.inventory.a(i, null);
                break;
            }
            if (PluginForestryApiculture.apiarySideSensitive && (from == ForgeDirection.UP || from == ForgeDirection.DOWN)) continue;
            product = StackUtils.createSplitStack(this.inventory.a(i), 1);
            if (!doRemove) break;
            --this.inventory.a((int)i).a;
            if (this.inventory.a((int)i).a > 0) break;
            this.inventory.a(i, null);
            break;
        }
        return new ur[]{product};
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        if ((stack.c == ForestryItem.beePrincessGE.cj || stack.c == ForestryItem.beeQueenGE.cj) && this.inventory.a(0) == null) {
            if (doAdd) {
                this.inventory.a(0, stack.l());
                this.inventory.a((int)0).a = 1;
            }
            return 1;
        }
        if (stack.c == ForestryItem.beeDroneGE.cj && this.inventory.a(1) == null) {
            if (doAdd) {
                this.inventory.a(1, stack.l());
                this.inventory.a((int)1).a = 1;
            }
            return 1;
        }
        return 0;
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.missingQueen);
        res.add(ForestryTrigger.missingDrone);
        res.add(PluginForestryApiculture.triggerNoFrames);
        return res;
    }

    @Override
    public int getXCoord() {
        return this.tile.l;
    }

    @Override
    public int getYCoord() {
        return this.tile.m;
    }

    @Override
    public int getZCoord() {
        return this.tile.n;
    }

    @Override
    public int getBiomeId() {
        return this.biomeId;
    }

    @Override
    public ur getQueen() {
        return this.a(0);
    }

    @Override
    public ur getDrone() {
        return this.a(1);
    }

    @Override
    public void setQueen(ur itemstack) {
        this.a(0, itemstack);
    }

    @Override
    public void setDrone(ur itemstack) {
        this.a(1, itemstack);
    }

    @Override
    public float getTerritoryModifier(IBeeGenome genome) {
        float mod = 1.0f;
        for (int i = 9; i < 12; ++i) {
            if (this.inventory.a(i) == null || !(this.inventory.a(i).b() instanceof IHiveFrame)) continue;
            mod *= ((IHiveFrame)this.inventory.a(i).b()).getTerritoryModifier(genome);
        }
        return mod;
    }

    @Override
    public float getProductionModifier(IBeeGenome genome) {
        float mod = 0.1f;
        for (int i = 9; i < 12; ++i) {
            if (this.inventory.a(i) == null || !(this.inventory.a(i).b() instanceof IHiveFrame)) continue;
            mod *= ((IHiveFrame)this.inventory.a(i).b()).getProductionModifier(genome);
        }
        return mod;
    }

    @Override
    public float getMutationModifier(IBeeGenome genome, IBeeGenome mate) {
        float mod = 1.0f;
        for (int i = 9; i < 12; ++i) {
            if (this.inventory.a(i) == null || !(this.inventory.a(i).b() instanceof IHiveFrame)) continue;
            mod *= ((IHiveFrame)this.inventory.a(i).b()).getMutationModifier(genome, mate);
        }
        return mod;
    }

    @Override
    public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate) {
        float mod = 1.0f;
        for (int i = 9; i < 12; ++i) {
            if (this.inventory.a(i) == null || !(this.inventory.a(i).b() instanceof IHiveFrame)) continue;
            mod *= ((IHiveFrame)this.inventory.a(i).b()).getLifespanModifier(genome, mate);
        }
        return mod;
    }

    @Override
    public qx getOwnerEntity() {
        return this.tile.getOwnerEntity();
    }

    @Override
    public yc getWorld() {
        return this.tile.k;
    }

    @Override
    public void setErrorState(int state) {
        this.setErrorState(EnumErrorCode.values()[state]);
    }

    @Override
    public int getErrorOrdinal() {
        return this.getErrorState().ordinal();
    }

    @Override
    public boolean canBreed() {
        return true;
    }

    @Override
    public void wearOutEquipment(int amount) {
        int wear = Math.round((float)amount * BeeManager.breedingManager.getBeekeepingMode(this.tile.k).getWearModifier());
        for (int i = 9; i < 12; ++i) {
            if (this.inventory.a(i) == null || !(this.inventory.a(i).b() instanceof IHiveFrame)) continue;
            this.inventory.a(i, ((IHiveFrame)this.inventory.a(i).b()).frameUsed(this.tile.k, this.inventory.a(i), BeeManager.beeInterface.getBee(this.inventory.a(0)), wear));
        }
    }

    @Override
    public boolean isSealed() {
        return false;
    }

    @Override
    public boolean isSelfLighted() {
        return false;
    }

    @Override
    public boolean isSunlightSimulated() {
        return false;
    }

    @Override
    public boolean isHellish() {
        return false;
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(any tile) {
            return new MachineApiary((TileMachine)tile);
        }
    }
}

