/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gadgets;

import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IAlvearyComponent;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IStructureLogic;
import forestry.api.core.ITileStructure;
import forestry.apiculture.gadgets.StructureLogicAlveary;
import forestry.apiculture.gui.ContainerAlveary;
import forestry.core.EnumErrorCode;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.Gadget;
import forestry.core.gadgets.TileForestry;
import forestry.core.genetics.ClimateHelper;
import forestry.core.interfaces.IClimatised;
import forestry.core.interfaces.IErrorSource;
import forestry.core.network.GuiId;
import forestry.core.network.PacketInventoryStack;
import forestry.core.network.PacketPayload;
import forestry.core.proxy.Proxies;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.StackUtils;
import forestry.core.utils.TileInventoryAdapter;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraftforge.common.ForgeDirection;

public class TileAlveary
extends TileForestry
implements IAlvearyComponent,
IBeeHousing,
ISpecialInventory,
IClimatised {
    public static final int SLOT_QUEEN = 0;
    public static final int SLOT_DRONE = 1;
    public static final int SLOT_PRODUCT_1 = 2;
    protected IBeekeepingLogic beekeepingLogic;
    protected TileInventoryAdapter inventory;
    protected int biomeId;
    protected float temperature;
    protected float humidity;
    protected float tempChange = 0.0f;
    protected float humidChange = 0.0f;
    private int displayHealthMax = 0;
    private int displayHealth = 0;
    IStructureLogic structureLogic = new StructureLogicAlveary(this);
    private boolean isMaster;
    private int masterX;
    private int masterZ;
    private int masterY = -99;
    private ArrayList modifiers;

    @Override
    public void openGui(qx player, la tile) {
        if (this.isMaster) {
            player.openGui(ForestryAPI.instance, GuiId.AlvearyGUI.ordinal(), this.k, this.l, this.m, this.n);
        } else if (this.hasMaster()) {
            player.openGui(ForestryAPI.instance, GuiId.AlvearyGUI.ordinal(), this.k, this.masterX, this.masterY, this.masterZ);
        }
    }

    @Override
    public void g() {
        if (!Proxies.common.isSimulating(this.k)) {
            this.updateClientSide();
        } else {
            this.updateServerSide();
        }
    }

    protected void updateServerSide() {
        IPowerReceptor receptor;
        if (!this.isInited) {
            this.initialize();
            this.isInited = true;
        }
        if (this instanceof IPowerReceptor && (receptor = (IPowerReceptor)((Object)this)).getPowerProvider() != null) {
            IPowerProvider powerProvider = receptor.getPowerProvider();
            powerProvider.update(receptor);
        }
        if (this.k.G() % 100L == 0L && (!this.isIntegratedIntoStructure() || this.isMaster)) {
            this.validateStructure();
        }
        if (this.beekeepingLogic == null) {
            return;
        }
        this.beekeepingLogic.update();
        this.equalizeTemperature();
        this.equalizeHumidity();
        IBee queen = this.beekeepingLogic.getQueen();
        if (queen == null) {
            return;
        }
        if (this.k.G() % 200L * 10L == 0L) {
            this.onQueenChange(this.inventory.a(0));
        }
        if (this.getErrorState() == EnumErrorCode.OK) {
            queen.doFX(this.beekeepingLogic.getEffectData(), this);
        }
        if (this.getErrorState() == EnumErrorCode.OK && this.k.G() % 50L == 0L) {
            float f = (float)this.l + 0.5f;
            float f1 = (float)this.m + 0.0f + this.k.t.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)this.n + 0.5f;
            float f3 = 0.52f;
            float f4 = this.k.t.nextFloat() * 0.6f - 0.3f;
            Proxies.common.addEntitySwarmFX(this.k, f - f3, f1, f2 + f4, 0.0f, 0.0f, 0.0f);
            Proxies.common.addEntitySwarmFX(this.k, f + f3, f1, f2 + f4, 0.0f, 0.0f, 0.0f);
            Proxies.common.addEntitySwarmFX(this.k, f + f4, f1, f2 - f3, 0.0f, 0.0f, 0.0f);
            Proxies.common.addEntitySwarmFX(this.k, f + f4, f1, f2 + f3, 0.0f, 0.0f, 0.0f);
        }
    }

    protected void updateClientSide() {
        if (!this.isMaster) {
            return;
        }
        if (BeeManager.beeInterface.isMated(this.inventory.a(0)) && this.getErrorState() == EnumErrorCode.OK && this.k.G() % 2L == 0L) {
            IBee displayQueen = BeeManager.beeInterface.getBee(this.inventory.a(0));
            displayQueen.doFX(this.beekeepingLogic.getEffectData(), this);
        }
    }

    private void equalizeTemperature() {
        if (this.tempChange == 0.0f) {
            return;
        }
        this.tempChange -= 0.05f * this.tempChange;
        if (this.tempChange <= 0.001f && this.tempChange >= -0.001f) {
            this.tempChange = 0.0f;
        }
    }

    private void equalizeHumidity() {
        if (this.humidChange == 0.0f) {
            return;
        }
        this.humidChange -= 0.05f * this.humidChange;
        if (this.humidChange <= 0.001f && this.humidChange >= 0.001f) {
            this.humidChange = 0.0f;
        }
    }

    private int getHealthDisplay() {
        if (this.inventory.a(0) == null) {
            return 0;
        }
        if (BeeManager.beeInterface.isMated(this.inventory.a(0))) {
            return BeeManager.beeInterface.getBee(this.inventory.a(0)).getHealth();
        }
        if (!BeeManager.beeInterface.isDrone(this.inventory.a(0))) {
            return this.displayHealth;
        }
        return 0;
    }

    private int getMaxHealthDisplay() {
        if (this.inventory.a(0) == null) {
            return 0;
        }
        if (BeeManager.beeInterface.isMated(this.inventory.a(0))) {
            return BeeManager.beeInterface.getBee(this.inventory.a(0)).getMaxHealth();
        }
        if (!BeeManager.beeInterface.isDrone(this.inventory.a(0))) {
            return this.displayHealthMax;
        }
        return 0;
    }

    public int getHealthScaled(int i) {
        if (this.getMaxHealthDisplay() == 0) {
            return 0;
        }
        return this.getHealthDisplay() * i / this.getMaxHealthDisplay();
    }

    @Override
    public boolean allowsInteraction(qx player) {
        if (!super.allowsInteraction(player)) {
            return false;
        }
        return this.isIntegratedIntoStructure();
    }

    @Override
    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        this.isMaster = nbttagcompound.n("IsMaster");
        this.masterX = nbttagcompound.e("MasterX");
        this.masterY = nbttagcompound.e("MasterY");
        this.masterZ = nbttagcompound.e("MasterZ");
        this.tempChange = nbttagcompound.g("TempChange");
        this.humidChange = nbttagcompound.g("HumidChange");
        if (this.isMaster) {
            this.makeMaster();
        }
        if (this.inventory != null) {
            this.inventory.readFromNBT(nbttagcompound);
        }
        if (this.beekeepingLogic != null) {
            this.beekeepingLogic.readFromNBT(nbttagcompound);
        }
        this.structureLogic.readFromNBT(nbttagcompound);
    }

    @Override
    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("IsMaster", this.isMaster);
        nbttagcompound.a("MasterX", this.masterX);
        nbttagcompound.a("MasterY", this.masterY);
        nbttagcompound.a("MasterZ", this.masterZ);
        nbttagcompound.a("TempChange", this.tempChange);
        nbttagcompound.a("HumidChange", this.humidChange);
        if (this.inventory != null) {
            this.inventory.writeToNBT(nbttagcompound);
        }
        if (this.beekeepingLogic != null) {
            this.beekeepingLogic.writeToNBT(nbttagcompound);
        }
        this.structureLogic.writeToNBT(nbttagcompound);
    }

    private void createInventory() {
        this.inventory = new TileInventoryAdapter(this, 9, "Items");
    }

    @Override
    public boolean hasHints() {
        return false;
    }

    @Override
    public String[] getHints() {
        return null;
    }

    @Override
    public void initialize() {
        yy biome = this.k.a(this.l, this.n);
        this.biomeId = biome.N;
        this.temperature = biome.F;
        this.humidity = biome.G;
        this.setErrorState(EnumErrorCode.OK);
    }

    @Override
    public Gadget getMachine() {
        return null;
    }

    @Override
    public void fromPacketPayload(PacketPayload payload) {
    }

    @Override
    public PacketPayload getPacketPayload() {
        return null;
    }

    public int k_() {
        if (this.inventory != null) {
            return this.inventory.k_();
        }
        if (this.hasMaster()) {
            return this.getCentralTE().getInventory().k_();
        }
        return 0;
    }

    public ur a(int slotIndex) {
        if (this.inventory != null) {
            return this.inventory.a(slotIndex);
        }
        if (this.hasMaster()) {
            return this.getCentralTE().getInventory().a(slotIndex);
        }
        return null;
    }

    public ur a(int slotIndex, int amount) {
        if (this.inventory != null) {
            return this.inventory.a(slotIndex, amount);
        }
        if (this.hasMaster()) {
            return this.getCentralTE().getInventory().a(slotIndex, amount);
        }
        return null;
    }

    public ur a_(int slotIndex) {
        if (this.inventory != null) {
            return this.inventory.a_(slotIndex);
        }
        if (this.hasMaster()) {
            return this.getCentralTE().getInventory().a_(slotIndex);
        }
        return null;
    }

    public void a(int slotIndex, ur itemstack) {
        if (this.inventory == null && !Proxies.common.isSimulating(this.k)) {
            this.createInventory();
        }
        if (this.inventory != null) {
            this.inventory.a(slotIndex, itemstack);
        } else if (this.hasMaster()) {
            this.getCentralTE().getInventory().a(slotIndex, itemstack);
        }
    }

    public String b() {
        return "tile.alveary.0";
    }

    public int c() {
        if (this.inventory != null) {
            return this.inventory.c();
        }
        if (this.hasMaster()) {
            return this.getCentralTE().getInventory().c();
        }
        return 0;
    }

    @Override
    public String getTypeUID() {
        return this.structureLogic.getTypeUID();
    }

    @Override
    public boolean isMaster() {
        return this.isMaster;
    }

    @Override
    public void validateStructure() {
        this.structureLogic.validateStructure();
    }

    @Override
    public void makeMaster() {
        this.isMaster = true;
        if (this.inventory == null) {
            this.createInventory();
        }
        if (this.beekeepingLogic == null) {
            this.beekeepingLogic = BeeManager.breedingManager.createBeekeepingLogic(this);
        }
        this.modifiers = new ArrayList();
    }

    @Override
    public void onStructureReset() {
        this.setCentralTE(null);
        this.k.d(this.l, this.m, this.n, 0);
        this.k.i(this.l, this.m, this.n);
        this.isMaster = false;
        this.clearInventory();
        this.modifiers = null;
    }

    private void clearInventory() {
        if (this.inventory == null) {
            return;
        }
        for (int i = 0; i < this.inventory.k_(); ++i) {
            if (this.inventory.a(i) == null) continue;
            StackUtils.dropItemStackAsEntity(this.inventory.a(i), this.k, this.l + 2, this.m + 2, this.n);
            this.inventory.a(i, null);
        }
        this.inventory = null;
    }

    @Override
    public ITileStructure getCentralTE() {
        if (!this.isIntegratedIntoStructure()) {
            return null;
        }
        if (!this.isMaster) {
            any tile = this.k.q(this.masterX, this.masterY, this.masterZ);
            if (tile instanceof ITileStructure) {
                return (ITileStructure)this.k.q(this.masterX, this.masterY, this.masterZ);
            }
            return null;
        }
        return this;
    }

    @Override
    public void setCentralTE(any tile) {
        if (tile == null || tile == this) {
            this.masterZ = 0;
            this.masterX = 0;
            this.masterY = -99;
            return;
        }
        this.masterX = tile.l;
        this.masterY = tile.m;
        this.masterZ = tile.n;
    }

    protected boolean hasMaster() {
        return this.masterY >= 0;
    }

    @Override
    public boolean isIntegratedIntoStructure() {
        return this.isMaster || this.masterY >= 0;
    }

    @Override
    public la getInventory() {
        return this.inventory;
    }

    @Override
    public boolean hasFunction() {
        return false;
    }

    @Override
    public void addTemperatureChange(float change, float boundaryDown, float boundaryUp) {
        this.tempChange = Math.min(boundaryUp - this.temperature, Math.max(boundaryDown - this.temperature, this.tempChange + change));
    }

    @Override
    public void addHumidityChange(float change, float boundaryDown, float boundaryUp) {
        this.humidChange = Math.min(boundaryUp - this.humidity, Math.max(boundaryDown - this.humidity, this.humidChange + change));
    }

    @Override
    public void registerBeeModifier(IBeeModifier modifier) {
        this.modifiers.add(modifier);
    }

    @Override
    public void removeBeeModifier(IBeeModifier modifier) {
        this.modifiers.remove(modifier);
    }

    @Override
    public int getXCoord() {
        return this.l;
    }

    @Override
    public int getYCoord() {
        return this.m;
    }

    @Override
    public int getZCoord() {
        return this.n;
    }

    @Override
    public ur getQueen() {
        return this.a(0);
    }

    @Override
    public ur getDrone() {
        return this.a(1);
    }

    @Override
    public void setQueen(ur itemstack) {
        this.a(0, itemstack);
    }

    @Override
    public void setDrone(ur itemstack) {
        this.a(1, itemstack);
    }

    @Override
    public int getBiomeId() {
        return this.biomeId;
    }

    @Override
    public EnumTemperature getTemperature() {
        if (this.biomeId == yy.j.N && this.tempChange >= 0.0f) {
            return EnumTemperature.HELLISH;
        }
        return ClimateHelper.getTemperature(this.temperature + this.tempChange);
    }

    @Override
    public EnumHumidity getHumidity() {
        return ClimateHelper.getHumidity(this.humidity + this.humidChange);
    }

    @Override
    public float getTerritoryModifier(IBeeGenome genome) {
        float mod = 2.0f;
        for (IBeeModifier modifier : this.modifiers) {
            mod *= modifier.getTerritoryModifier(genome);
        }
        return mod;
    }

    @Override
    public float getProductionModifier(IBeeGenome genome) {
        float mod = 1.0f;
        for (IBeeModifier modifier : this.modifiers) {
            mod *= modifier.getProductionModifier(genome);
        }
        return mod;
    }

    @Override
    public float getMutationModifier(IBeeGenome genome, IBeeGenome mate) {
        float mod = 1.0f;
        for (IBeeModifier modifier : this.modifiers) {
            mod *= modifier.getMutationModifier(genome, mate);
        }
        return mod;
    }

    @Override
    public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate) {
        float mod = 1.0f;
        for (IBeeModifier modifier : this.modifiers) {
            mod *= modifier.getLifespanModifier(genome, mate);
        }
        return mod;
    }

    @Override
    public yc getWorld() {
        return this.k;
    }

    @Override
    public void setErrorState(int state) {
        this.setErrorState(EnumErrorCode.values()[state]);
    }

    @Override
    public int getErrorOrdinal() {
        return this.getErrorState().ordinal();
    }

    @Override
    public boolean canBreed() {
        return true;
    }

    @Override
    public boolean addProduct(ur product, boolean all) {
        if (this.inventory == null) {
            return false;
        }
        return this.inventory.tryAddStack(product, 2, this.inventory.k_() - 2, all);
    }

    @Override
    public void wearOutEquipment(int amount) {
    }

    @Override
    public void onQueenChange(ur queenStack) {
        if (!Proxies.common.isSimulating(this.k)) {
            return;
        }
        Proxies.net.sendNetworkPacket(new PacketInventoryStack(2, this.l, this.m, this.n, 0, queenStack), this.l, this.m, this.n);
    }

    @Override
    public boolean isSealed() {
        return false;
    }

    @Override
    public boolean isSelfLighted() {
        return false;
    }

    @Override
    public boolean isSunlightSimulated() {
        return false;
    }

    @Override
    public boolean isHellish() {
        return false;
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        TileInventoryAdapter inv;
        if (this.inventory != null) {
            inv = this.inventory;
        } else if (this.hasMaster()) {
            inv = this.getCentralTE().getInventory();
        } else {
            return 0;
        }
        if ((stack.c == ForestryItem.beePrincessGE.cj || stack.c == ForestryItem.beeQueenGE.cj) && inv.a(0) == null) {
            if (doAdd) {
                inv.a(0, stack.l());
                inv.a((int)0).a = 1;
            }
            return 1;
        }
        if (stack.c == ForestryItem.beeDroneGE.cj && inv.a(1) == null) {
            if (doAdd) {
                inv.a(1, stack.l());
                inv.a((int)1).a = 1;
            }
            return 1;
        }
        return 0;
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        TileInventoryAdapter inv;
        if (this.inventory != null) {
            inv = this.inventory;
        } else if (this.hasMaster()) {
            inv = this.getCentralTE().getInventory();
        } else {
            return new ur[0];
        }
        ur product = null;
        for (int i = 2; i < inv.k_(); ++i) {
            if (inv.a(i) == null) continue;
            ur stack = inv.a(i);
            if (doRemove) {
                product = inv.a(i, 1);
                break;
            }
            product = stack.l();
            product.a = 1;
            break;
        }
        return new ur[]{product};
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.displayHealth = j;
                break;
            }
            case 1: {
                this.displayHealthMax = j;
                break;
            }
            case 2: {
                this.temperature = (float)j / 100.0f;
                break;
            }
            case 3: {
                this.humidity = (float)j / 100.0f;
                break;
            }
            case 4: {
                this.tempChange = (float)j / 100.0f;
                break;
            }
            case 5: {
                this.humidChange = (float)j / 100.0f;
                break;
            }
            case 6: {
                this.biomeId = j;
            }
        }
    }

    public void sendGUINetworkData(ContainerAlveary container, rw iCrafting) {
        if (this.beekeepingLogic == null) {
            return;
        }
        iCrafting.a((rq)container, 0, this.beekeepingLogic.getBreedingTime());
        iCrafting.a((rq)container, 1, this.beekeepingLogic.getTotalBreedingTime());
        iCrafting.a((rq)container, 2, Math.round(this.temperature * 100.0f));
        iCrafting.a((rq)container, 3, Math.round(this.humidity * 100.0f));
        iCrafting.a((rq)container, 4, Math.round(this.tempChange * 100.0f));
        iCrafting.a((rq)container, 5, Math.round(this.humidChange * 100.0f));
        iCrafting.a((rq)container, 6, this.biomeId);
    }

    @Override
    public EnumErrorCode getErrorState() {
        if (this.hasMaster()) {
            ITileStructure tile = this.getCentralTE();
            return ((IErrorSource)((Object)tile)).getErrorState();
        }
        return this.errorState;
    }

    @Override
    public boolean isClimatized() {
        return true;
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.missingQueen);
        res.add(ForestryTrigger.missingDrone);
        return res;
    }
}

