/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gadgets;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import forestry.api.apiculture.IAlvearyComponent;
import forestry.apiculture.gadgets.TileAlveary;

public abstract class TileAlvearyClimatiser
extends TileAlveary
implements IPowerReceptor {
    IPowerProvider powerProvider;
    ClimateControl climateControl;
    private int transferTime = 0;
    private int animationDelay = 0;

    public TileAlvearyClimatiser(ClimateControl control) {
        this.climateControl = control;
        this.powerProvider = PowerFramework.currentFramework.createPowerProvider();
        this.powerProvider.configure(1, 10, 100, 25, 200);
    }

    @Override
    public void openGui(qx player, la tile) {
    }

    @Override
    protected void updateServerSide() {
        super.updateServerSide();
        if (!this.hasMaster()) {
            return;
        }
        if (this.transferTime > 0) {
            this.transferTime -= 5;
            IAlvearyComponent component = (IAlvearyComponent)this.getCentralTE();
            if (component != null) {
                component.addTemperatureChange(5.0f * this.climateControl.changePerTransfer, this.climateControl.boundaryDown, this.climateControl.boundaryUp);
            }
        }
        if (this.animationDelay > 0) {
            --this.animationDelay;
        }
        if (this.animationDelay <= 0) {
            this.k.c(this.l, this.m, this.n, 0);
            this.k.i(this.l, this.m, this.n);
        }
    }

    @Override
    public boolean hasFunction() {
        return true;
    }

    @Override
    public void doWork() {
        if (!this.hasMaster()) {
            return;
        }
        if (this.powerProvider.useEnergy(this.powerProvider.getActivationEnergy(), this.powerProvider.getEnergyStored(), false) < (float)this.powerProvider.getActivationEnergy()) {
            return;
        }
        this.transferTime = Math.round(this.powerProvider.useEnergy(this.powerProvider.getActivationEnergy(), this.powerProvider.getEnergyStored(), true));
        this.animationDelay = 100;
        this.k.c(this.l, this.m, this.n, 1);
        this.k.i(this.l, this.m, this.n);
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public int powerRequest() {
        return this.powerProvider.getActivationEnergy();
    }

    @Override
    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        PowerFramework.currentFramework.loadPowerProvider(this, nbttagcompound);
        this.transferTime = nbttagcompound.e("Heating");
    }

    @Override
    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        PowerFramework.currentFramework.savePowerProvider(this, nbttagcompound);
        nbttagcompound.a("Heating", this.transferTime);
    }

    public static class ClimateControl {
        final float changePerTransfer;
        final float boundaryUp;
        final float boundaryDown;

        public ClimateControl(float changePerTransfer, float boundaryDown, float boundaryUp) {
            this.changePerTransfer = changePerTransfer;
            this.boundaryDown = boundaryDown;
            this.boundaryUp = boundaryUp;
        }
    }
}

