/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.AlleleEffectThrottled;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Vect;

public class AlleleEffectGlacial
extends AlleleEffectThrottled {
    public AlleleEffectGlacial(String uid) {
        super(uid, false);
    }

    @Override
    public int getThrottle() {
        return 200;
    }

    @Override
    public boolean isCombinable() {
        return false;
    }

    @Override
    public IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        yc world = housing.getWorld();
        if (this.isThrottled(storedData)) {
            return storedData;
        }
        if (EnumTemperature.hellishBiomeIds.contains(housing.getBiomeId())) {
            return storedData;
        }
        if (EnumTemperature.hotBiomeIds.contains(housing.getBiomeId())) {
            return storedData;
        }
        if (EnumTemperature.warmBiomeIds.contains(housing.getBiomeId())) {
            return storedData;
        }
        int[] areaAr = genome.getTerritory();
        Vect area = new Vect(areaAr[0], areaAr[1], areaAr[2]);
        Vect offset = new Vect(-Math.round(area.x / 2), -Math.round(area.y / 2), -Math.round(area.z / 2));
        for (int i = 0; i < 10; ++i) {
            Vect randomPos = new Vect(world.t.nextInt(area.x), world.t.nextInt(area.y), world.t.nextInt(area.z));
            Vect posBlock = randomPos.add(new Vect(housing.getXCoord(), housing.getYCoord(), housing.getZCoord()));
            posBlock = posBlock.add(offset);
            int blockid = world.a(posBlock.x, posBlock.y, posBlock.z);
            if (blockid != amq.E.cm || !world.c(posBlock.x, posBlock.y + 1, posBlock.z)) continue;
            world.e(posBlock.x, posBlock.y, posBlock.z, amq.aW.cm);
        }
        return storedData;
    }

    @Override
    public String getIdentifier() {
        return StringUtil.localize("apiculture.effect.glacial");
    }
}

