/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.AlleleEffectThrottled;
import forestry.apiculture.items.ItemArmorApiarist;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Vect;
import forestry.plugins.PluginForestryApiculture;
import java.util.List;

public class AlleleEffectIgnition
extends AlleleEffectThrottled {
    int ignitionChance = 50;
    int fireDuration = 500;

    public AlleleEffectIgnition(String uid) {
        super(uid, false);
    }

    @Override
    public int getThrottle() {
        return 20;
    }

    @Override
    public boolean isCombinable() {
        return true;
    }

    @Override
    public IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        yc world = housing.getWorld();
        if (this.isThrottled(storedData)) {
            return storedData;
        }
        int[] areaAr = genome.getTerritory();
        Vect area = new Vect(areaAr[0], areaAr[1], areaAr[2]);
        Vect offset = new Vect(-Math.round(area.x / 2), -Math.round(area.y / 2), -Math.round(area.z / 2));
        Vect min = new Vect(housing.getXCoord() + offset.x, housing.getYCoord() + offset.y, housing.getZCoord() + offset.z);
        Vect max = new Vect(housing.getXCoord() + offset.x + area.x, housing.getYCoord() + offset.y + area.y, housing.getZCoord() + offset.z + area.z);
        aoe hurtBox = aoe.a().a((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
        List list = world.a(md.class, hurtBox);
        for (Object obj : list) {
            md entity = (md)obj;
            int chance = this.ignitionChance;
            int duration = this.fireDuration;
            if (entity instanceof qx) {
                int count = ItemArmorApiarist.wearsItems((qx)entity);
                if (count > 3) continue;
                if (count > 2) {
                    chance = 5;
                    duration = 50;
                } else if (count > 1) {
                    chance = 20;
                    duration = 200;
                } else if (count > 0) {
                    chance = 35;
                    duration = 350;
                }
            }
            if (world.t.nextInt(1000) >= chance) continue;
            entity.c(duration);
        }
        return storedData;
    }

    @Override
    public String getIdentifier() {
        return StringUtil.localize("apiculture.effect.ignition");
    }

    @Override
    public IEffectData doFX(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        int[] area = genome.getTerritory();
        area[0] = (int)((float)area[0] * housing.getTerritoryModifier(genome));
        area[1] = (int)((float)area[1] * housing.getTerritoryModifier(genome));
        area[2] = (int)((float)area[2] * housing.getTerritoryModifier(genome));
        if (area[0] < 1) {
            area[0] = 1;
        }
        if (area[1] < 1) {
            area[1] = 1;
        }
        if (area[2] < 1) {
            area[2] = 1;
        }
        if (housing.getWorld().t.nextBoolean()) {
            PluginForestryApiculture.proxy.addBeeHiveFX("/gfx/forestry/particles/swarm_bee.png", housing.getWorld(), housing.getXCoord(), housing.getYCoord(), housing.getZCoord(), genome.getPrimaryAsBee().getPrimaryColor(), area[0], area[1], area[2]);
        } else {
            PluginForestryApiculture.proxy.addBeeHiveFX("/gfx/forestry/particles/ember.png", housing.getWorld(), housing.getXCoord(), housing.getYCoord(), housing.getZCoord(), 0xFFFFFF, area[0], area[1], area[2]);
        }
        return storedData;
    }
}

