/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.AlleleEffectThrottled;
import forestry.core.utils.Vect;
import java.util.List;

public abstract class AlleleEffectPotion
extends AlleleEffectThrottled {
    private int potionId = 0;
    private int duration;

    public AlleleEffectPotion(String uid, boolean isDominant, ll potion, int duration) {
        super(uid, isDominant);
        this.potionId = potion.c();
        this.duration = duration;
    }

    @Override
    public int getThrottle() {
        return 200;
    }

    @Override
    public boolean isCombinable() {
        return false;
    }

    @Override
    public IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        if (this.isThrottled(storedData)) {
            return storedData;
        }
        int[] areaAr = genome.getTerritory();
        Vect area = new Vect(areaAr[0], areaAr[1], areaAr[2]);
        Vect offset = new Vect(-Math.round(area.x / 2), -Math.round(area.y / 2), -Math.round(area.z / 2));
        Vect min = new Vect(housing.getXCoord() + offset.x, housing.getYCoord() + offset.y, housing.getZCoord() + offset.z);
        Vect max = new Vect(housing.getXCoord() + offset.x + area.x, housing.getYCoord() + offset.y + area.y, housing.getZCoord() + offset.z + area.z);
        aoe beatifyBox = aoe.a().a((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
        List list = housing.getWorld().a(qx.class, beatifyBox);
        for (Object obj : list) {
            qx player = (qx)obj;
            player.d(new lm(this.potionId, this.duration, 0));
        }
        return storedData;
    }
}

