/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.AlleleEffectThrottled;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;

public class AlleleEffectSnowing
extends AlleleEffectThrottled {
    public AlleleEffectSnowing(String uid) {
        super(uid, false);
    }

    @Override
    public IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        return storedData;
    }

    @Override
    public IEffectData doFX(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        int[] area = genome.getTerritory();
        area[0] = (int)((float)area[0] * housing.getTerritoryModifier(genome));
        area[1] = (int)((float)area[1] * housing.getTerritoryModifier(genome));
        area[2] = (int)((float)area[2] * housing.getTerritoryModifier(genome));
        if (area[0] < 1) {
            area[0] = 1;
        }
        if (area[1] < 1) {
            area[1] = 1;
        }
        if (area[2] < 1) {
            area[2] = 1;
        }
        Proxies.render.addSnowFX(housing.getWorld(), housing.getXCoord(), housing.getYCoord(), housing.getZCoord(), genome.getPrimaryAsBee().getPrimaryColor(), area[0], area[1], area[2]);
        return storedData;
    }

    @Override
    public boolean isCombinable() {
        return true;
    }

    @Override
    public String getIdentifier() {
        return StringUtil.localize("apiculture.effect.snowing");
    }

    @Override
    public int getThrottle() {
        return 20;
    }
}

