/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.core.genetics.Allele;
import forestry.core.genetics.EffectData;
import forestry.plugins.PluginForestryApiculture;

public abstract class AlleleEffectThrottled
extends Allele
implements IAlleleBeeEffect {
    public AlleleEffectThrottled(String uid, boolean isDominant) {
        super(uid, isDominant);
    }

    public abstract int getThrottle();

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (storedData instanceof EffectData) {
            return storedData;
        }
        return new EffectData(1, 0);
    }

    public boolean isThrottled(IEffectData storedData) {
        int throttle = storedData.getInteger(0);
        storedData.setInteger(0, ++throttle);
        if (throttle < this.getThrottle()) {
            return true;
        }
        storedData.setInteger(0, 0);
        return false;
    }

    @Override
    public IEffectData doFX(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        int[] area = genome.getTerritory();
        area[0] = (int)((float)area[0] * housing.getTerritoryModifier(genome));
        area[1] = (int)((float)area[1] * housing.getTerritoryModifier(genome));
        area[2] = (int)((float)area[2] * housing.getTerritoryModifier(genome));
        if (area[0] < 1) {
            area[0] = 1;
        }
        if (area[1] < 1) {
            area[1] = 1;
        }
        if (area[2] < 1) {
            area[2] = 1;
        }
        PluginForestryApiculture.proxy.addBeeHiveFX("/gfx/forestry/particles/swarm_bee.png", housing.getWorld(), housing.getXCoord(), housing.getYCoord(), housing.getZCoord(), genome.getPrimaryAsBee().getPrimaryColor(), area[0], area[1], area[2]);
        return storedData;
    }

    @Override
    public String getIconTextureFile() {
        return null;
    }

    @Override
    public int getIconIndex() {
        return -1;
    }
}

