/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeMutation;
import forestry.api.apiculture.IFlowerProvider;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IApiaristTracker;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import forestry.apiculture.genetics.BeeGenome;
import forestry.apiculture.genetics.BeeTemplates;
import forestry.core.EnumErrorCode;
import forestry.core.genetics.Chromosome;
import forestry.core.genetics.ClimateHelper;
import forestry.core.genetics.Individual;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Vect;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class Bee
extends Individual
implements IBee {
    public IBeeGenome genome;
    public IBeeGenome mate;
    private int health;
    private int maxHealth;

    public Bee(bq nbttagcompound) {
        this.readFromNBT(nbttagcompound);
    }

    public Bee(yc world, IBeeGenome genome, IBee mate) {
        this(world, genome);
        this.mate = mate.getGenome();
        this.isIrregularMating = mate.isNatural() != this.isNatural;
    }

    public Bee(IBeeGenome genome, IBee mate) {
        this(genome);
        this.mate = mate.getGenome();
        this.isIrregularMating = mate.isNatural() != this.isNatural;
    }

    public Bee(yc world, IBeeGenome genome) {
        this(world, genome, true, 0);
    }

    public Bee(IBeeGenome genome) {
        this(genome, true, 0);
    }

    public Bee(yc world, IBeeGenome genome, boolean isNatural, int generation) {
        this.genome = genome;
        this.health = this.maxHealth = genome.getLifespan();
        this.isNatural = isNatural;
        this.generation = generation;
    }

    public Bee(IBeeGenome genome, boolean isNatural, int generation) {
        this.genome = genome;
        this.health = this.maxHealth = genome.getLifespan();
        this.isNatural = isNatural;
        this.generation = generation;
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        if (nbttagcompound == null) {
            this.genome = BeeManager.beeInterface.templateAsGenome(BeeTemplates.getForestTemplate());
            return;
        }
        this.health = nbttagcompound.e("Health");
        this.maxHealth = nbttagcompound.e("MaxH");
        if (nbttagcompound.b("Genome")) {
            this.genome = new BeeGenome(nbttagcompound.l("Genome"));
        }
        if (nbttagcompound.b("Mate")) {
            this.mate = new BeeGenome(nbttagcompound.l("Mate"));
        }
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        bq NBTmachine;
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("Health", this.health);
        nbttagcompound.a("MaxH", this.maxHealth);
        if (this.genome != null) {
            NBTmachine = new bq();
            this.genome.writeToNBT(NBTmachine);
            nbttagcompound.a("Genome", (cd)NBTmachine);
        }
        if (this.mate != null) {
            NBTmachine = new bq();
            this.mate.writeToNBT(NBTmachine);
            nbttagcompound.a("Mate", (cd)NBTmachine);
        }
    }

    @Override
    public void age(yc world, float lifespanModifier) {
        float ageModifier;
        if (lifespanModifier < 0.001f) {
            this.health = 0;
            return;
        }
        for (ageModifier = 1.0f / lifespanModifier; ageModifier > 1.0f; ageModifier -= 1.0f) {
            this.decreaseHealth();
        }
        if (world.t.nextFloat() < ageModifier) {
            this.decreaseHealth();
        }
    }

    public void decreaseHealth() {
        if (this.health > 0) {
            --this.health;
        }
    }

    @Override
    public void mate(IBee drone) {
        this.mate = drone.getGenome();
        this.isIrregularMating = drone.isNatural() != this.isNatural;
    }

    @Override
    public void setIsNatural(boolean flag) {
        this.isNatural = flag;
    }

    @Override
    public IEffectData[] doEffect(IEffectData[] storedData, IBeeHousing housing) {
        IAlleleBeeEffect effect = this.genome.getEffect();
        if (effect == null) {
            return null;
        }
        storedData[0] = this.doEffect(effect, storedData[0], housing);
        if (!effect.isCombinable()) {
            return storedData;
        }
        IAlleleBeeEffect secondary = (IAlleleBeeEffect)this.genome.getInactiveAllele(EnumBeeChromosome.EFFECT.ordinal());
        if (!secondary.isCombinable()) {
            return storedData;
        }
        storedData[1] = this.doEffect(secondary, storedData[1], housing);
        return storedData;
    }

    private IEffectData doEffect(IAlleleBeeEffect effect, IEffectData storedData, IBeeHousing housing) {
        storedData = effect.validateStorage(storedData);
        return effect.doEffect(this.genome, storedData, housing);
    }

    @Override
    public IEffectData[] doFX(IEffectData[] storedData, IBeeHousing housing) {
        IAlleleBeeEffect effect = this.genome.getEffect();
        if (effect == null) {
            return null;
        }
        storedData[0] = this.doFX(effect, storedData[0], housing);
        if (!effect.isCombinable()) {
            return storedData;
        }
        IAlleleBeeEffect secondary = (IAlleleBeeEffect)this.genome.getInactiveAllele(EnumBeeChromosome.EFFECT.ordinal());
        if (!secondary.isCombinable()) {
            return storedData;
        }
        storedData[1] = this.doFX(secondary, storedData[1], housing);
        return storedData;
    }

    private IEffectData doFX(IAlleleBeeEffect effect, IEffectData storedData, IBeeHousing housing) {
        return effect.doFX(this.genome, storedData, housing);
    }

    @Override
    public IBeeGenome getGenome() {
        return this.genome;
    }

    @Override
    public IBeeGenome getMate() {
        return this.mate;
    }

    @Override
    public boolean isAlive() {
        return this.health > 0;
    }

    @Override
    public boolean isPureBred(EnumBeeChromosome chromosome) {
        return this.genome.getActiveAllele(chromosome.ordinal()).getUID().equals(this.genome.getInactiveAllele(chromosome.ordinal()).getUID());
    }

    @Override
    public boolean canSpawn() {
        return this.mate != null;
    }

    @Override
    public int isWorking(IBeeHousing housing) {
        yc world = housing.getWorld();
        if (world.N() && !this.genome.getTolerantFlyer() && housing.getHumidity() != EnumHumidity.ARID && !housing.isSealed()) {
            return EnumErrorCode.ISRAINING.ordinal();
        }
        if (!(world.u() || this.genome.getNocturnal() || housing.isSelfLighted())) {
            return EnumErrorCode.NOTDAY.ordinal();
        }
        if (world.m(housing.getXCoord(), housing.getYCoord() + 2, housing.getZCoord()) <= 11 && !this.genome.getNocturnal() && !housing.isSelfLighted()) {
            return EnumErrorCode.NOTLUCID.ordinal();
        }
        if (!(housing.getBiomeId() == yy.j.N || world.k(housing.getXCoord(), housing.getYCoord() + 3, housing.getZCoord()) || this.genome.getCaveDwelling() || housing.isSunlightSimulated())) {
            return EnumErrorCode.NOSKY.ordinal();
        }
        if (!this.checkBiomeHazard(world, housing.getTemperature(), housing.getHumidity(), housing.getXCoord(), housing.getYCoord(), housing.getZCoord())) {
            return EnumErrorCode.INVALIDBIOME.ordinal();
        }
        return EnumErrorCode.OK.ordinal();
    }

    private boolean checkBiomeHazard(yc world, EnumTemperature temperature, EnumHumidity humidity, int x, int y2, int z) {
        EnumTemperature beeTemperature = this.genome.getPrimaryAsBee().getTemperature();
        EnumTolerance temperatureTolerance = this.genome.getToleranceTemp();
        ArrayList toleratedTemperatures = ClimateHelper.getToleratedTemperature(beeTemperature, temperatureTolerance);
        boolean validTemp = false;
        validTemp = toleratedTemperatures.contains((Object)temperature);
        if (!validTemp) {
            return false;
        }
        EnumHumidity beeHumidity = this.genome.getPrimaryAsBee().getHumidity();
        EnumTolerance humidityTolerance = this.genome.getToleranceHumid();
        ArrayList toleratedHumidity = ClimateHelper.getToleratedHumidity(beeHumidity, humidityTolerance);
        boolean validHumidity = false;
        validHumidity = toleratedHumidity.contains((Object)humidity);
        return validHumidity;
    }

    @Override
    public boolean hasFlower(IBeeHousing housing) {
        IFlowerProvider provider = this.genome.getFlowerProvider();
        Vect coords = new Vect(housing.getXCoord(), housing.getYCoord(), housing.getZCoord());
        Vect posCurrent = new Vect(0, 0, 0);
        int[] areaAr = this.genome.getTerritory();
        Vect area = new Vect(areaAr[0], areaAr[1], areaAr[2]).multiply(housing.getTerritoryModifier(this.genome));
        if (area.x < 1) {
            area.x = 1;
        }
        if (area.y < 1) {
            area.y = 1;
        }
        if (area.z < 1) {
            area.z = 1;
        }
        Vect offset = new Vect(-Math.round(area.x / 2), -Math.round(area.y / 2), -Math.round(area.z / 2));
        boolean hasFlower = false;
        while (this.advancePosition(posCurrent, area)) {
            Vect posBlock = posCurrent.add(coords);
            posBlock = posBlock.add(offset);
            if (!provider.isAcceptedFlower(housing.getWorld(), this.genome, posBlock.x, posBlock.y, posBlock.z)) continue;
            hasFlower = true;
            break;
        }
        return hasFlower;
    }

    private boolean advancePosition(Vect posCurrent, Vect area) {
        if (posCurrent.z < area.z - 1) {
            ++posCurrent.z;
        } else {
            posCurrent.z = 0;
            if (posCurrent.x < area.x - 1) {
                ++posCurrent.x;
            } else {
                posCurrent.x = 0;
                if (posCurrent.y < area.y - 1) {
                    ++posCurrent.y;
                } else {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public ArrayList getSuitableBiomeIds() {
        EnumTemperature temperature = this.genome.getPrimaryAsBee().getTemperature();
        EnumTolerance temperatureTolerance = this.genome.getToleranceTemp();
        ArrayList toleratedTemperatures = ClimateHelper.getToleratedTemperature(temperature, temperatureTolerance);
        EnumHumidity humidity = this.genome.getPrimaryAsBee().getHumidity();
        EnumTolerance humidityTolerance = this.genome.getToleranceHumid();
        ArrayList toleratedHumidities = ClimateHelper.getToleratedHumidity(humidity, humidityTolerance);
        ArrayList biomeIdsTemp = new ArrayList();
        for (EnumTemperature temp : toleratedTemperatures) {
            biomeIdsTemp.addAll(EnumTemperature.getBiomeIds(temp));
        }
        ArrayList biomeIdsHumid = new ArrayList();
        for (EnumHumidity humid : toleratedHumidities) {
            biomeIdsHumid.addAll(EnumHumidity.getBiomeIds(humid));
        }
        biomeIdsTemp.retainAll(biomeIdsHumid);
        return biomeIdsTemp;
    }

    @Override
    public String getIdent() {
        return this.genome.getPrimaryAsBee().getUID();
    }

    @Override
    public String getDisplayName() {
        return this.genome.getPrimaryAsBee().getName();
    }

    @Override
    public int getHealth() {
        return this.health;
    }

    @Override
    public int getMaxHealth() {
        return this.maxHealth;
    }

    @Override
    public void addTooltip(List list) {
        if (!this.isAnalyzed) {
            list.add("<" + StringUtil.localize("gui.unknown") + ">");
            return;
        }
        IAlleleBeeSpecies primary = this.genome.getPrimaryAsBee();
        IAlleleBeeSpecies secondary = this.genome.getSecondaryAsBee();
        if (!this.isPureBred(EnumBeeChromosome.SPECIES)) {
            list.add("\u00a79" + primary.getName() + StringUtil.localize("bees.hyphen.adj.add") + "-" + secondary.getName() + StringUtil.localize("bees.hybrid.adj.add") + " " + StringUtil.localize("gui.hybrid"));
        }
        list.add(Bee.rateSpeed(this.genome.getSpeed()) + " " + StringUtil.localize("gui.worker"));
        list.add(Bee.rateLifespan(this.genome.getLifespan()) + " " + StringUtil.localize("gui.life"));
        list.add("\u00a7aT: " + ClimateHelper.toDisplay(this.genome.getPrimaryAsBee().getTemperature()) + " / " + StringUtil.capitalize(this.genome.getToleranceTemp().name()));
        list.add("\u00a7aH: " + ClimateHelper.toDisplay(this.genome.getPrimaryAsBee().getHumidity()) + " / " + StringUtil.capitalize(this.genome.getToleranceHumid().name()));
        list.add(StringUtil.localize(this.genome.getFlowerProvider().getDescription()));
        if (this.genome.getNocturnal()) {
            list.add("\u00a7c" + StringUtil.localize("gui.nocturnal"));
        }
    }

    @Override
    public ur[] getProduceList() {
        ArrayList<Object> products = new ArrayList<Object>();
        IAlleleBeeSpecies primary = this.genome.getPrimaryAsBee();
        IAlleleBeeSpecies secondary = this.genome.getSecondaryAsBee();
        products.addAll(primary.getProducts().keySet());
        Set secondaryProducts = secondary.getProducts().keySet();
        for (ur second : secondaryProducts) {
            boolean skip = false;
            for (ur ur2 : products) {
                if (!second.a(ur2)) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            products.add(second);
        }
        return products.toArray(new ur[0]);
    }

    @Override
    public ur[] getSpecialtyList() {
        return this.genome.getPrimaryAsBee().getSpecialty().keySet().toArray(new ur[0]);
    }

    @Override
    public ur[] produceStacks(IBeeHousing housing) {
        if (!this.hasFlower(housing)) {
            return null;
        }
        ArrayList<ur> products = new ArrayList<ur>();
        IAlleleBeeSpecies primary = this.genome.getPrimaryAsBee();
        IAlleleBeeSpecies secondary = this.genome.getSecondaryAsBee();
        float speed = this.genome.getSpeed() * housing.getProductionModifier(this.genome) * BeeManager.breedingManager.getBeekeepingMode(housing.getWorld()).getProductionModifier(this.genome);
        for (Map.Entry entry : primary.getProducts().entrySet()) {
            if (!((float)housing.getWorld().t.nextInt(100) < (float)((Integer)entry.getValue()).intValue() * speed)) continue;
            products.add(((ur)entry.getKey()).l());
        }
        for (Map.Entry entry : secondary.getProducts().entrySet()) {
            if (!((float)housing.getWorld().t.nextInt(100) < (float)Math.round((Integer)entry.getValue() / 2) * speed)) continue;
            products.add(((ur)entry.getKey()).l());
        }
        if (!primary.isJubilant(housing.getWorld(), housing.getBiomeId(), housing.getXCoord(), housing.getYCoord(), housing.getZCoord()) || !secondary.isJubilant(housing.getWorld(), housing.getBiomeId(), housing.getXCoord(), housing.getYCoord(), housing.getZCoord())) {
            return products.toArray(new ur[0]);
        }
        for (Map.Entry entry : primary.getSpecialty().entrySet()) {
            if (!((float)housing.getWorld().t.nextInt(100) < (float)((Integer)entry.getValue()).intValue() * speed)) continue;
            products.add(((ur)entry.getKey()).l());
        }
        return this.genome.getFlowerProvider().affectProducts(housing.getWorld(), this.genome, housing.getXCoord(), housing.getYCoord(), housing.getZCoord(), products.toArray(new ur[0]));
    }

    @Override
    public IBee spawnPrincess(IBeeHousing housing) {
        if (this.mate == null) {
            return null;
        }
        if (BeeManager.breedingManager.getBeekeepingMode(housing.getWorld()).isFatigued(this)) {
            return null;
        }
        return this.createOffspring(housing);
    }

    @Override
    public IBee[] spawnDrones(IBeeHousing housing) {
        yc world = housing.getWorld();
        if (this.mate == null) {
            return null;
        }
        ArrayList<IBee> bees = new ArrayList<IBee>();
        int toCreate = BeeManager.breedingManager.getBeekeepingMode(world).getFinalFertility(this, world, housing.getXCoord(), housing.getYCoord(), housing.getZCoord());
        if (toCreate <= 0) {
            toCreate = 1;
        }
        for (int i = 0; i < toCreate; ++i) {
            IBee offspring = this.createOffspring(housing);
            if (offspring == null) continue;
            bees.add(offspring);
        }
        if (bees.size() > 0) {
            return bees.toArray(new IBee[0]);
        }
        return null;
    }

    private IBee createOffspring(IBeeHousing housing) {
        IChromosome[] mutated2;
        yc world = housing.getWorld();
        IChromosome[] chromosomes = new IChromosome[this.genome.getChromosomes().length];
        IChromosome[] parent1 = this.genome.getChromosomes();
        IChromosome[] parent2 = this.mate.getChromosomes();
        IChromosome[] mutated1 = this.mutateSpecies(housing, this.genome, this.mate);
        if (mutated1 != null) {
            parent1 = mutated1;
        }
        if ((mutated2 = this.mutateSpecies(housing, this.mate, this.genome)) != null) {
            parent2 = mutated2;
        }
        for (int i = 0; i < parent1.length; ++i) {
            if (parent1[i] == null || parent2[i] == null) continue;
            chromosomes[i] = this.inheritChromosome(world.t, parent1[i], parent2[i]);
        }
        return new Bee(world, new BeeGenome(chromosomes), BeeManager.breedingManager.getBeekeepingMode(world).isNaturalOffspring(this), this.getGeneration() + 1);
    }

    private IChromosome[] mutateSpecies(IBeeHousing housing, IGenome genomeOne, IGenome genomeTwo) {
        IGenome genome1;
        IGenome genome0;
        IAllele allele1;
        IAllele allele0;
        yc world = housing.getWorld();
        IChromosome[] parent1 = genomeOne.getChromosomes();
        IChromosome[] parent2 = genomeTwo.getChromosomes();
        if (world.t.nextBoolean()) {
            allele0 = parent1[EnumBeeChromosome.SPECIES.ordinal()].getPrimaryAllele();
            allele1 = parent2[EnumBeeChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeOne;
            genome1 = genomeTwo;
        } else {
            allele0 = parent2[EnumBeeChromosome.SPECIES.ordinal()].getPrimaryAllele();
            allele1 = parent1[EnumBeeChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeTwo;
            genome1 = genomeOne;
        }
        Collections.shuffle(BeeManager.beeMutations);
        for (IBeeMutation mutation : BeeManager.beeMutations) {
            int chance = 0;
            if (BeeManager.breedingManager.isBlacklisted(mutation.getTemplate()[0].getUID()) || (chance = mutation.getChance(housing, allele0, allele1, genome0, genome1)) <= 0 || world.t.nextInt(100) >= chance) continue;
            IApiaristTracker breedingTracker = BeeManager.breedingManager.getApiaristTracker(world);
            breedingTracker.registerMutation(mutation);
            return BeeManager.beeInterface.templateAsChromosomes(mutation.getTemplate());
        }
        return null;
    }

    private IChromosome inheritChromosome(Random rand, IChromosome parent1, IChromosome parent2) {
        IAllele choice1 = rand.nextBoolean() ? parent1.getPrimaryAllele() : parent1.getSecondaryAllele();
        IAllele choice2 = rand.nextBoolean() ? parent2.getPrimaryAllele() : parent2.getSecondaryAllele();
        if (rand.nextBoolean()) {
            return new Chromosome(choice1, choice2);
        }
        return new Chromosome(choice2, choice1);
    }

    @Override
    public IIndividual retrievePollen(IBeeHousing housing) {
        if (housing.getWorld().t.nextInt(100) >= this.genome.getFlowering()) {
            return null;
        }
        int[] areaAr = this.genome.getTerritory();
        Vect area = new Vect(areaAr[0], areaAr[1], areaAr[2]).multiply(housing.getTerritoryModifier(this.genome)).multiply(2.0f);
        Vect offset = new Vect(-Math.round(area.x / 2), -Math.round(area.y / 2), -Math.round(area.z / 2));
        if (area.x < 1) {
            area.x = 1;
        }
        if (area.y < 1) {
            area.y = 1;
        }
        if (area.z < 1) {
            area.z = 1;
        }
        for (int i = 0; i < 10; ++i) {
            IIndividual pollen;
            Vect randomPos = new Vect(housing.getWorld().t.nextInt(area.x), housing.getWorld().t.nextInt(area.y), housing.getWorld().t.nextInt(area.z));
            Vect posBlock = randomPos.add(new Vect(housing.getXCoord(), housing.getYCoord(), housing.getZCoord()));
            posBlock = posBlock.add(offset);
            any tile = housing.getWorld().q(posBlock.x, posBlock.y, posBlock.z);
            if (!(tile instanceof IPollinatable) || (pollen = ((IPollinatable)tile).getPollen()) == null) continue;
            return pollen;
        }
        return null;
    }

    @Override
    public boolean pollinateRandom(IBeeHousing housing, IIndividual pollen) {
        if (housing.getWorld().t.nextInt(100) >= this.genome.getFlowering()) {
            return false;
        }
        int[] areaAr = this.genome.getTerritory();
        Vect area = new Vect(areaAr[0], areaAr[1], areaAr[2]).multiply(housing.getTerritoryModifier(this.genome)).multiply(2.0f);
        Vect offset = new Vect(-Math.round(area.x / 2), -Math.round(area.y / 2), -Math.round(area.z / 2));
        if (area.x < 1) {
            area.x = 1;
        }
        if (area.y < 1) {
            area.y = 1;
        }
        if (area.z < 1) {
            area.z = 1;
        }
        for (int i = 0; i < 10; ++i) {
            IPollinatable receiver;
            Vect randomPos = new Vect(housing.getWorld().t.nextInt(area.x), housing.getWorld().t.nextInt(area.y), housing.getWorld().t.nextInt(area.z));
            Vect posBlock = randomPos.add(new Vect(housing.getXCoord(), housing.getYCoord(), housing.getZCoord()));
            posBlock = posBlock.add(offset);
            any tile = housing.getWorld().q(posBlock.x, posBlock.y, posBlock.z);
            if (!(tile instanceof IPollinatable) || !(receiver = (IPollinatable)tile).canPollinateBy(pollen)) continue;
            receiver.pollinate(pollen);
            return true;
        }
        return false;
    }

    @Override
    public void plantFlowerRandom(IBeeHousing housing) {
        if (housing.getWorld().t.nextInt(100) >= this.genome.getFlowering()) {
            return;
        }
        IFlowerProvider provider = this.genome.getFlowerProvider();
        int[] areaAr = this.genome.getTerritory();
        Vect area = new Vect(areaAr[0], areaAr[1], areaAr[2]).multiply(housing.getTerritoryModifier(this.genome));
        Vect offset = new Vect(-Math.round(area.x / 2), -Math.round(area.y / 2), -Math.round(area.z / 2));
        if (area.x < 1) {
            area.x = 1;
        }
        if (area.y < 1) {
            area.y = 1;
        }
        if (area.z < 1) {
            area.z = 1;
        }
        for (int i = 0; i < 10; ++i) {
            Vect randomPos = new Vect(housing.getWorld().t.nextInt(area.x), housing.getWorld().t.nextInt(area.y), housing.getWorld().t.nextInt(area.z));
            Vect posBlock = randomPos.add(new Vect(housing.getXCoord(), housing.getYCoord(), housing.getZCoord()));
            posBlock = posBlock.add(offset);
            if (provider.growFlower(housing.getWorld(), this.genome, posBlock.x, posBlock.y, posBlock.z)) break;
        }
    }

    public static String rateSpeed(float speed) {
        if (speed >= 1.7f) {
            return StringUtil.localize("gui.fastestspeed");
        }
        if (speed >= 1.4f) {
            return StringUtil.localize("gui.fasterspeed");
        }
        if (speed >= 1.2f) {
            return StringUtil.localize("gui.fastspeed");
        }
        if (speed >= 1.0f) {
            return StringUtil.localize("gui.normalspeed");
        }
        if (speed >= 0.8f) {
            return StringUtil.localize("gui.slowspeed");
        }
        if (speed >= 0.6f) {
            return StringUtil.localize("gui.slowerspeed");
        }
        return StringUtil.localize("gui.slowestspeed");
    }

    public static String rateLifespan(int life) {
        if (life >= 70) {
            return StringUtil.localize("gui.longestlife");
        }
        if (life >= 60) {
            return StringUtil.localize("gui.longerlife");
        }
        if (life >= 50) {
            return StringUtil.localize("gui.longlife");
        }
        if (life >= 45) {
            return StringUtil.localize("gui.elongatedlife");
        }
        if (life >= 40) {
            return StringUtil.localize("gui.normallife");
        }
        if (life >= 35) {
            return StringUtil.localize("gui.shortenedlife");
        }
        if (life >= 30) {
            return StringUtil.localize("gui.shortlife");
        }
        if (life >= 20) {
            return StringUtil.localize("gui.shorterlife");
        }
        return StringUtil.localize("gui.shortestlife");
    }
}

