/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeInterface;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.BeeGenome;
import forestry.core.config.ForestryItem;
import forestry.core.genetics.Chromosome;

public class BeeHelper
implements IBeeInterface {
    @Override
    public boolean isBee(ur stack) {
        if (stack == null) {
            return false;
        }
        return stack.c == ForestryItem.beeDroneGE.cj || stack.c == ForestryItem.beePrincessGE.cj || stack.c == ForestryItem.beeQueenGE.cj;
    }

    @Override
    public boolean isDrone(ur stack) {
        if (stack == null) {
            return false;
        }
        return stack.c == ForestryItem.beeDroneGE.cj;
    }

    @Override
    public boolean isMated(ur stack) {
        if (stack == null) {
            return false;
        }
        return stack.c == ForestryItem.beeQueenGE.cj;
    }

    @Override
    public IBee getBee(ur stack) {
        if (stack.c != ForestryItem.beeQueenGE.cj && stack.c != ForestryItem.beePrincessGE.cj && stack.c != ForestryItem.beeDroneGE.cj) {
            return null;
        }
        return new Bee(stack.p());
    }

    @Override
    public IBee getBee(yc world, IBeeGenome genome) {
        return new Bee(world, genome);
    }

    @Override
    public IBee getBee(yc world, IBeeGenome genome, IBee mate) {
        return new Bee(world, genome, mate);
    }

    @Override
    public ur getBeeStack(IBee bee, EnumBeeType type) {
        up beeItem = null;
        switch (type) {
            case QUEEN: {
                beeItem = ForestryItem.beeQueenGE;
                break;
            }
            case PRINCESS: {
                beeItem = ForestryItem.beePrincessGE;
                break;
            }
            case DRONE: {
                beeItem = ForestryItem.beeDroneGE;
            }
        }
        bq nbttagcompound = new bq();
        bee.writeToNBT(nbttagcompound);
        ur beeStack = new ur(beeItem, 1, AlleleManager.alleleRegistry.getFromUIDMap(bee.getIdent()));
        beeStack.d(nbttagcompound);
        return beeStack;
    }

    public Chromosome[] templateAsChromosomes(IAllele[] template) {
        Chromosome[] chromosomes = new Chromosome[template.length];
        for (int i = 0; i < template.length; ++i) {
            if (template[i] == null) continue;
            chromosomes[i] = new Chromosome(template[i]);
        }
        return chromosomes;
    }

    public Chromosome[] templateAsChromosomes(IAllele[] templateActive, IAllele[] templateInactive) {
        Chromosome[] chromosomes = new Chromosome[templateActive.length];
        for (int i = 0; i < templateActive.length; ++i) {
            if (templateActive[i] == null) continue;
            chromosomes[i] = new Chromosome(templateActive[i], templateInactive[i]);
        }
        return chromosomes;
    }

    @Override
    public IBeeGenome templateAsGenome(IAllele[] template) {
        return new BeeGenome(this.templateAsChromosomes(template));
    }

    @Override
    public IBeeGenome templateAsGenome(IAllele[] templateActive, IAllele[] templateInactive) {
        return new BeeGenome(this.templateAsChromosomes(templateActive, templateInactive));
    }
}

