/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeekeepingMode;
import java.util.ArrayList;
import java.util.Random;

public class BeekeepingMode
implements IBeekeepingMode {
    public static IBeekeepingMode easy = new BeekeepingMode("EASY", 2.0f, 1.0f, 1.0f, false, false);
    public static IBeekeepingMode normal = new BeekeepingMode("NORMAL", 1.0f, 1.0f, 1.0f, false, true);
    public static IBeekeepingMode hard = new BeekeepingMode("HARD", 0.75f, 1.5f, 1.0f, false, true);
    public static IBeekeepingMode hardcore = new BeekeepingMode("HARDCORE", 0.5f, 5.0f, 0.8f, true, true);
    public static IBeekeepingMode insane = new BeekeepingMode("INSANE", 0.2f, 10.0f, 0.6f, true, true);
    final Random rand = new Random();
    final String name;
    final float mutationModifier;
    final float lifespanModifier;
    final float speedModifier;
    final boolean reducesFertility;
    final int fatigueArtifical = 50;
    final boolean canFatigue;

    public BeekeepingMode(String name, float mutationModifier, float lifespanModifier, float speedModifier, boolean reducesFertility, boolean canFatigue) {
        this.name = name;
        this.mutationModifier = mutationModifier;
        this.lifespanModifier = lifespanModifier;
        this.speedModifier = speedModifier;
        this.reducesFertility = reducesFertility;
        this.canFatigue = canFatigue;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ArrayList getDescription() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("beemode." + this.name.toLowerCase() + ".desc");
        return ret;
    }

    @Override
    public float getWearModifier() {
        return 1.0f;
    }

    @Override
    public float getMutationModifier(IBeeGenome genome, IBeeGenome mate) {
        return this.mutationModifier;
    }

    @Override
    public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate) {
        return this.lifespanModifier;
    }

    @Override
    public float getProductionModifier(IBeeGenome genome) {
        return this.speedModifier;
    }

    @Override
    public float getTerritoryModifier(IBeeGenome genome) {
        return 1.0f;
    }

    @Override
    public int getFinalFertility(IBee queen, yc world, int x, int y2, int z) {
        int toCreate = queen.getGenome().getFertility();
        if (this.reducesFertility) {
            toCreate = new Random().nextInt(toCreate);
        }
        return toCreate;
    }

    @Override
    public boolean isFatigued(IBee queen) {
        if (!this.canFatigue) {
            return false;
        }
        if (queen.isNatural()) {
            return false;
        }
        return this.rand.nextInt(50) < queen.getGeneration();
    }

    @Override
    public boolean isNaturalOffspring(IBee queen) {
        if (!queen.isNatural()) {
            return false;
        }
        return !queen.isIrregularMating() || !this.rand.nextBoolean();
    }

    @Override
    public boolean mayMultiplyPrincess(IBee queen) {
        return true;
    }
}

