/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import cpw.mods.fml.common.FMLCommonHandler;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IAlvearyComponent;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.apiculture.IBeekeepingMode;
import forestry.api.apiculture.IBreedingManager;
import forestry.api.core.IStructureLogic;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IApiaristTracker;
import forestry.apiculture.BeekeepingLogic;
import forestry.apiculture.gadgets.StructureLogicAlveary;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.BeeTemplates;
import forestry.apiculture.genetics.GenomeTracker;
import forestry.plugins.PluginForestryApiculture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class BreedingManager
implements IBreedingManager {
    public static int beeSpeciesCount = -1;
    ArrayList beekeepingModes = new ArrayList();
    public static IBeekeepingMode activeBeekeepingMode;
    private ArrayList blacklist = new ArrayList();
    public static HashMap speciesTemplates;
    public static ArrayList beeTemplates;

    @Override
    public int getBeeSpeciesCount() {
        if (beeSpeciesCount < 0) {
            beeSpeciesCount = 0;
            for (Map.Entry entry : AlleleManager.alleleRegistry.getRegisteredAlleles().entrySet()) {
                if (!(entry.getValue() instanceof IAlleleBeeSpecies) || !((IAlleleBeeSpecies)entry.getValue()).isCounted()) continue;
                ++beeSpeciesCount;
            }
        }
        return beeSpeciesCount;
    }

    @Override
    public ArrayList getBeekeepingModes() {
        return this.beekeepingModes;
    }

    @Override
    public IBeekeepingMode getBeekeepingMode(yc world) {
        if (activeBeekeepingMode != null) {
            return activeBeekeepingMode;
        }
        IApiaristTracker tracker = this.getApiaristTracker(world);
        String mode = tracker.getModeName();
        if (mode == null || mode.isEmpty()) {
            mode = PluginForestryApiculture.beekeepingMode;
        }
        this.setBeekeepingMode(world, mode);
        FMLCommonHandler.instance().getFMLLogger().fine("Set beekeeping mode for a world to " + mode);
        return activeBeekeepingMode;
    }

    @Override
    public void registerBeekeepingMode(IBeekeepingMode mode) {
        this.beekeepingModes.add(mode);
    }

    @Override
    public void setBeekeepingMode(yc world, String name) {
        activeBeekeepingMode = this.getBeekeepingMode(name);
        this.getApiaristTracker(world).setModeName(name);
    }

    @Override
    public IBeekeepingMode getBeekeepingMode(String name) {
        for (IBeekeepingMode mode : this.beekeepingModes) {
            if (!mode.getName().equals(name)) continue;
            return mode;
        }
        return null;
    }

    @Override
    public void blacklistBeeSpecies(String uid) {
        this.blacklist.add(uid);
    }

    @Override
    public ArrayList getBeeSpeciesBlacklist() {
        return this.blacklist;
    }

    @Override
    public boolean isBlacklisted(String uid) {
        return this.blacklist.contains(uid);
    }

    @Override
    public void registerBeeTemplate(IAllele[] template) {
        this.registerBeeTemplate(template[0].getUID(), template);
    }

    @Override
    public void registerBeeTemplate(String identifier, IAllele[] template) {
        beeTemplates.add(new Bee(BeeManager.beeInterface.templateAsGenome(template)));
        speciesTemplates.put(identifier, template);
    }

    @Override
    public IAllele[] getBeeTemplate(String identifier) {
        return (IAllele[])speciesTemplates.get(identifier);
    }

    @Override
    public IAllele[] getDefaultBeeTemplate() {
        return BeeTemplates.getDefaultTemplate();
    }

    @Override
    public IApiaristTracker getApiaristTracker(yc world) {
        GenomeTracker tracker = (GenomeTracker)world.a(GenomeTracker.class, "ApiaristTracker");
        if (tracker == null) {
            tracker = new GenomeTracker("ApiaristTracker");
            world.a("ApiaristTracker", (ahq)tracker);
        }
        return tracker;
    }

    @Override
    public IBeekeepingLogic createBeekeepingLogic(IBeeHousing housing) {
        return new BeekeepingLogic(housing);
    }

    @Override
    public IStructureLogic createAlvearyStructureLogic(IAlvearyComponent structure) {
        return new StructureLogicAlveary(structure);
    }

    static {
        speciesTemplates = new HashMap();
        beeTemplates = new ArrayList();
    }
}

