/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IApiaristTracker;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import java.util.ArrayList;

public class GenomeTracker
extends ahq
implements IApiaristTracker {
    private ArrayList discoveredSpecies = new ArrayList(256);
    private ArrayList discoveredMutations = new ArrayList();
    private String beekeepingModeName;
    private int queensTotal = 0;
    private int dronesTotal = 0;
    private int princessesTotal = 0;

    public GenomeTracker(String s2) {
        super(s2);
    }

    @Override
    public String getModeName() {
        return this.beekeepingModeName;
    }

    @Override
    public void setModeName(String name) {
        this.beekeepingModeName = name;
        this.c();
    }

    @Override
    public void decodeFromNBT(bq nbttagcompound) {
        this.a(nbttagcompound);
    }

    @Override
    public void encodeToNBT(bq nbttagcompound) {
        this.b(nbttagcompound);
    }

    public void a(bq nbttagcompound) {
        int i;
        this.queensTotal = nbttagcompound.e("QueensTotal");
        this.princessesTotal = nbttagcompound.e("PrincessesTotal");
        this.dronesTotal = nbttagcompound.e("DronesTotal");
        if (nbttagcompound.b("BMS")) {
            this.beekeepingModeName = nbttagcompound.i("BMS");
        }
        this.discoveredSpecies = new ArrayList(256);
        int count = nbttagcompound.e("SpeciesCount");
        for (i = 0; i < count; ++i) {
            this.discoveredSpecies.add(nbttagcompound.i("SD" + i));
        }
        this.discoveredMutations = new ArrayList();
        count = nbttagcompound.e("MutationsCount");
        for (i = 0; i < count; ++i) {
            this.discoveredMutations.add(nbttagcompound.i("MD" + i));
        }
    }

    public void b(bq nbttagcompound) {
        int i;
        nbttagcompound.a("QueensTotal", this.queensTotal);
        nbttagcompound.a("PrincessesTotal", this.princessesTotal);
        nbttagcompound.a("DronesTotal", this.dronesTotal);
        if (this.beekeepingModeName != null && !this.beekeepingModeName.isEmpty()) {
            nbttagcompound.a("BMS", this.beekeepingModeName);
        }
        nbttagcompound.a("SpeciesCount", this.discoveredSpecies.size());
        for (i = 0; i < this.discoveredSpecies.size(); ++i) {
            if (this.discoveredSpecies.get(i) == null) continue;
            nbttagcompound.a("SD" + i, (String)this.discoveredSpecies.get(i));
        }
        nbttagcompound.a("MutationsCount", this.discoveredMutations.size());
        for (i = 0; i < this.discoveredMutations.size(); ++i) {
            if (this.discoveredMutations.get(i) == null) continue;
            nbttagcompound.a("MD" + i, (String)this.discoveredMutations.get(i));
        }
    }

    @Override
    public void registerQueen(qx player, IIndividual bee) {
        ++this.queensTotal;
    }

    @Override
    public int getQueenCount() {
        return this.queensTotal;
    }

    @Override
    public void registerPrincess(qx player, IIndividual bee) {
        ++this.princessesTotal;
        IAlleleSpecies primary = bee.getGenome().getPrimary();
        IAlleleSpecies secondary = bee.getGenome().getSecondary();
        this.registerSpecies(primary);
        this.registerSpecies(secondary);
        this.c();
    }

    @Override
    public int getPrincessCount() {
        return this.princessesTotal;
    }

    @Override
    public void registerDrone(qx player, IIndividual bee) {
        ++this.dronesTotal;
        IAlleleSpecies primary = bee.getGenome().getPrimary();
        IAlleleSpecies secondary = bee.getGenome().getSecondary();
        this.registerSpecies(primary);
        this.registerSpecies(secondary);
        this.c();
    }

    @Override
    public int getDroneCount() {
        return this.dronesTotal;
    }

    @Override
    public void registerMutation(IMutation mutation) {
        this.discoveredMutations.add(mutation.getAllele0().getUID() + "-" + mutation.getAllele1().getUID());
        this.c();
    }

    private void registerSpecies(IAllele species) {
        if (!this.discoveredSpecies.contains(species.getUID())) {
            this.discoveredSpecies.add(species.getUID());
        }
    }

    @Override
    public boolean isDiscovered(IMutation mutation) {
        return this.discoveredMutations.contains(mutation.getAllele0().getUID() + "-" + mutation.getAllele1().getUID());
    }

    @Override
    public boolean isDiscovered(IAlleleSpecies species) {
        return this.discoveredSpecies.contains(species.getUID());
    }

    @Override
    public int getSpeciesBred() {
        return this.discoveredSpecies.size();
    }
}

