/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import cpw.mods.fml.common.FMLLog;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import forestry.apiculture.genetics.MutationReqRes;
import forestry.core.utils.Vect;
import java.lang.reflect.Field;

public class MutationEMC
extends MutationReqRes {
    int emcRequired = 0;
    Class condenserClass;
    Field emcField;

    public MutationEMC(IAllele allele0, IAllele allele1, IAllele[] template, int chance, ur blockRequired, Class condenserClass, Field emcField, int emcRequired) {
        super(allele0, allele1, template, chance, blockRequired);
        this.condenserClass = condenserClass;
        this.emcField = emcField;
        this.emcRequired = emcRequired;
    }

    @Override
    public int getChance(IBeeHousing housing, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1) {
        Vect[] possibleTargets;
        int chance = super.getChance(housing, allele0, allele1, genome0, genome1);
        if (chance <= 0) {
            return 0;
        }
        if (this.emcRequired <= 0) {
            return chance;
        }
        yc world = housing.getWorld();
        for (Vect target : possibleTargets = new Vect[]{new Vect(housing.getXCoord() + 1, housing.getYCoord(), housing.getZCoord()), new Vect(housing.getXCoord() - 1, housing.getYCoord(), housing.getZCoord()), new Vect(housing.getXCoord(), housing.getYCoord(), housing.getZCoord() + 1), new Vect(housing.getXCoord(), housing.getYCoord(), housing.getZCoord() - 1)}) {
            any entity;
            if (!world.f(target.x, target.y, target.z) || (entity = world.q(target.x, target.y, target.z)) == null) continue;
            if (!this.condenserClass.isInstance(entity)) {
                FMLLog.warning((String)("Did not find a relay at " + target.toString()), (Object[])new Object[0]);
                continue;
            }
            int emc = 0;
            try {
                emc = this.emcField.getInt(entity);
            }
            catch (Exception ex) {
                FMLLog.warning((String)"Failed to fetch EMC information.", (Object[])new Object[0]);
            }
            if (emc < this.emcRequired * 80) continue;
            boolean removedEMC = false;
            try {
                this.emcField.set(entity, emc - this.emcRequired * 80);
                removedEMC = true;
            }
            catch (Exception ex) {
                FMLLog.warning((String)"Failed to set EMC information.", (Object[])new Object[0]);
            }
            if (!removedEMC) continue;
            return chance;
        }
        return 0;
    }
}

