/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gui;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.genetics.IApiaristTracker;
import forestry.api.genetics.IMutation;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.BeeTemplates;
import forestry.apiculture.items.ItemBeeGE;
import forestry.core.config.ForestryItem;
import forestry.core.genetics.EnumMutateChance;
import forestry.core.gui.ContainerForestry;
import forestry.core.gui.ContainerItemInventory;
import forestry.core.gui.GuiForestry;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ItemInventory;
import forestry.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import org.lwjgl.opengl.GL11;

public class GuiApiaristInventory
extends GuiForestry {
    private la inventory;
    private int startX;
    private int startY;
    private IBee bee;
    private IApiaristTracker breedingTracker;
    private HashMap iconStacks = new HashMap();

    public GuiApiaristInventory(qx player, ContainerForestry container, la inventory) {
        super("/gfx/forestry/gui/apiaristinventory.png", container, inventory, 5, 25);
        this.inventory = inventory;
        this.xSize = 196;
        this.ySize = 202;
        ArrayList beeList = new ArrayList();
        ((ItemBeeGE)ForestryItem.beeDroneGE).addCreativeItems(beeList, false);
        for (ur beeStack : beeList) {
            this.iconStacks.put(BeeManager.beeInterface.getBee(beeStack).getIdent(), beeStack);
        }
        this.breedingTracker = BeeManager.breedingManager.getApiaristTracker(player.p);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
        int tex = this.f.o.b(this.textureFile);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.f.o.b(tex);
        this.b(this.startX, this.startY, 0, 0, this.xSize, this.ySize);
        String header = StringUtil.localize("gui.page") + " " + (this.pageCurrent + 1) + "/" + this.pageMax;
        this.l.b(header, this.startX + 95 + this.getCenteredOffset(header, 98), this.startY + 10, this.fontColor.get("gui.title"));
        if (this.bee == null) {
            this.displayBreedingStatistics(this.startX + 8, this.startY + 8);
        }
        if (this.bee != null) {
            arw.c();
            this.displaySpeciesInformation(true, this.bee.getGenome().getPrimaryAsBee(), (ur)this.iconStacks.get(this.bee.getIdent()), this.startX + 8, this.startY + 8);
            if (!this.bee.isPureBred(EnumBeeChromosome.SPECIES)) {
                this.displaySpeciesInformation(this.bee.isAnalyzed(), this.bee.getGenome().getSecondaryAsBee(), (ur)this.iconStacks.get(this.bee.getGenome().getSecondaryAsBee().getUID()), this.startX + 8, this.startY + 58);
            }
        }
    }

    @Override
    public void b() {
        super.b();
        if (this.f.g == null) {
            return;
        }
        if (this.inventorySlots instanceof ContainerItemInventory) {
            ((ContainerItemInventory)this.inventorySlots).purgeBag((qx)this.f.g);
        }
        if (!Proxies.common.isSimulating(Proxies.common.getRenderWorld())) {
            return;
        }
        if (this.inventory instanceof ItemInventory) {
            ItemInventory inv = (ItemInventory)this.inventory;
            if (inv.isItemInventory) {
                inv.onGuiSaved((qx)this.f.g);
            }
        }
    }

    @Override
    public void A_() {
        super.A_();
        this.startX = (this.g - this.xSize) / 2;
        this.startY = (this.h - this.ySize) / 2;
        this.i.add(new atb(1, this.startX + 99, this.startY + 7, 10, 12, "<"));
        this.i.add(new atb(2, this.startX + 179, this.startY + 7, 10, 12, ">"));
    }

    protected void a(atb guibutton) {
        super.a(guibutton);
        if (guibutton.f == 1 && this.pageCurrent > 0) {
            this.flipPage(this.pageCurrent - 1);
        } else if (guibutton.f == 2 && this.pageCurrent < this.pageMax - 1) {
            this.flipPage(this.pageCurrent + 1);
        }
    }

    protected void b(int i, int j, int k) {
        super.b(i, j, k);
        sr slot = this.getSlotAtPosition(i, j);
        if (slot == null) {
            this.resetAnalyzer();
            return;
        }
        if (!slot.d()) {
            this.resetAnalyzer();
            return;
        }
        ur itemstack = slot.c();
        if (!BeeManager.beeInterface.isBee(itemstack)) {
            this.resetAnalyzer();
            return;
        }
        this.updateAnalyzer(itemstack);
    }

    private void resetAnalyzer() {
        this.bee = null;
    }

    private void updateAnalyzer(ur itemstack) {
        bq nbttagcompound = itemstack.p();
        if (nbttagcompound == null) {
            return;
        }
        this.bee = new Bee(nbttagcompound);
    }

    private void displayBreedingStatistics(int x, int y2) {
        this.l.b(StringUtil.localize("gui.speciescount") + ": " + this.breedingTracker.getSpeciesBred() + "/" + BeeManager.breedingManager.getBeeSpeciesCount(), x + 2, y2 + 4, this.fontColor.get("gui.screen"));
        this.l.b(StringUtil.localize("gui.queens") + ": " + this.breedingTracker.getQueenCount(), x + 2, y2 + 20, this.fontColor.get("gui.screen"));
        this.l.b(StringUtil.localize("gui.princesses") + ": " + this.breedingTracker.getPrincessCount(), x + 2, y2 + 36, this.fontColor.get("gui.screen"));
        this.l.b(StringUtil.localize("gui.drones") + ": " + this.breedingTracker.getDroneCount(), x + 2, y2 + 52, this.fontColor.get("gui.screen"));
    }

    private void displaySpeciesInformation(boolean analyzed, IAlleleBeeSpecies species, ur iconStack, int x, int y2) {
        if (!analyzed) {
            this.l.b(StringUtil.localize("gui.unknown"), x + 2, y2 + 4, this.fontColor.get("gui.screen"));
            return;
        }
        this.l.b(species.getName(), x + 2, y2 + 4, this.fontColor.get("gui.screen"));
        itemRenderer.a(this.l, this.f.o, iconStack, x + 69, y2 + 1);
        itemRenderer.c(this.l, this.f.o, iconStack, x + 69, y2 + 1);
        int i = 0;
        for (IMutation combination : BeeTemplates.getCombinations(species)) {
            int column;
            int line;
            if (combination.isSecret()) continue;
            if (i > 4) {
                line = y2 + 36;
                column = x + (i - 5) * 18;
            } else {
                line = y2 + 18;
                column = x + i * 18;
            }
            if (this.breedingTracker.isDiscovered(combination)) {
                this.drawMutationIcon(combination, species, column, line);
            } else {
                this.drawUnknownIcon(combination, column, line);
            }
            ++i;
        }
    }

    private void drawMutationIcon(IMutation combination, IAlleleBeeSpecies species, int x, int y2) {
        itemRenderer.a(this.l, this.f.o, (ur)this.iconStacks.get(combination.getPartner(species).getUID()), x, y2);
        itemRenderer.c(this.l, this.f.o, (ur)this.iconStacks.get(combination.getPartner(species).getUID()), x, y2);
        int line = 48;
        int column = 0;
        EnumMutateChance chance = EnumMutateChance.rateChance(combination.getBaseChance());
        if (chance == EnumMutateChance.HIGHEST) {
            line += 16;
            column = 228;
        } else if (chance == EnumMutateChance.HIGHER) {
            line += 16;
            column = 212;
        } else if (chance == EnumMutateChance.HIGH) {
            line += 16;
            column = 196;
        } else if (chance == EnumMutateChance.NORMAL) {
            line += 0;
            column = 228;
        } else if (chance == EnumMutateChance.LOW) {
            line += 0;
            column = 212;
        } else {
            line += 0;
            column = 196;
        }
        this.f.o.b(this.f.o.b("/gfx/forestry/gui/apiaristinventory.png"));
        this.b(x, y2, column, line, 16, 16);
    }

    private void drawUnknownIcon(IMutation mutation, int x, int y2) {
        int chance = mutation.getBaseChance();
        int line = 0;
        int column = 0;
        if (chance >= 20) {
            line = 16;
            column = 228;
        } else if (chance >= 15) {
            line = 16;
            column = 212;
        } else if (chance >= 12) {
            line = 16;
            column = 196;
        } else if (chance >= 10) {
            line = 0;
            column = 228;
        } else if (chance >= 5) {
            line = 0;
            column = 212;
        } else {
            line = 0;
            column = 196;
        }
        this.f.o.b(this.f.o.b("/gfx/forestry/gui/apiaristinventory.png"));
        this.b(x, y2, column, line, 16, 16);
    }
}

