/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBee;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.BreedingManager;
import forestry.core.genetics.ItemGE;
import forestry.core.utils.StringUtil;
import java.util.List;

public class ItemBeeGE
extends ItemGE {
    EnumBeeType type;

    public ItemBeeGE(int i, EnumBeeType type) {
        super(i);
        this.type = type;
        this.setTextureFile("/gfx/forestry/items/bees.png");
        this.a(tj.f);
        if (type != EnumBeeType.DRONE) {
            this.d(1);
        }
    }

    @Override
    protected int getDefaultPrimaryColour() {
        return 0xFFFFFF;
    }

    @Override
    protected int getDefaultSecondaryColour() {
        return 16768022;
    }

    public boolean e(ur itemstack) {
        Bee individual = new Bee(itemstack.p());
        return individual.hasEffect();
    }

    public String l(ur itemstack) {
        if (itemstack.p() == null) {
            return StringUtil.localize(this.type.getName());
        }
        Bee individual = new Bee(itemstack.p());
        String name = individual.getDisplayName() + StringUtil.localize(this.type.getName() + ".adj.add") + " " + StringUtil.localize(this.type.getName());
        if (individual.isNatural()) {
            return name;
        }
        return name + " [-]";
    }

    public void a(int par1, tj par2CreativeTabs, List itemList) {
        if (this.type == EnumBeeType.QUEEN) {
            return;
        }
        this.addCreativeItems(itemList, true);
    }

    public void addCreativeItems(List itemList, boolean hideSecrets) {
        for (IBee individual : BreedingManager.beeTemplates) {
            if (hideSecrets && individual.isSecret()) continue;
            bq nbttagcompound = new bq();
            ur someStack = new ur((up)this, 1, AlleleManager.alleleRegistry.getFromUIDMap(individual.getIdent()));
            individual.writeToNBT(nbttagcompound);
            someStack.d(nbttagcompound);
            itemList.add(someStack);
        }
    }

    public void a(ur itemstack, qx player, List list, boolean flag) {
        if (itemstack.p() == null) {
            return;
        }
        Bee individual = new Bee(itemstack.p());
        individual.addTooltip(list);
    }

    @Override
    public int a(ur itemstack, int renderPass) {
        if (!itemstack.o()) {
            return super.a(itemstack, renderPass);
        }
        IAlleleSpecies species = BeeManager.beeInterface.getBee(itemstack).getGenome().getPrimary();
        if (species != null) {
            if (renderPass == 0) {
                return species.getPrimaryColor();
            }
            if (renderPass == 1) {
                return species.getSecondaryColor();
            }
            return 0xFFFFFF;
        }
        return 0xFFFFFF;
    }

    public int getIconIndex(ur itemstack, int renderPass) {
        IAlleleSpecies species = BeeManager.beeInterface.getBee(itemstack).getGenome().getPrimary();
        int indexOffset = 0;
        if (species != null) {
            indexOffset = 16 * species.getBodyType();
        }
        if (renderPass == 0) {
            return indexOffset + 0 + this.type.ordinal();
        }
        if (renderPass == 1) {
            return indexOffset + 3 + this.type.ordinal();
        }
        return indexOffset + 6 + this.type.ordinal();
    }
}

