/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.items;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBee;
import forestry.api.core.ForestryAPI;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.config.ForestryItem;
import forestry.core.interfaces.IErrorSource;
import forestry.core.interfaces.IHintSource;
import forestry.core.interfaces.IInventoriedItem;
import forestry.core.items.ItemForestry;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ItemInventory;
import forestry.core.utils.Vect;
import java.util.ArrayList;

public class ItemHabitatLocator
extends ItemForestry
implements IInventoriedItem {
    public ItemHabitatLocator(int id) {
        super(id);
        this.ck = 1;
        this.a(tj.i);
    }

    public ur a(ur itemstack, yc world, qx entityplayer) {
        if (Proxies.common.isSimulating(world)) {
            entityplayer.openGui(ForestryAPI.instance, GuiId.HabitatLocatorGUI.ordinal(), world, (int)entityplayer.t, (int)entityplayer.u, (int)entityplayer.v);
        }
        return itemstack;
    }

    public void startBiomeSearch(yc world, qx player, ArrayList biomesToSearch) {
        ArrayList<Integer> excludedBiomes = new ArrayList<Integer>();
        excludedBiomes.add(yy.b.N);
        excludedBiomes.add(yy.l.N);
        excludedBiomes.add(yy.r.N);
        biomesToSearch.removeAll(excludedBiomes);
        yy biome = world.a((int)player.t, (int)player.v);
        if (biomesToSearch.contains(biome.N)) {
            Proxies.common.setBiomeFinderCoordinates(player, new s((int)player.t, (int)player.u, (int)player.v));
            return;
        }
        if (Proxies.common.isSimulating(world) && biomesToSearch.size() > 0) {
            s target = this.findNearestBiome(player, biomesToSearch);
            Proxies.common.setBiomeFinderCoordinates(player, target);
        }
    }

    private s findNearestBiome(qx player, ArrayList biomesToSearch) {
        int loadChunkDistance = 25;
        s coordinates = null;
        Vect pos = new Vect((int)player.t, (int)player.u, (int)player.v);
        for (int i = 0; i < 100; ++i) {
            coordinates = this.getChunkCoordinates(pos.add(new Vect(10 * i, 0, 0)), player.p, biomesToSearch, i < loadChunkDistance);
            if (coordinates != null) {
                return coordinates;
            }
            coordinates = this.getChunkCoordinates(pos.add(new Vect(10 * i, 0, 10 * i)), player.p, biomesToSearch, i < loadChunkDistance);
            if (coordinates != null) {
                return coordinates;
            }
            coordinates = this.getChunkCoordinates(pos.add(new Vect(10 * i, 0, -10 * i)), player.p, biomesToSearch, i < loadChunkDistance);
            if (coordinates != null) {
                return coordinates;
            }
            coordinates = this.getChunkCoordinates(pos.add(new Vect(-10 * i, 0, 0)), player.p, biomesToSearch, i < loadChunkDistance);
            if (coordinates != null) {
                return coordinates;
            }
            coordinates = this.getChunkCoordinates(pos.add(new Vect(-10 * i, 0, 10 * i)), player.p, biomesToSearch, i < loadChunkDistance);
            if (coordinates != null) {
                return coordinates;
            }
            coordinates = this.getChunkCoordinates(pos.add(new Vect(-10 * i, 0, -10 * i)), player.p, biomesToSearch, i < loadChunkDistance);
            if (coordinates != null) {
                return coordinates;
            }
            coordinates = this.getChunkCoordinates(pos.add(new Vect(0, 0, 10 * i)), player.p, biomesToSearch, i < loadChunkDistance);
            if (coordinates != null) {
                return coordinates;
            }
            coordinates = this.getChunkCoordinates(pos.add(new Vect(0, 0, -10 * i)), player.p, biomesToSearch, i < loadChunkDistance);
            if (coordinates == null) continue;
            return coordinates;
        }
        return coordinates;
    }

    private s getChunkCoordinates(Vect pos, yc world, ArrayList biomesToSearch, boolean loadChunks) {
        yy biome = world.a(pos.x, pos.z);
        if (biomesToSearch.contains(biome.N)) {
            return new s(pos.x, pos.y, pos.z);
        }
        return null;
    }

    public static class HabitatLocatorInventory
    extends ItemInventory
    implements IErrorSource,
    IHintSource {
        public ArrayList biomesToSearch = new ArrayList();
        private short energySlot = (short)2;
        private short specimenSlot = 0;
        private short analyzeSlot = 1;

        public HabitatLocatorInventory() {
            super(3);
        }

        public HabitatLocatorInventory(ur itemstack) {
            super(3, itemstack);
        }

        @Override
        public void writeToNBT(bq nbttagcompound) {
            by nbttaglist = new by();
            for (int i = 2; i < this.inventoryStacks.length; ++i) {
                if (this.inventoryStacks[i] == null) continue;
                bq nbttagcompound1 = new bq();
                nbttagcompound1.a("Slot", (byte)i);
                this.inventoryStacks[i].b(nbttagcompound1);
                nbttaglist.a((cd)nbttagcompound1);
            }
            nbttagcompound.a("Items", (cd)nbttaglist);
        }

        private boolean isEnergy(ur itemstack) {
            if (itemstack == null || itemstack.a <= 0) {
                return false;
            }
            return itemstack.c == ForestryItem.honeyDrop.cj || itemstack.c == ForestryItem.honeydew.cj;
        }

        private void tryAnalyze() {
            if (this.inventoryStacks[this.analyzeSlot] != null) {
                return;
            }
            if (this.a(this.specimenSlot) == null) {
                return;
            }
            IBee bee = BeeManager.beeInterface.getBee(this.a(this.specimenSlot));
            if (bee == null) {
                return;
            }
            if (!this.isEnergy(this.a(this.energySlot))) {
                return;
            }
            this.biomesToSearch = bee.getSuitableBiomeIds();
            this.a((int)this.energySlot, 1);
            this.a((int)this.analyzeSlot, this.a(this.specimenSlot));
            this.a((int)this.specimenSlot, null);
        }

        @Override
        public void d() {
            this.tryAnalyze();
        }

        @Override
        public boolean hasHints() {
            return Config.hints.get("habitatlocator") != null && ((String[])Config.hints.get("habitatlocator")).length > 0;
        }

        @Override
        public String[] getHints() {
            return (String[])Config.hints.get("habitatlocator");
        }

        @Override
        public boolean throwsErrors() {
            return true;
        }

        @Override
        public EnumErrorCode getErrorState() {
            if (BeeManager.beeInterface.isBee(this.inventoryStacks[this.specimenSlot]) && !this.isEnergy(this.a(this.energySlot))) {
                return EnumErrorCode.NOHONEY;
            }
            return EnumErrorCode.OK;
        }
    }
}

