/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ITree;
import forestry.api.genetics.IBranch;
import forestry.arboriculture.worldgen.WorldGenBalsa;
import forestry.core.genetics.AlleleSpecies;
import net.minecraftforge.common.EnumPlantType;

public class AlleleTreeSpecies
extends AlleleSpecies
implements IAlleleTreeSpecies {
    private Class generatorClass = WorldGenBalsa.class;
    private int girth = 1;
    private EnumPlantType nativeType = EnumPlantType.Plains;

    public AlleleTreeSpecies(String uid, boolean isDominant, String name, IBranch branch, String binomial, int primaryColor, int secondaryColor) {
        super(uid, isDominant, name, branch, binomial, primaryColor, secondaryColor);
    }

    public AlleleTreeSpecies(String uid, boolean isDominant, String name, IBranch branch, String binomial, int primaryColor, int secondaryColor, Class generator) {
        super(uid, isDominant, name, branch, binomial, primaryColor, secondaryColor);
        this.generatorClass = generator;
    }

    public AlleleSpecies setPlantType(EnumPlantType type) {
        this.nativeType = type;
        return this;
    }

    public AlleleSpecies setGirth(int girth) {
        this.girth = girth;
        return this;
    }

    @Override
    public EnumPlantType getPlantType() {
        return this.nativeType;
    }

    @Override
    public int getGirth() {
        return this.girth;
    }

    @Override
    public abm getTreeGenerator(ITree tree) {
        try {
            return (abm)this.generatorClass.getConstructor(ITree.class).newInstance(tree);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to instantiate generator of class " + this.generatorClass.getName());
        }
    }

    @Override
    public boolean usesDefaultTexture() {
        return true;
    }

    @Override
    public String getTextureFile() {
        return "/gfx/forestry/items/crated.png";
    }

    @Override
    public int getGermlingIconIndex(EnumGermlingType type) {
        return this.getBodyType();
    }

    public AlleleTreeSpecies setGenerator(Class generatorClass) {
        this.generatorClass = generatorClass;
        return this;
    }
}

