/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.EnumGrowthConditions;
import forestry.api.arboriculture.IGrowthProvider;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.arboriculture.gadgets.TileSapling;
import forestry.core.utils.Vect;

public class GrowthProvider
implements IGrowthProvider {
    @Override
    public boolean canGrow(ITreeGenome genome, yc world, int xPos, int yPos, int zPos, int expectedGirth, int expectedHeight) {
        return this.hasRoom(genome, world, xPos, yPos, zPos, expectedGirth, expectedHeight) && this.getGrowthConditions(genome, world, xPos, yPos, zPos) != EnumGrowthConditions.HOSTILE && this.hasSufficientSaplings(genome, world, xPos, yPos, zPos, expectedGirth);
    }

    @Override
    public EnumGrowthConditions getGrowthConditions(ITreeGenome genome, yc world, int xPos, int yPos, int zPos) {
        return this.getConditionFromLight(world, xPos, yPos, zPos);
    }

    @Override
    public String getDescription() {
        return "Forest";
    }

    @Override
    public String[] getInfo() {
        return new String[0];
    }

    protected EnumGrowthConditions getConditionFromLight(yc world, int xPos, int yPos, int zPos) {
        int lightvalue = world.m(xPos, yPos + 1, zPos);
        if (lightvalue > 13) {
            return EnumGrowthConditions.EXCELLENT;
        }
        if (lightvalue > 11) {
            return EnumGrowthConditions.GOOD;
        }
        if (lightvalue > 8) {
            return EnumGrowthConditions.NORMAL;
        }
        if (lightvalue > 6) {
            return EnumGrowthConditions.PALTRY;
        }
        return EnumGrowthConditions.HOSTILE;
    }

    protected boolean hasRoom(ITreeGenome genome, yc world, int xPos, int yPos, int zPos, int expectedGirth, int expectedHeight) {
        return this.checkArea(world, new Vect(xPos - 1, yPos + 1, zPos + 1), new Vect(expectedGirth + 2, expectedHeight + 1, expectedGirth + 2));
    }

    protected final boolean checkArea(yc world, Vect start, Vect area) {
        for (int x = start.x; x < start.x + area.x; ++x) {
            for (int y2 = start.y; y2 < start.y + area.y; ++y2) {
                for (int z = start.z; z < start.z + area.z; ++z) {
                    if (world.c(x, y2, z)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean hasSufficientSaplings(ITreeGenome genome, yc world, int xPos, int yPos, int zPos, int expectedGirth) {
        if (expectedGirth == 1) {
            return true;
        }
        int offset = (expectedGirth - 1) / 2;
        for (int x = xPos; x < xPos - offset + expectedGirth; ++x) {
            for (int z = zPos; z < zPos - offset + expectedGirth; ++z) {
                if (world.c(x, yPos, z)) {
                    return false;
                }
                any tile = world.q(x, yPos, z);
                if (!(tile instanceof TileSapling)) {
                    return false;
                }
                ITree tree = ((TileSapling)tile).getTree();
                if (tree.getGenome().getPrimary().getUID().equals(genome.getPrimary().getUID())) continue;
                return false;
            }
        }
        return true;
    }
}

