/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.EnumGrowthConditions;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.genetics.IEffectData;
import forestry.arboriculture.genetics.TreeGenome;
import forestry.core.genetics.Individual;
import forestry.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.IPlantable;

public class Tree
extends Individual
implements ITree,
IPlantable {
    private ITreeGenome genome;
    private ITreeGenome mate;
    private EnumPlantType plantType;

    public Tree(bq nbttagcompound) {
        this.readFromNBT(nbttagcompound);
    }

    public Tree(ITreeGenome genome) {
        this.genome = genome;
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        if (nbttagcompound.b("Genome")) {
            this.genome = new TreeGenome(nbttagcompound.l("Genome"));
        }
        if (nbttagcompound.b("Mate")) {
            this.mate = new TreeGenome(nbttagcompound.l("Mate"));
        }
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        bq NBTmachine;
        super.writeToNBT(nbttagcompound);
        if (this.genome != null) {
            NBTmachine = new bq();
            this.genome.writeToNBT(NBTmachine);
            nbttagcompound.a("Genome", (cd)NBTmachine);
        }
        if (this.mate != null) {
            NBTmachine = new bq();
            this.mate.writeToNBT(NBTmachine);
            nbttagcompound.a("Mate", (cd)NBTmachine);
        }
    }

    @Override
    public void mate(ITree other) {
        this.mate = other.getGenome();
    }

    @Override
    public IEffectData[] doEffect(IEffectData[] storedData, yc world, int biomeid, int x, int y2, int z) {
        return null;
    }

    @Override
    public IEffectData[] doFX(IEffectData[] storedData, yc world, int biomeid, int x, int y2, int z) {
        return null;
    }

    @Override
    public abm getTreeGenerator() {
        return this.genome.getPrimaryAsTree().getTreeGenerator(this);
    }

    @Override
    public boolean canStay(yc world, int x, int y2, int z) {
        EnumSet tolerated = this.genome.getPlantTypes();
        tolerated.add(this.genome.getPrimaryAsTree().getPlantType());
        amq block = amq.p[world.a(x, y2 - 1, z)];
        if (block == null) {
            return false;
        }
        Iterator i$ = tolerated.iterator();
        while (i$.hasNext()) {
            EnumPlantType type;
            this.plantType = type = (EnumPlantType)i$.next();
            if (!block.canSustainPlant(world, x, y2 - 1, z, ForgeDirection.UP, (IPlantable)this)) continue;
            return true;
        }
        return false;
    }

    public EnumPlantType getPlantType(yc world, int x, int y2, int z) {
        return this.plantType;
    }

    public int getPlantID(yc world, int x, int y2, int z) {
        return 0;
    }

    public int getPlantMetadata(yc world, int x, int y2, int z) {
        return 0;
    }

    @Override
    public boolean canGrow(yc world, int x, int y2, int z, int expectedGirth, int expectedHeight) {
        return this.genome.getGrowthProvider().canGrow(this.genome, world, x, y2, z, expectedGirth, expectedHeight);
    }

    @Override
    public EnumGrowthConditions getGrowthCondition(yc world, int x, int y2, int z) {
        return this.genome.getGrowthProvider().getGrowthConditions(this.getGenome(), world, x, y2, z);
    }

    @Override
    public int getGirth() {
        return this.genome.getPrimaryAsTree().getGirth();
    }

    @Override
    public String getIdent() {
        return this.genome.getPrimary().getUID();
    }

    @Override
    public String getDisplayName() {
        return this.genome.getPrimary().getName();
    }

    @Override
    public ITreeGenome getMate() {
        return this.mate;
    }

    @Override
    public ITreeGenome getGenome() {
        return this.genome;
    }

    @Override
    public void addTooltip(List list) {
        if (!this.isAnalyzed) {
            list.add("<" + StringUtil.localize("gui.unknown") + ">");
            return;
        }
    }

    @Override
    public ITreeGenome[] getSaplings(yc world, int x, int y2, int z) {
        ArrayList<ITreeGenome> prod = new ArrayList<ITreeGenome>();
        if (world.t.nextFloat() <= this.genome.getFertility()) {
            prod.add(this.genome);
        }
        return prod.toArray(new ITreeGenome[0]);
    }

    public static String rateHeight(float height) {
        if (height >= 2.0f) {
            return StringUtil.localize("gui.gigantic");
        }
        if (height >= 1.75f) {
            return StringUtil.localize("gui.largest");
        }
        if (height >= 1.5f) {
            return StringUtil.localize("gui.larger");
        }
        if (height >= 1.25f) {
            return StringUtil.localize("gui.large");
        }
        if (height >= 1.0f) {
            return StringUtil.localize("gui.average");
        }
        if (height >= 0.75f) {
            return StringUtil.localize("gui.small");
        }
        if (height >= 0.5f) {
            return StringUtil.localize("gui.smaller");
        }
        return StringUtil.localize("gui.smallest");
    }

    public static String rateFertility(float height) {
        if (height >= 0.3f) {
            return StringUtil.localize("gui.triple");
        }
        if (height >= 0.2f) {
            return StringUtil.localize("gui.double");
        }
        return StringUtil.localize("gui.normal");
    }

    public static String rateYield(float yield) {
        if (yield >= 0.35f) {
            return StringUtil.localize("gui.largest");
        }
        if (yield >= 0.3f) {
            return StringUtil.localize("gui.larger");
        }
        if (yield >= 0.25f) {
            return StringUtil.localize("gui.large");
        }
        if ((double)yield >= 0.2) {
            return StringUtil.localize("gui.normal");
        }
        if (yield >= 0.15f) {
            return StringUtil.localize("gui.low");
        }
        if (yield >= 0.1f) {
            return StringUtil.localize("gui.lower");
        }
        return StringUtil.localize("gui.lowest");
    }

    @Override
    public ITree copy() {
        bq nbttagcompound = new bq();
        this.writeToNBT(nbttagcompound);
        return new Tree(nbttagcompound);
    }
}

