/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IAlleleGrowth;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.IGrowthProvider;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IChromosome;
import forestry.arboriculture.genetics.TreeTemplates;
import forestry.core.genetics.AlleleFloat;
import forestry.core.genetics.AllelePlantType;
import forestry.core.genetics.Genome;
import java.util.EnumSet;
import net.minecraftforge.common.EnumPlantType;

public class TreeGenome
extends Genome
implements ITreeGenome {
    public TreeGenome(IChromosome[] chromosomes) {
        super(TreeTemplates.getOakTemplate(), chromosomes);
    }

    public TreeGenome(bq nbttagcompound) {
        super(TreeTemplates.getOakTemplate(), nbttagcompound);
    }

    @Override
    public IAlleleSpecies getPrimary() {
        return (IAlleleSpecies)this.getActiveAllele(EnumTreeChromosome.SPECIES.ordinal());
    }

    @Override
    public IAlleleSpecies getSecondary() {
        return (IAlleleSpecies)this.getInactiveAllele(EnumTreeChromosome.SPECIES.ordinal());
    }

    @Override
    public IAlleleTreeSpecies getPrimaryAsTree() {
        return (IAlleleTreeSpecies)this.getActiveAllele(EnumTreeChromosome.SPECIES.ordinal());
    }

    @Override
    public IAlleleTreeSpecies getSecondaryAsTree() {
        return (IAlleleTreeSpecies)this.getInactiveAllele(EnumTreeChromosome.SPECIES.ordinal());
    }

    @Override
    public IFruitProvider getFruitProvider() {
        return ((IAlleleFruit)this.getActiveAllele(EnumTreeChromosome.FRUITS.ordinal())).getProvider();
    }

    @Override
    public IGrowthProvider getGrowthProvider() {
        return ((IAlleleGrowth)this.getActiveAllele(EnumTreeChromosome.GROWTH.ordinal())).getProvider();
    }

    @Override
    public float getHeight() {
        return ((AlleleFloat)this.getActiveAllele(EnumTreeChromosome.HEIGHT.ordinal())).getValue();
    }

    @Override
    public float getFertility() {
        return ((AlleleFloat)this.getActiveAllele(EnumTreeChromosome.FERTILITY.ordinal())).getValue();
    }

    @Override
    public float getYield() {
        return ((AlleleFloat)this.getActiveAllele(EnumTreeChromosome.YIELD.ordinal())).getValue();
    }

    @Override
    public EnumSet getPlantTypes() {
        if (this.getActiveAllele(EnumTreeChromosome.PLANT.ordinal()) instanceof AllelePlantType) {
            return ((AllelePlantType)this.getActiveAllele(EnumTreeChromosome.PLANT.ordinal())).getPlantTypes();
        }
        return EnumSet.noneOf(EnumPlantType.class);
    }
}

