/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.ITreeInterface;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosome;
import forestry.arboriculture.gadgets.TileLeaves;
import forestry.arboriculture.gadgets.TileSapling;
import forestry.arboriculture.genetics.Tree;
import forestry.arboriculture.genetics.TreeGenome;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.genetics.Chromosome;

public class TreeHelper
implements ITreeInterface {
    @Override
    public boolean isGermling(ur itemstack) {
        if (itemstack == null) {
            return false;
        }
        return itemstack.c == ForestryItem.sapling.cj;
    }

    @Override
    public boolean isPollen(ur itemstack) {
        return false;
    }

    @Override
    public boolean isPollinated(ur itemstack) {
        return false;
    }

    @Override
    public ITree getTree(ur itemstack) {
        if (!this.isGermling(itemstack)) {
            return null;
        }
        if (itemstack.p() == null) {
            return null;
        }
        return new Tree(itemstack.p());
    }

    @Override
    public ITree getTree(yc world, ITreeGenome genome) {
        return new Tree(genome);
    }

    @Override
    public ur getGermlingStack(ITree tree, EnumGermlingType type) {
        up germlingItem = null;
        switch (type) {
            case SAPLING: {
                germlingItem = ForestryItem.sapling;
                break;
            }
            default: {
                return null;
            }
        }
        bq nbttagcompound = new bq();
        tree.writeToNBT(nbttagcompound);
        ur treeStack = new ur(germlingItem, 1, AlleleManager.alleleRegistry.getFromUIDMap(tree.getIdent()));
        treeStack.d(nbttagcompound);
        return treeStack;
    }

    @Override
    public boolean plantSapling(yc world, ITree tree, int x, int y2, int z) {
        boolean placed = world.d(x, y2, z, ForestryBlock.saplingGE.cm, 0);
        if (!placed) {
            return false;
        }
        if (world.a(x, y2, z) != ForestryBlock.saplingGE.cm) {
            return false;
        }
        any tile = world.q(x, y2, z);
        if (!(tile instanceof TileSapling)) {
            world.d(x, y2, z, 0, 0);
            return false;
        }
        TileSapling sapling = (TileSapling)tile;
        sapling.setTree(tree.copy());
        world.i(x, y2, z);
        return true;
    }

    @Override
    public boolean setLeaves(yc world, ITree tree, int x, int y2, int z) {
        boolean placed = world.d(x, y2, z, ForestryBlock.leaves.cm, 0);
        if (!placed) {
            return false;
        }
        if (world.a(x, y2, z) != ForestryBlock.leaves.cm) {
            return false;
        }
        any tile = world.q(x, y2, z);
        if (!(tile instanceof TileLeaves)) {
            world.d(x, y2, z, 0, 0);
            return false;
        }
        TileLeaves leaves = (TileLeaves)tile;
        leaves.setTree(tree.copy());
        world.i(x, y2, z);
        return true;
    }

    @Override
    public IChromosome[] templateAsChromosomes(IAllele[] template) {
        IChromosome[] chromosomes = new Chromosome[template.length];
        for (int i = 0; i < template.length; ++i) {
            if (template[i] == null) continue;
            chromosomes[i] = new Chromosome(template[i]);
        }
        return chromosomes;
    }

    @Override
    public IChromosome[] templateAsChromosomes(IAllele[] templateActive, IAllele[] templateInactive) {
        IChromosome[] chromosomes = new Chromosome[templateActive.length];
        for (int i = 0; i < templateActive.length; ++i) {
            if (templateActive[i] == null) continue;
            chromosomes[i] = new Chromosome(templateActive[i], templateInactive[i]);
        }
        return chromosomes;
    }

    @Override
    public ITreeGenome templateAsGenome(IAllele[] template) {
        return new TreeGenome(this.templateAsChromosomes(template));
    }

    @Override
    public ITreeGenome templateAsGenome(IAllele[] templateActive, IAllele[] templateInactive) {
        return new TreeGenome(this.templateAsChromosomes(templateActive, templateInactive));
    }
}

