/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.genetics.IAllele;
import forestry.arboriculture.genetics.TreeGenome;
import forestry.core.genetics.Allele;
import forestry.core.genetics.Chromosome;

public class TreeTemplates {
    public static IAllele[] getDefaultTemplate() {
        IAllele[] alleles = new IAllele[EnumTreeChromosome.values().length];
        alleles[EnumTreeChromosome.SPECIES.ordinal()] = Allele.treeOak;
        alleles[EnumTreeChromosome.FRUITS.ordinal()] = Allele.fruitNone;
        alleles[EnumTreeChromosome.GROWTH.ordinal()] = Allele.growthLightlevel;
        alleles[EnumTreeChromosome.HEIGHT.ordinal()] = Allele.heightAverage;
        alleles[EnumTreeChromosome.FERTILITY.ordinal()] = Allele.saplingsDefault;
        alleles[EnumTreeChromosome.YIELD.ordinal()] = Allele.yieldLower;
        alleles[EnumTreeChromosome.PLANT.ordinal()] = Allele.plantTypeNone;
        alleles[EnumTreeChromosome.UNUSED.ordinal()] = null;
        alleles[EnumTreeChromosome.TERRITORY.ordinal()] = Allele.territoryDefault;
        alleles[EnumTreeChromosome.EFFECT.ordinal()] = Allele.leavesNone;
        return alleles;
    }

    public static IAllele[] getOakTemplate() {
        IAllele[] alleles = TreeTemplates.getDefaultTemplate();
        alleles[EnumTreeChromosome.FRUITS.ordinal()] = Allele.fruitApple;
        return alleles;
    }

    public static IAllele[] getBirchTemplate() {
        IAllele[] alleles = TreeTemplates.getDefaultTemplate();
        alleles[EnumTreeChromosome.SPECIES.ordinal()] = Allele.treeBirch;
        alleles[EnumTreeChromosome.FRUITS.ordinal()] = Allele.fruitApple;
        return alleles;
    }

    public static IAllele[] getBalsaTemplate() {
        IAllele[] alleles = TreeTemplates.getDefaultTemplate();
        alleles[EnumTreeChromosome.SPECIES.ordinal()] = Allele.treeBalsa;
        alleles[EnumTreeChromosome.FRUITS.ordinal()] = Allele.fruitBalsa;
        alleles[EnumTreeChromosome.FERTILITY.ordinal()] = Allele.saplingsTriple;
        alleles[EnumTreeChromosome.HEIGHT.ordinal()] = Allele.heightLarger;
        return alleles;
    }

    public static IAllele[] getSequoiaTemplate() {
        IAllele[] alleles = TreeTemplates.getDefaultTemplate();
        alleles[EnumTreeChromosome.SPECIES.ordinal()] = Allele.treeSequioa;
        alleles[EnumTreeChromosome.FRUITS.ordinal()] = Allele.fruitSequoia;
        alleles[EnumTreeChromosome.HEIGHT.ordinal()] = Allele.heightGigantic;
        return alleles;
    }

    public static IAllele[] getLarchTemplate() {
        IAllele[] alleles = TreeTemplates.getDefaultTemplate();
        alleles[EnumTreeChromosome.SPECIES.ordinal()] = Allele.treeLarch;
        alleles[EnumTreeChromosome.FRUITS.ordinal()] = Allele.fruitLarch;
        return alleles;
    }

    public static IAllele[] getCherryTemplate() {
        IAllele[] alleles = TreeTemplates.getDefaultTemplate();
        alleles[EnumTreeChromosome.SPECIES.ordinal()] = Allele.treeCherry;
        alleles[EnumTreeChromosome.FRUITS.ordinal()] = Allele.fruitCherry;
        alleles[EnumTreeChromosome.HEIGHT.ordinal()] = Allele.heightSmall;
        return alleles;
    }

    public static IAllele[] getLimeTemplate() {
        IAllele[] alleles = TreeTemplates.getDefaultTemplate();
        alleles[EnumTreeChromosome.SPECIES.ordinal()] = Allele.treeLime;
        alleles[EnumTreeChromosome.FRUITS.ordinal()] = Allele.fruitLime;
        return alleles;
    }

    public static IAllele[] getTeakTemplate() {
        IAllele[] alleles = TreeTemplates.getDefaultTemplate();
        alleles[EnumTreeChromosome.SPECIES.ordinal()] = Allele.treeTeak;
        alleles[EnumTreeChromosome.FRUITS.ordinal()] = Allele.fruitTeak;
        return alleles;
    }

    public static IAllele[] getChestnutTemplate() {
        IAllele[] alleles = TreeTemplates.getDefaultTemplate();
        alleles[EnumTreeChromosome.SPECIES.ordinal()] = Allele.treeChestnut;
        alleles[EnumTreeChromosome.FRUITS.ordinal()] = Allele.fruitChestnut;
        alleles[EnumTreeChromosome.HEIGHT.ordinal()] = Allele.heightLarge;
        return alleles;
    }

    public static IAllele[] getAcaciaTemplate() {
        IAllele[] alleles = TreeTemplates.getDefaultTemplate();
        alleles[EnumTreeChromosome.SPECIES.ordinal()] = Allele.treeAcacia;
        alleles[EnumTreeChromosome.FRUITS.ordinal()] = Allele.fruitAcacia;
        alleles[EnumTreeChromosome.GROWTH.ordinal()] = Allele.growthAcacia;
        alleles[EnumTreeChromosome.HEIGHT.ordinal()] = Allele.heightSmall;
        alleles[EnumTreeChromosome.PLANT.ordinal()] = Allele.plantTypeDesert;
        return alleles;
    }

    public static IAllele[] getWalnutTemplate() {
        IAllele[] alleles = TreeTemplates.getDefaultTemplate();
        alleles[EnumTreeChromosome.SPECIES.ordinal()] = Allele.treeWalnut;
        alleles[EnumTreeChromosome.FRUITS.ordinal()] = Allele.fruitWalnut;
        alleles[EnumTreeChromosome.HEIGHT.ordinal()] = Allele.heightAverage;
        return alleles;
    }

    public static Chromosome[] templateAsChromosomes(IAllele[] template) {
        Chromosome[] chromosomes = new Chromosome[template.length];
        for (int i = 0; i < template.length; ++i) {
            if (template[i] == null) continue;
            chromosomes[i] = new Chromosome(template[i]);
        }
        return chromosomes;
    }

    public static Chromosome[] templateAsChromosomes(IAllele[] templateActive, IAllele[] templateInactive) {
        Chromosome[] chromosomes = new Chromosome[templateActive.length];
        for (int i = 0; i < templateActive.length; ++i) {
            if (templateActive[i] == null) continue;
            chromosomes[i] = new Chromosome(templateActive[i], templateInactive[i]);
        }
        return chromosomes;
    }

    public static ITreeGenome templateAsGenome(IAllele[] template) {
        return new TreeGenome(TreeTemplates.templateAsChromosomes(template));
    }

    public static ITreeGenome templateAsGenome(IAllele[] templateActive, IAllele[] templateInactive) {
        return new TreeGenome(TreeTemplates.templateAsChromosomes(templateActive, templateInactive));
    }
}

