/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.gui;

import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IMutation;
import forestry.arboriculture.genetics.Tree;
import forestry.arboriculture.gui.ContainerTreealyzer;
import forestry.arboriculture.items.ItemGermlingGE;
import forestry.arboriculture.items.ItemTreealyzer;
import forestry.core.config.ForestryItem;
import forestry.core.genetics.AlleleFloat;
import forestry.core.genetics.AllelePlantType;
import forestry.core.genetics.EnumMutateChance;
import forestry.core.gui.GuiForestry;
import forestry.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import net.minecraftforge.common.EnumPlantType;
import org.lwjgl.opengl.GL11;

public class GuiTreealyzer
extends GuiForestry {
    private la inventory;
    private int startX;
    private int startY;
    private HashMap iconStacks = new HashMap();
    private ur[] tempProductList;

    public GuiTreealyzer(qx player, ItemTreealyzer.TreealyzerInventory inventory) {
        super("/gfx/forestry/gui/beealyzer.png", new ContainerTreealyzer(player.bJ, inventory), inventory, 1, inventory.k_());
        this.inventory = inventory;
        this.xSize = 196;
        this.ySize = 238;
        ArrayList beeList = new ArrayList();
        ((ItemGermlingGE)ForestryItem.sapling).addCreativeItems(beeList, false);
        for (ur beeStack : beeList) {
            this.iconStacks.put(TreeManager.treeInterface.getTree(beeStack).getIdent(), beeStack);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(float f, int i, int j) {
        this.drawBackground();
        int page = 0;
        ITree bee = null;
        for (int k = 1; k < 5; ++k) {
            if (this.inventory.a(k) == null || (bee = TreeManager.treeInterface.getTree(this.inventory.a(k))) == null || !bee.isAnalyzed()) continue;
            page = k;
            break;
        }
        switch (page) {
            case 1: {
                this.drawAnalyticsPage1(bee);
                break;
            }
            case 2: {
                this.drawAnalyticsPage2(bee);
                break;
            }
            case 3: {
                this.drawAnalyticsPage3(bee);
                break;
            }
            case 4: {
                this.drawAnalyticsPage4(bee);
                break;
            }
            default: {
                this.drawAnalyticsOverview();
            }
        }
    }

    private void drawAnalyticsOverview() {
        String title = StringUtil.localize("gui.treealyzer").toUpperCase();
        this.l.b(title, this.startX + 8 + this.getCenteredOffset(title, 158), this.startY + 18, this.fontColor.get("gui.screen"));
        this.l.a(StringUtil.localize("gui.treealyzer.help"), this.startX + 10, this.startY + 42, 158, this.fontColor.get("gui.screen"));
        this.l.b(StringUtil.localize("gui.treealyzer.overview") + ":", this.startX + 10, this.startY + 78, this.fontColor.get("gui.screen"));
        this.l.b("I  : " + StringUtil.localize("gui.general"), this.startX + 10, this.startY + 90, this.fontColor.get("gui.screen"));
        this.l.b("II : " + StringUtil.localize("gui.environment"), this.startX + 10, this.startY + 102, this.fontColor.get("gui.screen"));
        this.l.b("III: " + StringUtil.localize("gui.produce"), this.startX + 10, this.startY + 114, this.fontColor.get("gui.screen"));
        this.l.b("IV : " + StringUtil.localize("gui.evolution"), this.startX + 10, this.startY + 126, this.fontColor.get("gui.screen"));
    }

    private void drawAnalyticsPage1(ITree bee) {
        this.l.b(StringUtil.localize("gui.active"), this.startX + 60, this.startY + 18, this.fontColor.get("gui.table.header"));
        this.l.b(StringUtil.localize("gui.inactive"), this.startX + 113, this.startY + 18, this.fontColor.get("gui.table.header"));
        this.l.b(StringUtil.localize("gui.species"), this.startX + 10, this.startY + 30, this.fontColor.get("gui.table.row"));
        this.l.b(StringUtil.localize("gui.saplings"), this.startX + 10, this.startY + 42, this.fontColor.get("gui.table.row"));
        this.l.b(StringUtil.localize("gui.height"), this.startX + 10, this.startY + 54, this.fontColor.get("gui.table.row"));
        this.l.b(StringUtil.localize("gui.girth"), this.startX + 10, this.startY + 66, this.fontColor.get("gui.table.row"));
        this.l.b(StringUtil.localize("gui.yield"), this.startX + 10, this.startY + 78, this.fontColor.get("gui.table.row"));
        this.l.b(StringUtil.localize("gui.fruits"), this.startX + 10, this.startY + 90, this.fontColor.get("gui.table.row"));
        IAlleleTreeSpecies primary = bee.getGenome().getPrimaryAsTree();
        IAlleleTreeSpecies secondary = bee.getGenome().getSecondaryAsTree();
        this.l.b(primary.getName(), this.startX + 60, this.startY + 30, this.getColorCoding(primary.isDominant()));
        this.l.b(secondary.getName(), this.startX + 113, this.startY + 30, this.getColorCoding(secondary.isDominant()));
        this.l.b(Tree.rateFertility(bee.getGenome().getFertility()), this.startX + 60, this.startY + 42, this.getColorCoding(bee.getGenome().getActiveAllele(EnumTreeChromosome.FERTILITY.ordinal()).isDominant()));
        this.l.b(Tree.rateFertility(((AlleleFloat)bee.getGenome().getInactiveAllele(EnumTreeChromosome.FERTILITY.ordinal())).getValue()), this.startX + 113, this.startY + 42, this.getColorCoding(bee.getGenome().getInactiveAllele(EnumTreeChromosome.FERTILITY.ordinal()).isDominant()));
        this.l.b(Tree.rateHeight(bee.getGenome().getHeight()), this.startX + 60, this.startY + 54, this.getColorCoding(bee.getGenome().getActiveAllele(EnumTreeChromosome.HEIGHT.ordinal()).isDominant()));
        this.l.b(Tree.rateHeight(((AlleleFloat)bee.getGenome().getInactiveAllele(EnumTreeChromosome.HEIGHT.ordinal())).getValue()), this.startX + 113, this.startY + 54, this.getColorCoding(bee.getGenome().getInactiveAllele(EnumTreeChromosome.HEIGHT.ordinal()).isDominant()));
        this.l.b(String.format("%sx%s", primary.getGirth(), primary.getGirth()), this.startX + 60, this.startY + 66, this.getColorCoding(bee.getGenome().getActiveAllele(EnumTreeChromosome.FERTILITY.ordinal()).isDominant()));
        this.l.b(String.format("%sx%s", secondary.getGirth(), secondary.getGirth()), this.startX + 113, this.startY + 66, this.getColorCoding(bee.getGenome().getInactiveAllele(EnumTreeChromosome.FERTILITY.ordinal()).isDominant()));
        this.l.b(Tree.rateYield(bee.getGenome().getYield()), this.startX + 60, this.startY + 78, this.getColorCoding(bee.getGenome().getActiveAllele(EnumTreeChromosome.YIELD.ordinal()).isDominant()));
        this.l.b(Tree.rateYield(((AlleleFloat)bee.getGenome().getInactiveAllele(EnumTreeChromosome.YIELD.ordinal())).getValue()), this.startX + 113, this.startY + 78, this.getColorCoding(bee.getGenome().getInactiveAllele(EnumTreeChromosome.YIELD.ordinal()).isDominant()));
        this.l.b(StringUtil.localize(bee.getGenome().getFruitProvider().getDescription()), this.startX + 60, this.startY + 90, this.getColorCoding(bee.getGenome().getActiveAllele(EnumTreeChromosome.FRUITS.ordinal()).isDominant()));
        this.l.b(StringUtil.localize(((IAlleleFruit)bee.getGenome().getInactiveAllele(EnumTreeChromosome.FRUITS.ordinal())).getProvider().getDescription()), this.startX + 113, this.startY + 90, this.getColorCoding(bee.getGenome().getInactiveAllele(EnumTreeChromosome.FRUITS.ordinal()).isDominant()));
        String binomial = bee.getGenome().getPrimaryAsTree().getBinomial();
        if (binomial != null && binomial.length() > 0) {
            binomial = "\"" + binomial + "\"";
            int offset = (158 - this.l.a(binomial)) / 2;
            this.l.b(binomial, this.startX + 8 + offset, this.startY + 126, this.fontColor.get("gui.beealyzer.binomial"));
        }
    }

    private void drawAnalyticsPage2(ITree bee) {
        this.l.b(StringUtil.localize("gui.active"), this.startX + 60, this.startY + 18, this.fontColor.get("gui.table.header"));
        this.l.b(StringUtil.localize("gui.inactive"), this.startX + 113, this.startY + 18, this.fontColor.get("gui.table.header"));
        this.l.b(StringUtil.localize("gui.native"), this.startX + 10, this.startY + 30, this.fontColor.get("gui.table.row"));
        this.l.b(StringUtil.localize("gui.tolerated"), this.startX + 10, this.startY + 42, this.fontColor.get("gui.table.row"));
        this.l.b(StringUtil.localize("gui." + bee.getGenome().getPrimaryAsTree().getPlantType().toString().toLowerCase()), this.startX + 60, this.startY + 30, this.getColorCoding(bee.getGenome().getPrimaryAsTree().isDominant()));
        this.l.b(StringUtil.localize("gui." + bee.getGenome().getSecondaryAsTree().getPlantType().toString().toLowerCase()), this.startX + 113, this.startY + 30, this.getColorCoding(bee.getGenome().getSecondaryAsTree().isDominant()));
        int line = 42;
        for (EnumPlantType type : bee.getGenome().getPlantTypes()) {
            this.l.b(StringUtil.localize("gui." + type.toString().toLowerCase()), this.startX + 60, this.startY + line, this.getColorCoding(bee.getGenome().getActiveAllele(EnumTreeChromosome.PLANT.ordinal()).isDominant()));
            line += 12;
        }
        line = 42;
        IAllele allele1 = bee.getGenome().getInactiveAllele(EnumTreeChromosome.PLANT.ordinal());
        EnumSet tolerated1 = EnumSet.noneOf(EnumPlantType.class);
        if (allele1 instanceof AllelePlantType) {
            tolerated1 = ((AllelePlantType)allele1).getPlantTypes();
        }
        for (EnumPlantType type : tolerated1) {
            this.l.b(StringUtil.localize("gui." + type.toString().toLowerCase()), this.startX + 113, this.startY + line, this.getColorCoding(bee.getGenome().getInactiveAllele(EnumTreeChromosome.PLANT.ordinal()).isDominant()));
            line += 12;
        }
    }

    private void drawAnalyticsPage3(ITree bee) {
        this.l.b(StringUtil.localize("gui.beealyzer.produce") + ":", this.startX + 10, this.startY + 18, this.fontColor.get("gui.table.header"));
        this.l.b(StringUtil.localize("gui.beealyzer.specialty") + ":", this.startX + 10, this.startY + 78, this.fontColor.get("gui.table.header"));
    }

    private void drawAnalyticsPage4(ITree bee) {
        this.l.b(StringUtil.localize("gui.beealyzer.mutations") + ":", this.startX + 10, this.startY + 10, this.fontColor.get("gui.table.header"));
        arw.c();
    }

    private void drawFertilityInfo(float fertility, int x, int y2, int textColor) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.f.o.b(this.f.o.b("/gfx/forestry/gui/beealyzer.png"));
        this.b(x + 19, y2, 196, 43, 12, 9);
        this.l.b(Float.toString(fertility) + " x", x, y2, textColor);
    }

    private void drawToleranceInfo(EnumTolerance tolerance, int x, int y2, int textColor) {
        int length = tolerance.toString().length();
        String text = "(" + tolerance.toString().substring(length - 1) + ")";
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        switch (tolerance) {
            case BOTH_1: 
            case BOTH_2: 
            case BOTH_3: 
            case BOTH_4: 
            case BOTH_5: {
                this.drawBothSymbol(x, y2 - 1);
                this.l.b(text, x + 20, y2, textColor);
                break;
            }
            case DOWN_1: 
            case DOWN_2: 
            case DOWN_3: 
            case DOWN_4: 
            case DOWN_5: {
                this.drawDownSymbol(x, y2 - 1);
                this.l.b(text, x + 20, y2, textColor);
                break;
            }
            case UP_1: 
            case UP_2: 
            case UP_3: 
            case UP_4: 
            case UP_5: {
                this.drawUpSymbol(x, y2 - 1);
                this.l.b(text, x + 20, y2, textColor);
                break;
            }
            default: {
                this.drawNoneSymbol(x, y2 - 1);
                this.l.b("(0)", x + 20, y2, textColor);
            }
        }
    }

    private void drawDownSymbol(int x, int y2) {
        this.f.o.b(this.f.o.b("/gfx/forestry/gui/beealyzer.png"));
        this.b(x, y2, 196, 34, 15, 9);
    }

    private void drawUpSymbol(int x, int y2) {
        this.f.o.b(this.f.o.b("/gfx/forestry/gui/beealyzer.png"));
        this.b(x, y2, 211, 34, 15, 9);
    }

    private void drawBothSymbol(int x, int y2) {
        this.f.o.b(this.f.o.b("/gfx/forestry/gui/beealyzer.png"));
        this.b(x, y2, 226, 34, 15, 9);
    }

    private void drawNoneSymbol(int x, int y2) {
        this.f.o.b(this.f.o.b("/gfx/forestry/gui/beealyzer.png"));
        this.b(x, y2, 241, 34, 15, 9);
    }

    private void drawMutationInfo(IMutation combination, IAllele species, int x, int y2) {
        itemRenderer.a(this.l, this.f.o, (ur)this.iconStacks.get(combination.getPartner(species).getUID()), x, y2);
        itemRenderer.c(this.l, this.f.o, (ur)this.iconStacks.get(combination.getPartner(species).getUID()), x, y2);
        IAllele result = combination.getTemplate()[EnumTreeChromosome.SPECIES.ordinal()];
        itemRenderer.a(this.l, this.f.o, (ur)this.iconStacks.get(result.getUID()), x + 33, y2);
        itemRenderer.c(this.l, this.f.o, (ur)this.iconStacks.get(result.getUID()), x + 33, y2);
        int line = 0;
        int column = 196;
        switch (EnumMutateChance.rateChance(combination.getBaseChance())) {
            case HIGHEST: {
                column = 226;
                line = 9;
                break;
            }
            case HIGHER: {
                column = 211;
                line = 9;
                break;
            }
            case HIGH: {
                line = 9;
                break;
            }
            case NORMAL: {
                column = 226;
                break;
            }
            case LOW: {
                column = 211;
                break;
            }
        }
        this.f.o.b(this.f.o.b("/gfx/forestry/gui/beealyzer.png"));
        this.b(x + 18, y2 + 4, column, line, 15, 9);
    }

    private void drawUnknownMutation(IMutation combination, IAllele species, int x, int y2) {
        this.f.o.b(this.f.o.b("/gfx/forestry/gui/beealyzer.png"));
        this.b(x, y2, 196, 18, 16, 16);
        this.f.o.b(this.f.o.b("/gfx/forestry/gui/beealyzer.png"));
        this.b(x + 32, y2, 196, 18, 16, 16);
        int line = 0;
        int column = 196;
        switch (EnumMutateChance.rateChance(combination.getBaseChance())) {
            case HIGHEST: {
                column = 226;
                line = 9;
                break;
            }
            case HIGHER: {
                column = 211;
                line = 9;
                break;
            }
            case HIGH: {
                line = 9;
                break;
            }
            case NORMAL: {
                column = 226;
                break;
            }
            case LOW: {
                column = 211;
                break;
            }
        }
        this.f.o.b(this.f.o.b("/gfx/forestry/gui/beealyzer.png"));
        this.b(x + 18, y2 + 4, column, line, 15, 9);
    }

    private int getColorCoding(boolean dominant) {
        if (dominant) {
            return this.fontColor.get("gui.beealyzer.dominant");
        }
        return this.fontColor.get("gui.beealyzer.recessive");
    }

    @Override
    public void A_() {
        super.A_();
        this.startX = (this.g - this.xSize) / 2;
        this.startY = (this.h - this.ySize) / 2;
    }
}

