/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.arboriculture.ITree;
import forestry.arboriculture.worldgen.BlockType;
import forestry.arboriculture.worldgen.WorldGenArboriculture;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.config.ForestryBlock;

public class WorldGenAcacia
extends WorldGenTree {
    public WorldGenAcacia(ITree tree) {
        super(tree);
    }

    @Override
    public void generate() {
        this.generateTreeTrunk(this.height, this.girth);
        int leafSpawn = this.height + 1;
        this.generateCylinder(new WorldGenArboriculture.Vector(0.0f, leafSpawn--, 0.0f), 1.0f, 1, this.leaf, false);
        this.generateCylinder(new WorldGenArboriculture.Vector(0.0f, leafSpawn--, 0.0f), 2.5f, 1, this.leaf, false);
        if (this.rand.nextBoolean()) {
            this.generateCylinder(new WorldGenArboriculture.Vector(0.0f, leafSpawn--, 0.0f), 4.9f, 1, this.leaf, false);
        } else {
            this.generateCylinder(new WorldGenArboriculture.Vector(0.0f, leafSpawn--, 0.0f), 3.9f, 1, this.leaf, false);
        }
    }

    @Override
    public void preGenerate() {
        this.height = this.determineHeight(5, 2);
        this.girth = this.determineGirth(this.tree.getGirth());
    }

    @Override
    public BlockType getWood() {
        return new BlockType(ForestryBlock.log1.cm, 2);
    }
}

