/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.arboriculture.ITree;
import forestry.arboriculture.worldgen.BlockType;
import java.util.Random;

public abstract class WorldGenArboriculture
extends abm {
    protected ITree tree;
    protected yc world;
    protected Random rand;
    protected int startX;
    protected int startY;
    protected int startZ;
    BlockType leaf;
    BlockType wood;

    public WorldGenArboriculture(ITree tree) {
        this.tree = tree;
    }

    public final boolean a(yc world, Random random, int x, int y2, int z) {
        this.world = world;
        this.rand = random;
        this.startX = x;
        this.startY = y2;
        this.startZ = z;
        this.leaf = this.getLeaf();
        this.wood = this.getWood();
        this.preGenerate();
        if (!this.canGrow()) {
            return false;
        }
        this.generate();
        return false;
    }

    public abstract void preGenerate();

    public abstract void generate();

    public abstract boolean canGrow();

    public abstract BlockType getLeaf();

    public abstract BlockType getWood();

    public final Vector getStartVector() {
        return new Vector(this.startX, this.startY, this.startZ);
    }

    protected void generateTreeTrunk(int height, int width) {
        int offset = (width - 1) / 2;
        for (int x = 0; x < width; ++x) {
            for (int y2 = 0; y2 < width; ++y2) {
                for (int i = 0; i < height; ++i) {
                    this.addWood(x - offset, i, y2 - offset, true);
                }
            }
        }
    }

    protected final void addBlock(int x, int y2, int z, BlockType type, boolean doReplace) {
        if (doReplace || this.world.c(this.startX + x, this.startY + y2, this.startZ + z)) {
            type.setBlock(this.world, this.tree, this.startX + x, this.startY + y2, this.startZ + z);
        }
    }

    protected final void addWood(int x, int y2, int z, boolean doReplace) {
        this.addBlock(x, y2, z, this.wood, doReplace);
    }

    protected final void addLeaf(int x, int y2, int z, boolean doReplace) {
        this.addBlock(x, y2, z, this.leaf, doReplace);
    }

    protected final void generateCuboid(Vector start, Vector area, BlockType block, boolean doReplace) {
        int x = (int)start.x;
        while ((float)x < (float)((int)start.x) + area.x) {
            int y2 = (int)start.y;
            while ((float)y2 < (float)((int)start.y) + area.y) {
                int z = (int)start.z;
                while ((float)z < (float)((int)start.z) + area.z) {
                    this.addBlock(x, y2, z, block, doReplace);
                    ++z;
                }
                ++y2;
            }
            ++x;
        }
    }

    protected final void generateCylinder(Vector center, float radius, int height, BlockType block, boolean doReplace) {
        Vector start = new Vector(center.x - radius, center.y, center.z - radius);
        Vector area = new Vector(radius * 2.0f + 1.0f, height, radius * 2.0f + 1.0f);
        int x = (int)start.x;
        while ((float)x < (float)((int)start.x) + area.x) {
            int y2 = (int)start.y;
            while ((float)y2 < (float)((int)start.y) + area.y) {
                int z = (int)start.z;
                while ((float)z < (float)((int)start.z) + area.z) {
                    Vector vector = new Vector(x, y2, z);
                    Vector vector2 = new Vector(center.x, y2, center.z);
                    if (Vector.distance(vector, vector2) <= (double)radius + 0.01) {
                        this.addBlock(x, y2, z, block, doReplace);
                    }
                    ++z;
                }
                ++y2;
            }
            ++x;
        }
    }

    protected final void generateSphere(Vector center, int radius, BlockType block, boolean doReplace) {
        Vector start = new Vector(center.x - (float)radius, center.y - (float)radius, center.z - (float)radius);
        Vector area = new Vector(radius * 2 + 1, radius * 2 + 1, radius * 2 + 1);
        int x = (int)start.x;
        while ((float)x < (float)((int)start.x) + area.x) {
            int y2 = (int)start.y;
            while ((float)y2 < (float)((int)start.y) + area.y) {
                int z = (int)start.z;
                while ((float)z < (float)((int)start.z) + area.z) {
                    Vector vector = new Vector(x, y2, z);
                    Vector vector2 = new Vector(center.x, center.y, center.z);
                    if (Vector.distance(vector, vector2) <= (double)radius + 0.01) {
                        this.addBlock(x, y2, z, block, doReplace);
                    }
                    ++z;
                }
                ++y2;
            }
            ++x;
        }
    }

    static class Vector {
        float x;
        float y;
        float z;

        public Vector(float f, float h, float g) {
            this.x = f;
            this.y = h;
            this.z = g;
        }

        public static double distance(Vector a, Vector b) {
            return Math.sqrt(Math.pow(a.x - b.x, 2.0) + Math.pow(a.y - b.y, 2.0) + Math.pow(a.z - b.z, 2.0));
        }
    }
}

