/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.arboriculture.ITree;
import forestry.arboriculture.worldgen.BlockType;
import forestry.arboriculture.worldgen.BlockTypeLeaf;
import forestry.arboriculture.worldgen.WorldGenArboriculture;

public abstract class WorldGenTree
extends WorldGenArboriculture {
    protected int girth;
    protected int height;
    protected int minHeight = 4;
    protected int maxHeight = 80;

    public WorldGenTree(ITree tree) {
        super(tree);
    }

    @Override
    public void generate() {
        System.out.println("Running generator: " + ((Object)((Object)this)).getClass().toString());
        this.generateTreeTrunk(this.height, this.girth);
        int leafSpawn = this.height + 1;
        this.generateCylinder(new WorldGenArboriculture.Vector(0.0f, leafSpawn--, 0.0f), 1.0f, 1, this.leaf, false);
        this.generateCylinder(new WorldGenArboriculture.Vector(0.0f, leafSpawn--, 0.0f), 1.5f, 1, this.leaf, false);
        this.generateCylinder(new WorldGenArboriculture.Vector(0.0f, leafSpawn--, 0.0f), 2.9f, 1, this.leaf, false);
        this.generateCylinder(new WorldGenArboriculture.Vector(0.0f, leafSpawn--, 0.0f), 2.9f, 1, this.leaf, false);
    }

    @Override
    public boolean canGrow() {
        return this.tree.canGrow(this.world, this.startX, this.startY, this.startZ, this.tree.getGirth(), this.height);
    }

    @Override
    public void preGenerate() {
        this.height = this.determineHeight(5, 2);
        this.girth = this.determineGirth(this.tree.getGirth());
    }

    protected int determineGirth(int base) {
        return base;
    }

    protected int determineHeight(int required, int variation) {
        int determined = Math.round((float)(required + this.rand.nextInt(variation)) * this.tree.getGenome().getHeight());
        return determined < this.minHeight ? this.minHeight : (determined > this.maxHeight ? this.maxHeight : determined);
    }

    @Override
    public BlockType getLeaf() {
        return new BlockTypeLeaf();
    }

    @Override
    public abstract BlockType getWood();
}

