/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import forestry.api.core.IPlugin;
import forestry.api.core.PluginInfo;
import forestry.core.config.Version;
import forestry.core.proxy.Proxies;
import forestry.plugins.PluginManager;
import java.util.List;

public class CommandForestry
extends w {
    public int compareTo(Object arg0) {
        return this.c().compareTo(((y)arg0).c());
    }

    public String c() {
        return "forestry";
    }

    public String a(aa sender) {
        return "/" + this.c() + " help";
    }

    public List b() {
        return null;
    }

    public void b(aa sender, String[] arguments) {
        if (arguments.length <= 0) {
            throw new av("Type '" + this.a(sender) + "' for help.", new Object[0]);
        }
        if (arguments[0].matches("version")) {
            this.commandVersion(sender, arguments);
            return;
        }
        if (arguments[0].matches("plugins")) {
            this.commandPlugins(sender, arguments);
            return;
        }
        if (arguments[0].matches("help")) {
            sender.a("Format: '" + this.c() + " <command> <arguments>'");
            sender.a("Available commands:");
            sender.a("- version : Version information.");
            sender.a("- plugins : list of Forestry plugins.");
            sender.a("- plugins info <plugin-name>: information on plugin.");
            return;
        }
        throw new av(this.a(sender), new Object[0]);
    }

    private void commandVersion(aa sender, String[] arguments) {
        String colour = Version.isOutdated() ? "\u00a7c" : "\u00a7a";
        sender.a(String.format(colour + "Forestry %s for Minecraft %s (Latest: %s).", Version.getVersion(), Proxies.common.getMinecraftVersion(), Version.getRecommendedVersion()));
        if (Version.isOutdated()) {
            for (String updateLine : Version.getChangelog()) {
                sender.a("\u00a79" + updateLine);
            }
        }
    }

    private void commandPlugins(aa sender, String[] arguments) {
        if (arguments.length <= 1) {
            this.listPluginsForSender(sender);
        } else if (arguments[1].matches("info")) {
            this.listPluginInfoForSender(sender, arguments);
        }
    }

    private void listPluginsForSender(aa sender) {
        String pluginList = "";
        for (IPlugin plugin : PluginManager.plugins) {
            if (!pluginList.isEmpty()) {
                pluginList = pluginList + ", ";
            }
            pluginList = pluginList + this.makeListEntry(plugin);
        }
        sender.a(pluginList);
    }

    private void listPluginInfoForSender(aa sender, String[] arguments) {
        PluginInfo info;
        if (arguments.length < 3) {
            throw new av("/" + this.c() + " plugins info <plugin-name>", new Object[0]);
        }
        IPlugin found = null;
        for (IPlugin plugin : PluginManager.plugins) {
            PluginInfo info2 = plugin.getClass().getAnnotation(PluginInfo.class);
            if (info2 == null || !info2.pluginID().equalsIgnoreCase(arguments[2]) && !info2.name().equalsIgnoreCase(arguments[2])) continue;
            found = plugin;
            break;
        }
        if (found == null) {
            throw new aq("No information available for plugin " + arguments[2] + ".", new Object[0]);
        }
        String entry = "\u00a7c";
        if (found.isAvailable()) {
            entry = "\u00a7a";
        }
        if ((info = found.getClass().getAnnotation(PluginInfo.class)) != null) {
            sender.a(entry + "Plugin: " + info.name());
            if (!info.version().isEmpty()) {
                sender.a("\u00a79Version: " + info.version());
            }
            if (!info.author().isEmpty()) {
                sender.a("\u00a79Author(s): " + info.author());
            }
            if (!info.url().isEmpty()) {
                sender.a("\u00a79URL: " + info.url());
            }
            if (!info.description().isEmpty()) {
                sender.a(info.description());
            }
        }
    }

    private String makeListEntry(IPlugin plugin) {
        PluginInfo info;
        String entry = "\u00a7c";
        if (plugin.isAvailable()) {
            entry = "\u00a7a";
        }
        if ((info = plugin.getClass().getAnnotation(PluginInfo.class)) == null) {
            entry = entry + plugin.getDescription();
        } else {
            entry = entry + info.pluginID();
            if (!info.version().isEmpty()) {
                entry = entry + " (" + info.version() + ")";
            }
        }
        return entry;
    }

    public boolean b(aa sender) {
        if (sender instanceof qx) {
            return Proxies.common.isOp((qx)sender);
        }
        return sender.a(4, this.c());
    }
}

