/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import forestry.core.ForestryCore;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.TileEngine;
import forestry.core.gadgets.TileMachine;
import forestry.core.proxy.Proxies;
import forestry.core.render.BlockRenderingHandler;
import forestry.core.render.RenderForestryTile;
import forestry.core.render.TextureBiofuelFX;
import forestry.core.render.TextureBiomassFX;
import forestry.core.render.TextureGlassFX;
import forestry.core.render.TextureHabitatLocatorFX;
import forestry.core.render.TextureHoneyFX;
import forestry.core.render.TextureIceFX;
import forestry.core.render.TextureJuiceFX;
import forestry.core.render.TextureMeadFX;
import forestry.core.render.TextureMilkFX;
import forestry.core.render.TextureSeedOilFX;
import net.minecraftforge.client.MinecraftForgeClient;

public class ForestryClient
extends ForestryCore {
    public static int byBlockModelId;
    public static int blockModelIdEngine;

    @Override
    public void init(Object basemod) {
        super.init(basemod);
        byBlockModelId = Proxies.render.getNextAvailableRenderId();
        blockModelIdEngine = Proxies.render.getNextAvailableRenderId();
        ForestryClient.preloadTexture("/gfx/forestry/blocks/blocks.png");
        ForestryClient.preloadTexture("/gfx/forestry/items/items.png");
        ForestryClient.preloadTexture("/gfx/forestry/items/crated.png");
        ForestryClient.preloadTexture("/gfx/forestry/items/bees.png");
        ForestryClient.preloadTexture("/gfx/forestry/blocks/arboriculture.png");
        ForestryClient.preloadTexture("/gfx/forestry/gui/errors.png");
        ForestryClient.preloadTexture("/gfx/forestry/gui/triggers.png");
        ForestryClient.preloadTexture("/gfx/forestry/blocks/pipes.png");
        ClientRegistry.bindTileEntitySpecialRenderer(TileEngine.class, (bdx)new RenderForestryTile());
        ClientRegistry.bindTileEntitySpecialRenderer(TileMachine.class, (bdx)new RenderForestryTile());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRenderingHandler());
    }

    @Override
    public void postInit() {
        super.postInit();
        Proxies.render.registerTextureFX((Object)new TextureBiomassFX());
        Proxies.render.registerTextureFX((Object)new TextureBiofuelFX());
        Proxies.render.registerTextureFX((Object)new TextureMilkFX());
        Proxies.render.registerTextureFX((Object)new TextureHoneyFX());
        Proxies.render.registerTextureFX((Object)new TextureSeedOilFX());
        Proxies.render.registerTextureFX((Object)new TextureJuiceFX());
        Proxies.render.registerTextureFX((Object)new TextureMeadFX());
        Proxies.render.registerTextureFX((Object)new TextureGlassFX());
        Proxies.render.registerTextureFX((Object)new TextureIceFX());
        if (ForestryItem.biomeFinder != null) {
            Proxies.render.registerTextureFX((Object)new TextureHabitatLocatorFX(Proxies.common.getClientInstance()));
        }
    }

    public static void preloadTexture(String filename) {
        MinecraftForgeClient.preloadTexture((String)filename);
    }
}

