/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import buildcraft.api.power.PowerFramework;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import forestry.api.apiculture.FlowerManager;
import forestry.api.core.ForestryAPI;
import forestry.api.core.GlobalManager;
import forestry.api.core.IPlugin;
import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.EngineCopperFuel;
import forestry.api.fuels.FermenterFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.MoistenerFuel;
import forestry.api.fuels.RainSubstrate;
import forestry.core.EventHandlerCore;
import forestry.core.FuelHandler;
import forestry.core.GameMode;
import forestry.core.GuiHandler;
import forestry.core.TickHandlerCoreClient;
import forestry.core.TickHandlerCoreServer;
import forestry.core.WorldGenerator;
import forestry.core.config.Config;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.config.Version;
import forestry.core.gadgets.EntityHandler;
import forestry.core.gadgets.GadgetManager;
import forestry.core.gadgets.TileEngine;
import forestry.core.gadgets.TileMachine;
import forestry.core.gadgets.TileMill;
import forestry.core.utils.LiquidHelper;
import forestry.plugins.PluginManager;
import java.io.File;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidStack;

public class ForestryCore {
    public EntityHandler entityHandler;

    public void preInit(File modLocation, Object basemod) {
        ForestryAPI.instance = basemod;
        PluginManager.loadPlugins(modLocation);
        Version.versionCheck();
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerCore());
    }

    public void init(Object basemod) {
        Config.load();
        for (IPlugin plugin : PluginManager.plugins) {
            if (plugin.isAvailable()) {
                plugin.preInit();
                continue;
            }
            FMLLog.fine((String)("Skipped plugin " + plugin.getClass() + " because preconditions were not met."), (Object[])new Object[0]);
        }
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenerator());
        this.entityHandler = new EntityHandler();
        GadgetManager.registerEntityHandler(this.entityHandler);
        FuelManager.fermenterFuel.put(new ur(ForestryItem.fertilizerCompound), new FermenterFuel(new ur(ForestryItem.fertilizerCompound), GameMode.getGameMode().getFermentationPerCycleFertilizer(), GameMode.getGameMode().getFermentationCyclesFertilizer()));
        FuelManager.fermenterFuel.put(new ur(ForestryItem.fertilizerBio), new FermenterFuel(new ur(ForestryItem.fertilizerBio), GameMode.getGameMode().getFermentationPerCycleCompost(), GameMode.getGameMode().getFermentationCyclesCompost()));
        FuelManager.fermenterFuel.put(new ur(ForestryItem.mulch), new FermenterFuel(new ur(ForestryItem.mulch), GameMode.getGameMode().getFermentationPerCycleCompost(), GameMode.getGameMode().getFermentationCyclesCompost()));
        FuelManager.moistenerResource.put(new ur(up.T), new MoistenerFuel(new ur(up.T), new ur(ForestryItem.mouldyWheat), 0, 300));
        FuelManager.moistenerResource.put(new ur(ForestryItem.mouldyWheat), new MoistenerFuel(new ur(ForestryItem.mouldyWheat), new ur(ForestryItem.decayingWheat), 1, 600));
        FuelManager.moistenerResource.put(new ur(ForestryItem.decayingWheat), new MoistenerFuel(new ur(ForestryItem.decayingWheat), new ur(ForestryItem.mulch), 2, 900));
        FuelManager.copperEngineFuel.put(new ur(ForestryItem.peat), new EngineCopperFuel(new ur(ForestryItem.peat), 1, 5000));
        FuelManager.copperEngineFuel.put(new ur(ForestryItem.bituminousPeat), new EngineCopperFuel(new ur(ForestryItem.bituminousPeat), 2, 6000));
        FuelManager.bronzeEngineFuel.put(new ur(ForestryItem.liquidBiomass), new EngineBronzeFuel(new ur(ForestryItem.liquidBiomass), 5, 10000, 1));
        FuelManager.bronzeEngineFuel.put(new ur(amq.E), new EngineBronzeFuel(new ur(amq.E), 1, 1000, 3));
        FuelManager.bronzeEngineFuel.put(new ur(ForestryItem.liquidMilk), new EngineBronzeFuel(new ur(ForestryItem.liquidMilk), 1, 40000, 1));
        FuelManager.bronzeEngineFuel.put(new ur(ForestryItem.liquidSeedOil), new EngineBronzeFuel(new ur(ForestryItem.liquidSeedOil), 3, 10000, 1));
        FuelManager.bronzeEngineFuel.put(new ur(ForestryItem.liquidHoney), new EngineBronzeFuel(new ur(ForestryItem.liquidHoney), 1, 10000, 1));
        FuelManager.bronzeEngineFuel.put(new ur(ForestryItem.liquidJuice), new EngineBronzeFuel(new ur(ForestryItem.liquidJuice), 1, 10000, 1));
        FuelManager.rainSubstrate.put(new ur(ForestryItem.iodineCharge), new RainSubstrate(new ur(ForestryItem.iodineCharge), 10000, 0.01f));
        FuelManager.rainSubstrate.put(new ur(ForestryItem.craftingMaterial, 1, 4), new RainSubstrate(new ur(ForestryItem.craftingMaterial, 1, 4), 0.075f));
        GlobalManager.holyBlockIds.add(ForestryBlock.soil.cm);
        if (ForestryBlock.planter != null) {
            GlobalManager.holyBlockIds.add(ForestryBlock.planter.cm);
        }
        if (ForestryBlock.harvester != null) {
            GlobalManager.holyBlockIds.add(ForestryBlock.harvester.cm);
        }
        if (ForestryBlock.engine != null) {
            GlobalManager.holyBlockIds.add(ForestryBlock.engine.cm);
        }
        if (ForestryBlock.machine != null) {
            GlobalManager.holyBlockIds.add(ForestryBlock.machine.cm);
        }
        if (ForestryBlock.mill != null) {
            GlobalManager.holyBlockIds.add(ForestryBlock.mill.cm);
        }
        GlobalManager.holyBlockIds.add(amq.aT.cm);
        GlobalManager.holyBlockIds.add(amq.aS.cm);
        GlobalManager.holyBlockIds.add(amq.ao.cm);
        GlobalManager.holyBlockIds.add(amq.bp.cm);
        GlobalManager.holyBlockIds.add(amq.aM.cm);
        GlobalManager.holyBlockIds.add(amq.C.cm);
        GlobalManager.holyBlockIds.add(amq.ax.cm);
        GlobalManager.holyBlockIds.add(amq.z.cm);
        GlobalManager.holyBlockIds.add(amq.ar.cm);
        GlobalManager.holyBlockIds.add(amq.bD.cm);
        GlobalManager.holyBlockIds.add(amq.at.cm);
        GlobalManager.holyBlockIds.add(amq.A.cm);
        GlobalManager.holyBlockIds.add(amq.bB.cm);
        FlowerManager.plainFlowers.add(new ur((amq)amq.ah));
        FlowerManager.plainFlowers.add(new ur((amq)amq.ag));
        NetworkRegistry.instance().registerGuiHandler(basemod, (IGuiHandler)new GuiHandler());
        GameRegistry.registerTileEntity(TileMill.class, (String)"forestry.Grower");
        GameRegistry.registerTileEntity(TileEngine.class, (String)"forestry.Engine");
        GameRegistry.registerTileEntity(TileMachine.class, (String)"forestry.Machine");
    }

    public void postInit() {
        for (IPlugin plugin : PluginManager.plugins) {
            if (!plugin.isAvailable()) continue;
            plugin.doInit();
        }
        if (LiquidHelper.isEmptyLiquidData()) {
            LiquidHelper.injectLiquidContainer(new LiquidContainerData(new LiquidStack(amq.G, 1000), new ur(up.ay), new ur(up.aw)));
            LiquidHelper.injectLiquidContainer(new LiquidContainerData(new LiquidStack(amq.E, 1000), new ur(up.ax), new ur(up.aw)));
        }
        LiquidHelper.injectLiquidContainer(LiquidHelper.createLiquidData("milk", new LiquidStack(ForestryItem.liquidMilk, 1000), new ur(up.aG), new ur(up.aw)));
        LiquidHelper.injectTinContainer(new LiquidContainerData(new LiquidStack(amq.G, 1000), new ur(ForestryItem.canLava), new ur(ForestryItem.canEmpty)));
        LiquidHelper.injectRefractoryContainer(new LiquidContainerData(new LiquidStack(amq.G, 1000), new ur(ForestryItem.refractoryLava), new ur(ForestryItem.refractoryEmpty)));
        LiquidHelper.injectLiquidContainer(new LiquidContainerData(new LiquidStack(amq.E, 1000), new ur((up)up.bs, 1, 0), new ur(up.bt)));
        LiquidHelper.injectTinContainer(new LiquidContainerData(new LiquidStack(amq.E, 1000), new ur(ForestryItem.canWater), new ur(ForestryItem.canEmpty)));
        LiquidHelper.injectWaxContainer(new LiquidContainerData(new LiquidStack(amq.E, 1000), new ur(ForestryItem.waxCapsuleWater), new ur(ForestryItem.waxCapsule)));
        LiquidHelper.injectRefractoryContainer(new LiquidContainerData(new LiquidStack(amq.E, 1000), new ur(ForestryItem.refractoryWater), new ur(ForestryItem.refractoryEmpty)));
        LiquidHelper.injectLiquidContainer(LiquidHelper.createLiquidData("biomass", new LiquidStack(ForestryItem.liquidBiomass, 1000), new ur(ForestryItem.bucketBiomass), new ur(up.aw)));
        LiquidHelper.injectTinContainer(LiquidHelper.createLiquidData("biomass", new LiquidStack(ForestryItem.liquidBiomass, 1000), new ur(ForestryItem.canBiomass), new ur(ForestryItem.canEmpty)));
        LiquidHelper.injectWaxContainer(LiquidHelper.createLiquidData("biomass", new LiquidStack(ForestryItem.liquidBiomass, 1000), new ur(ForestryItem.waxCapsuleBiomass), new ur(ForestryItem.waxCapsule)));
        LiquidHelper.injectRefractoryContainer(LiquidHelper.createLiquidData("biomass", new LiquidStack(ForestryItem.liquidBiomass, 1000), new ur(ForestryItem.refractoryBiomass), new ur(ForestryItem.refractoryEmpty)));
        LiquidHelper.injectLiquidContainer(LiquidHelper.createLiquidData("biofuel", new LiquidStack(ForestryItem.liquidBiofuel, 1000), new ur(ForestryItem.bucketBiofuel), new ur(up.aw)));
        LiquidHelper.injectTinContainer(LiquidHelper.createLiquidData("biofuel", new LiquidStack(ForestryItem.liquidBiofuel, 1000), new ur(ForestryItem.canBiofuel), new ur(ForestryItem.canEmpty)));
        LiquidHelper.injectWaxContainer(LiquidHelper.createLiquidData("biofuel", new LiquidStack(ForestryItem.liquidBiofuel, 1000), new ur(ForestryItem.waxCapsuleBiofuel), new ur(ForestryItem.waxCapsule)));
        LiquidHelper.injectRefractoryContainer(LiquidHelper.createLiquidData("biofuel", new LiquidStack(ForestryItem.liquidBiofuel, 1000), new ur(ForestryItem.refractoryBiofuel), new ur(ForestryItem.refractoryEmpty)));
        LiquidHelper.injectTinContainer(LiquidHelper.createLiquidData("seedoil", new LiquidStack(ForestryItem.liquidSeedOil, 1000), new ur(ForestryItem.canSeedOil), new ur(ForestryItem.canEmpty)));
        LiquidHelper.injectWaxContainer(LiquidHelper.createLiquidData("seedoil", new LiquidStack(ForestryItem.liquidSeedOil, 1000), new ur(ForestryItem.waxCapsuleSeedOil), new ur(ForestryItem.waxCapsule)));
        LiquidHelper.injectRefractoryContainer(LiquidHelper.createLiquidData("seedoil", new LiquidStack(ForestryItem.liquidSeedOil, 1000), new ur(ForestryItem.refractorySeedOil), new ur(ForestryItem.refractoryEmpty)));
        LiquidHelper.injectTinContainer(LiquidHelper.createLiquidData("honey", new LiquidStack(ForestryItem.liquidHoney, 1000), new ur(ForestryItem.canHoney), new ur(ForestryItem.canEmpty)));
        LiquidHelper.injectWaxContainer(LiquidHelper.createLiquidData("honey", new LiquidStack(ForestryItem.liquidHoney, 1000), new ur(ForestryItem.waxCapsuleHoney), new ur(ForestryItem.waxCapsule)));
        LiquidHelper.injectRefractoryContainer(LiquidHelper.createLiquidData("honey", new LiquidStack(ForestryItem.liquidHoney, 1000), new ur(ForestryItem.refractoryHoney), new ur(ForestryItem.refractoryEmpty)));
        LiquidHelper.injectTinContainer(LiquidHelper.createLiquidData("juice", new LiquidStack(ForestryItem.liquidJuice, 1000), new ur(ForestryItem.canJuice), new ur(ForestryItem.canEmpty)));
        LiquidHelper.injectWaxContainer(LiquidHelper.createLiquidData("juice", new LiquidStack(ForestryItem.liquidJuice, 1000), new ur(ForestryItem.waxCapsuleJuice), new ur(ForestryItem.waxCapsule)));
        LiquidHelper.injectRefractoryContainer(LiquidHelper.createLiquidData("juice", new LiquidStack(ForestryItem.liquidJuice, 1000), new ur(ForestryItem.refractoryJuice), new ur(ForestryItem.refractoryEmpty)));
        LiquidHelper.injectTinContainer(LiquidHelper.createLiquidData("ice", new LiquidStack(ForestryItem.liquidIce, 1000), new ur(ForestryItem.canIce), new ur(ForestryItem.canEmpty)));
        LiquidHelper.injectWaxContainer(LiquidHelper.createLiquidData("ice", new LiquidStack(ForestryItem.liquidIce, 1000), new ur(ForestryItem.waxCapsuleIce), new ur(ForestryItem.waxCapsule)));
        LiquidHelper.injectRefractoryContainer(LiquidHelper.createLiquidData("ice", new LiquidStack(ForestryItem.liquidIce, 1000), new ur(ForestryItem.refractoryIce), new ur(ForestryItem.refractoryEmpty)));
        Config.modsLoaded();
        FMLLog.fine((String)("Using " + PowerFramework.currentFramework.getClass().getName() + " as framework."), (Object[])new Object[0]);
        for (IPlugin plugin : PluginManager.plugins) {
            if (!plugin.isAvailable()) continue;
            plugin.postInit();
        }
        GadgetManager.registerAllPackageNames();
        GameRegistry.registerFuelHandler((IFuelHandler)new FuelHandler());
        TickRegistry.registerTickHandler((ITickHandler)new TickHandlerCoreServer(), (Side)Side.SERVER);
        TickRegistry.registerTickHandler((ITickHandler)new TickHandlerCoreClient(), (Side)Side.CLIENT);
    }

    public void serverStarting(MinecraftServer server) {
        x commandManager = (x)server.E();
        for (IPlugin plugin : PluginManager.plugins) {
            y[] commands;
            if (!plugin.isAvailable() || (commands = plugin.getConsoleCommands()) == null) continue;
            for (y command : commands) {
                commandManager.a(command);
            }
        }
    }

    public String getPriorities() {
        return "after:mod_IC2;after:mod_BuildCraftCore;after:mod_BuildCraftEnergy;after:mod_BuildCraftFactory;after:mod_BuildCraftSilicon;after:mod_BuildCraftTransport;after:mod_RedPowerWorld";
    }
}

