/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import forestry.core.config.Config;
import forestry.core.config.Version;
import forestry.core.proxy.Proxies;
import java.util.EnumSet;
import java.util.concurrent.ConcurrentLinkedQueue;

public class TickHandlerCoreClient
implements ITickHandler,
Runnable {
    private static ConcurrentLinkedQueue messages = new ConcurrentLinkedQueue();
    private boolean nagged;

    public void queueChatMessage(String message) {
        messages.add(message);
    }

    public void tickStart(EnumSet type, Object ... tickData) {
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
        if (messages.size() > 0) {
            String message;
            qx player = (qx)tickData[0];
            while ((message = (String)messages.poll()) != null) {
                player.a(message);
            }
        }
        if (this.nagged) {
            return;
        }
        if (!Config.disableNags && Proxies.common.isModLoaded("GregTech_Addon")) {
            this.queueChatMessage("\u00a76Forestry may have been modified by GregTech. It may behave unexpectedly and some config options may not work. Do not report issues with this install!");
        }
        if (!Config.disableVersionCheck) {
            new Thread(new TickHandlerCoreClient()).start();
        }
        this.nagged = true;
    }

    @Override
    public void run() {
        if (Version.needsUpdateNoticeAndMarkAsSeen()) {
            this.queueChatMessage(String.format("\u00a7cNew version of Forestry available: %s for Minecraft %s", Version.getRecommendedVersion(), Proxies.common.getMinecraftVersion()));
            for (String updateLine : Version.getChangelog()) {
                this.queueChatMessage("\u00a79" + updateLine);
            }
            this.queueChatMessage("\u00a7cThis message only displays once. Type '/forestry version' if you want to see it again.");
        }
    }

    public EnumSet ticks() {
        return EnumSet.of(TickType.PLAYER);
    }

    public String getLabel() {
        return "Forestry - Player update tick";
    }
}

