/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitBoard;
import forestry.core.circuits.EnumCircuitBoardType;
import java.util.ArrayList;
import java.util.List;

public class CircuitBoard
implements ICircuitBoard {
    EnumCircuitBoardType type;
    ICircuit[] circuits;

    public CircuitBoard(EnumCircuitBoardType type, ICircuit[] circuits) {
        this.type = type;
        this.circuits = circuits;
    }

    public CircuitBoard(bq nbttagcompound) {
        this.readFromNBT(nbttagcompound);
    }

    @Override
    public int getPrimaryColor() {
        return this.type.primaryColor;
    }

    @Override
    public int getSecondaryColor() {
        return this.type.secondaryColor;
    }

    @Override
    public void addTooltip(List list) {
        for (ICircuit circuit : this.circuits) {
            circuit.addTooltip(list);
        }
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        this.type = EnumCircuitBoardType.values()[nbttagcompound.d("T")];
        ArrayList<ICircuit> readcircuits = new ArrayList<ICircuit>();
        if (nbttagcompound.b("CS")) {
            by nbttaglist = nbttagcompound.m("CS");
            for (int i = 0; i < nbttaglist.c(); ++i) {
                bq nbttagcompound1 = (bq)nbttaglist.b(i);
                readcircuits.add(ChipsetManager.circuitRegistry.getFromLegacyMap(nbttagcompound1.e("I")));
            }
            this.circuits = readcircuits.toArray(new ICircuit[0]);
            return;
        }
        by nbttaglist = nbttagcompound.m("CL");
        for (int i = 0; i < nbttaglist.c(); ++i) {
            bq nbttagcompound1 = (bq)nbttaglist.b(i);
            readcircuits.add(ChipsetManager.circuitRegistry.getCircuit(nbttagcompound1.i("I")));
        }
        this.circuits = readcircuits.toArray(new ICircuit[0]);
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        nbttagcompound.a("T", (short)this.type.ordinal());
        by nbttaglist = new by();
        for (ICircuit circuit : this.circuits) {
            bq nbttagcompound1 = new bq();
            nbttagcompound1.a("I", circuit.getUID());
            nbttaglist.a((cd)nbttagcompound1);
        }
        nbttagcompound.a("CL", (cd)nbttaglist);
    }

    @Override
    public void onInsertion(any tile) {
        for (ICircuit circuit : this.circuits) {
            circuit.onInsertion(tile);
        }
    }

    @Override
    public void onLoad(any tile) {
        for (ICircuit circuit : this.circuits) {
            circuit.onLoad(tile);
        }
    }

    @Override
    public void onRemoval(any tile) {
        for (ICircuit circuit : this.circuits) {
            circuit.onRemoval(tile);
        }
    }

    @Override
    public void onTick(any tile) {
        for (ICircuit circuit : this.circuits) {
            circuit.onTick(tile);
        }
    }
}

