/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ISolderManager;
import forestry.api.core.ForestryAPI;
import forestry.core.circuits.EnumCircuitBoardType;
import forestry.core.circuits.ISolderingIron;
import forestry.core.circuits.ItemCircuitBoard;
import forestry.core.items.ItemForestry;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ItemInventory;
import java.util.ArrayList;

public class ItemSolderingIron
extends ItemForestry
implements ISolderingIron {
    public ItemSolderingIron(int i) {
        super(i);
        this.ck = 1;
        this.e(5);
        this.a(tj.i);
    }

    public boolean n_() {
        return true;
    }

    public ur a(ur itemstack, yc world, qx entityplayer) {
        if (Proxies.common.isSimulating(world)) {
            entityplayer.openGui(ForestryAPI.instance, GuiId.SolderingIronGUI.ordinal(), world, (int)entityplayer.t, (int)entityplayer.u, (int)entityplayer.v);
        }
        return itemstack;
    }

    public static class SolderingInventory
    extends ItemInventory {
        short blankSlot = 0;
        short finishedSlot = 1;
        short ingredientSlot1 = (short)2;

        public SolderingInventory() {
            super(6);
        }

        public SolderingInventory(ur itemstack) {
            super(6, itemstack);
        }

        public void trySolder() {
            if (this.inventoryStacks[this.blankSlot] == null) {
                return;
            }
            if (this.inventoryStacks[this.finishedSlot] != null) {
                return;
            }
            ur blank = this.inventoryStacks[this.blankSlot];
            if (!ItemCircuitBoard.isChipset(blank)) {
                return;
            }
            if (blank.j() < 0 || blank.j() >= EnumCircuitBoardType.values().length) {
                return;
            }
            EnumCircuitBoardType type = EnumCircuitBoardType.values()[blank.j()];
            ArrayList<ICircuit> circuits = new ArrayList<ICircuit>();
            for (short i = 0; i < type.sockets; i = (short)(i + 1)) {
                CircuitRecipe recipe;
                ur ingredient = this.inventoryStacks[this.ingredientSlot1 + i];
                if (ingredient == null || (recipe = SolderManager.getMatchingRecipe(ingredient)) == null || this.getCount(recipe.circuit, circuits) >= recipe.circuit.getLimit()) continue;
                this.a(this.ingredientSlot1 + i, recipe.resource.a);
                circuits.add(recipe.circuit);
            }
            if (circuits.size() <= 0) {
                return;
            }
            this.inventoryStacks[this.finishedSlot] = ItemCircuitBoard.createCircuitboard(type, circuits.toArray(new ICircuit[0]));
            this.inventoryStacks[this.blankSlot] = null;
        }

        public int getCount(ICircuit circuit, ArrayList circuits) {
            int count = 0;
            for (ICircuit other : circuits) {
                if (!other.getUID().equals(circuit.getUID())) continue;
                ++count;
            }
            return count;
        }

        @Override
        public void readFromNBT(bq nbttagcompound) {
        }

        @Override
        public void writeToNBT(bq nbttagcompound) {
        }

        @Override
        public void d() {
            this.trySolder();
        }
    }

    public static class SolderManager
    implements ISolderManager {
        public static ArrayList recipes = new ArrayList();

        @Override
        public void addRecipe(ur resource, ICircuit circuit) {
            recipes.add(new CircuitRecipe(resource, circuit));
        }

        public static CircuitRecipe getMatchingRecipe(ur resource) {
            if (resource == null) {
                return null;
            }
            for (CircuitRecipe recipe : recipes) {
                if (!recipe.matches(resource)) continue;
                return recipe;
            }
            return null;
        }
    }

    public static class CircuitRecipe {
        ur resource;
        ICircuit circuit;

        public CircuitRecipe(ur resource, ICircuit circuit) {
            this.resource = resource;
            this.circuit = circuit;
        }

        public boolean matches(ur itemstack) {
            return itemstack.a(this.resource);
        }
    }
}

