/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.config;

import buildcraft.api.power.PowerFramework;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.GlobalManager;
import forestry.core.BioPowerFramework;
import forestry.core.config.Configuration;
import forestry.core.config.ConfigureBlocks;
import forestry.core.config.Property;
import forestry.core.proxy.Proxies;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.utils.Localization;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Properties;

public class Config {
    public static final String CATEGORY_COMMON = "common";
    public static net.minecraftforge.common.Configuration idConfig;
    public static Configuration config;
    public static String gameMode;
    public static boolean disableApiculture;
    public static boolean disableArboriculture;
    public static boolean disableCultivation;
    public static boolean disableEnergy;
    public static boolean disableFactory;
    public static boolean disableFarming;
    public static boolean disableFood;
    public static boolean disableMail;
    public static boolean disableStorage;
    public static boolean disableNags;
    public static boolean disableVersionCheck;
    public static boolean invalidFingerprint;
    public static boolean enableParticleFX;
    public static boolean clearInvalidChromosomes;
    public static boolean dungeonLootRare;
    public static boolean generateApatiteOre;
    public static boolean generateCopperOre;
    public static boolean generateTinOre;
    public static boolean generateBeehives;
    public static boolean generateBogEarth;
    public static boolean enableBackpackResupply;
    public static int planterThrottle;
    public static int harvesterThrottle;
    public static boolean usesHarvesters;
    public static boolean tooltipLiquidAmount;
    public static boolean planterSideSensitive;
    public static boolean harvesterSideSensitive;
    public static boolean craftingBronzeEnabled;
    public static boolean craftingFarmsEnabled;
    public static boolean craftingStampsEnabled;
    public static boolean applePickup;
    public static boolean mailAlertEnabled;
    public static boolean disableHints;
    public static HashMap hints;
    public static boolean disableEnergyStat;

    public static void load() {
        File hardMode;
        idConfig = new net.minecraftforge.common.Configuration(new File(Proxies.common.getForestryRoot(), "config/forestry/base.conf"));
        idConfig.load();
        config = new Configuration();
        if (PowerFramework.currentFramework == null) {
            Property powerFrameworkClass = config.get("power.framework", CATEGORY_COMMON, "forestry.energy.BioPowerFramework");
            try {
                PowerFramework.currentFramework = (PowerFramework)Class.forName(powerFrameworkClass.Value).getConstructor(null).newInstance(null);
            }
            catch (Throwable e) {
                PowerFramework.currentFramework = new BioPowerFramework();
            }
        }
        Property property = config.get("difficulty.gamemode", CATEGORY_COMMON, "EASY");
        property.Comment = "set to your preferred game mode. available modes are EASY, NORMAL, HARD. mismatch with the server may cause visual glitches with recipes. setting an unavailable mode will create a new mode definition file.";
        gameMode = property.Value;
        File normalMode = config.getCategoryFile("gamemodes/NORMAL");
        if (!normalMode.exists()) {
            Config.CopyFileToFS(normalMode, "/config/forestry/gamemodes/NORMAL.conf");
        }
        if (!(hardMode = config.getCategoryFile("gamemodes/HARD")).exists()) {
            Config.CopyFileToFS(hardMode, "/config/forestry/gamemodes/HARD.conf");
        }
        Property particleFX = config.get("performance.particleFX.enabled", CATEGORY_COMMON, true);
        particleFX.Comment = "set to false to disable particle fx on slower machines";
        enableParticleFX = Boolean.parseBoolean(particleFX.Value);
        Property genApatiteOre = config.get("world.generate.apatite", CATEGORY_COMMON, true);
        genApatiteOre.Comment = "set to false to force forestry to skip generating own apatite ore blocks in the world";
        generateApatiteOre = Boolean.parseBoolean(genApatiteOre.Value);
        Property genBeehives = config.get("world.generate.beehives", CATEGORY_COMMON, true);
        genBeehives.Comment = "set to false to force forestry to skip generating beehives in the world";
        generateBeehives = Boolean.parseBoolean(genBeehives.Value);
        Property genCopperOre = config.get("world.generate.copper", CATEGORY_COMMON, true);
        genCopperOre.Comment = "set to false to force forestry to skip generating own copper ore blocks in the world";
        generateCopperOre = Boolean.parseBoolean(genCopperOre.Value);
        Property genTinOre = config.get("world.generate.tin", CATEGORY_COMMON, true);
        genTinOre.Comment = "set to false to force forestry to skip generating own tin ore blocks in the world";
        generateTinOre = Boolean.parseBoolean(genTinOre.Value);
        Property planterSideSense = config.get("planters.sidesensitive", CATEGORY_COMMON, true);
        planterSideSense.Comment = "set to false if farms should output all harvested products regardless of side a pipe is attached to";
        planterSideSensitive = Boolean.parseBoolean(planterSideSense.Value);
        Property harvesterSideSense = config.get("harvesters.sidesensitive", CATEGORY_COMMON, true);
        harvesterSideSense.Comment = "set to false if harvesters should output all harvested products regardless of side a pipe is attached to";
        harvesterSideSensitive = Boolean.parseBoolean(harvesterSideSense.Value);
        Property bronzeRecipe = config.get("crafting.bronze.enabled", CATEGORY_COMMON, true);
        bronzeRecipe.Comment = "set to false to disable crafting recipe for bronze";
        craftingBronzeEnabled = Boolean.parseBoolean(bronzeRecipe.Value);
        Property farmsEnable = config.get("crafting.farms.enabled", CATEGORY_COMMON, true);
        farmsEnable.Comment = "set to false to disable crafting recipes for all farms (harvesters and planters)";
        craftingFarmsEnabled = Boolean.parseBoolean(farmsEnable.Value);
        Property craftingStamps = config.get("crafting.stamps.enabled", CATEGORY_COMMON, true);
        craftingStamps.Comment = "set to false to disable crafting recipes for stamps";
        craftingStampsEnabled = Boolean.parseBoolean(craftingStamps.Value);
        Property indicatorEnable = config.get("tweaks.mailalert.enabled", CATEGORY_COMMON, true);
        indicatorEnable.Comment = "set to false to disable the mail alert box";
        mailAlertEnabled = Boolean.parseBoolean(indicatorEnable.Value);
        Property appleHarvest = config.get("tweaks.apple.pickup.enabled", CATEGORY_COMMON, true);
        appleHarvest.Comment = "set to false to disable apple pickup by appropriate harvesters";
        applePickup = Boolean.parseBoolean(appleHarvest.Value);
        Property clearGenome = config.get("genetics.invalid.chromosome.clearing", CATEGORY_COMMON, false);
        clearGenome.Comment = "set to true to clear chromosomes which contain invalid alleles. might rescue your save if it is crashing after removal of a bee addon.";
        clearInvalidChromosomes = Boolean.parseBoolean(clearGenome.Value);
        Property dungeonLootRarity = config.get("difficulty.dungeonloot.rare", CATEGORY_COMMON, false);
        dungeonLootRarity.Comment = "set to true to make dungeon loot generated by forestry rarer";
        dungeonLootRare = Boolean.parseBoolean(dungeonLootRarity.Value);
        Property resupplyEnable = config.get("performance.backpacks.resupply", CATEGORY_COMMON, true);
        resupplyEnable.Comment = "leaving this enabled will cycle the list of active players PER INGAME TICK to check for resupply via backpack. you want to set this to false on busy servers.";
        enableBackpackResupply = Boolean.parseBoolean(resupplyEnable.Value);
        Property propThrottle = config.get("performance.planter", CATEGORY_COMMON, 10);
        propThrottle.Comment = "higher numbers increase working speeds of planters but also increase cpu load.";
        planterThrottle = Integer.parseInt(propThrottle.Value);
        propThrottle = config.get("performance.harvester", CATEGORY_COMMON, 200);
        propThrottle.Comment = "higher numbers increase working speeds of harvesters but also increase cpu load.";
        harvesterThrottle = Integer.parseInt(propThrottle.Value);
        property = config.get("tweaks.hints.disabled", CATEGORY_COMMON, false);
        property.Comment = "set to true to disable hints on machine and engine guis.";
        disableHints = Boolean.parseBoolean(property.Value);
        property = config.get("tweaks.energystat.disabled", CATEGORY_COMMON, true);
        property.Comment = "set to true to disable energy statistics on energy consumers.";
        disableEnergyStat = Boolean.parseBoolean(property.Value);
        property = config.get("tweaks.tooltip.liquidamount.disabled", CATEGORY_COMMON, true);
        property.Comment = "set to true to disable displaying liquid amounts in tank tooltips.";
        tooltipLiquidAmount = !Boolean.parseBoolean(property.Value);
        property = config.get("tweaks.nags.disabled", CATEGORY_COMMON, false);
        property.Comment = "set to true to disable some nagging and warnings (e.g. GregTech).";
        disableNags = Boolean.parseBoolean(property.Value);
        property = config.get("tweaks.upgradenotice.disabled", CATEGORY_COMMON, false);
        property.Comment = "set to true to disable update and version check notice.";
        disableVersionCheck = Boolean.parseBoolean(property.Value);
        Config.registerClimates();
        ConfigureBlocks.initialize();
        ForestryTrigger.initialize();
        GlobalManager.leafBlockIds.add(amq.N.cm);
        GlobalManager.dirtBlockIds.add(amq.y.cm);
        GlobalManager.dirtBlockIds.add(amq.x.cm);
        GlobalManager.sandBlockIds.add(amq.H.cm);
        GlobalManager.snowBlockIds.add(amq.aV.cm);
        config.save();
        idConfig.save();
        Config.loadHints();
    }

    public static void modsLoaded() {
    }

    private static void CopyFileToFS(File destination, String resourcePath) {
        InputStream stream = Config.class.getResourceAsStream(resourcePath);
        byte[] buffer = new byte[4096];
        try {
            int readBytes;
            if (destination.getParentFile() != null) {
                destination.getParentFile().mkdirs();
            }
            if (!destination.exists() && !destination.createNewFile()) {
                return;
            }
            FileOutputStream outstream = new FileOutputStream(destination);
            while ((readBytes = stream.read(buffer)) > 0) {
                ((OutputStream)outstream).write(buffer, 0, readBytes);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void loadHints() {
        Properties prop = new Properties();
        try {
            InputStream hintStream = Localization.class.getResourceAsStream("/config/forestry/hints.properties");
            prop.load(hintStream);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (String key : prop.stringPropertyNames()) {
            hints.put(key, Config.parseHints(prop.getProperty(key)));
        }
    }

    private static String[] parseHints(String list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.split("[;]+");
    }

    private static void registerClimates() {
        for (yy biome : yy.a) {
            if (biome == null) continue;
            if (biome.N == yy.j.N) {
                EnumTemperature.hellishBiomeIds.add(biome.N);
                continue;
            }
            if (biome.F >= 2.0f) {
                EnumTemperature.hotBiomeIds.add(biome.N);
                continue;
            }
            if (biome.F >= 1.2f) {
                EnumTemperature.warmBiomeIds.add(biome.N);
                continue;
            }
            if (biome.F >= 0.2f) {
                EnumTemperature.normalBiomeIds.add(biome.N);
                continue;
            }
            if (biome.F >= 0.15f) {
                EnumTemperature.coldBiomeIds.add(biome.N);
                continue;
            }
            EnumTemperature.icyBiomeIds.add(biome.N);
        }
        for (yy biome : yy.a) {
            if (biome == null) continue;
            if (biome.G >= 0.9f) {
                EnumHumidity.dampBiomeIds.add(biome.N);
                continue;
            }
            if (biome.G >= 0.3f) {
                EnumHumidity.normalBiomeIds.add(biome.N);
                continue;
            }
            EnumHumidity.aridBiomeIds.add(biome.N);
        }
    }

    public static int getOrCreateBlockIdProperty(String key, int defaultId) {
        int blockid = Integer.parseInt(Config.idConfig.getBlock((String)key, (int)defaultId).value);
        idConfig.save();
        return blockid;
    }

    public static int getOrCreateItemIdProperty(String key, int defaultId) {
        int itemid = Integer.parseInt(Config.idConfig.getItem((String)key, (int)defaultId).value);
        idConfig.save();
        return itemid;
    }

    public static boolean getOrCreateBooleanProperty(String key, String kind, boolean defaults) {
        return Boolean.parseBoolean(Config.config.get((String)key, (String)kind, (boolean)defaults).Value);
    }

    static {
        disableApiculture = false;
        disableArboriculture = false;
        disableCultivation = false;
        disableEnergy = false;
        disableFactory = false;
        disableFarming = true;
        disableFood = false;
        disableMail = false;
        disableStorage = false;
        disableNags = false;
        disableVersionCheck = false;
        invalidFingerprint = false;
        enableParticleFX = true;
        clearInvalidChromosomes = false;
        dungeonLootRare = false;
        generateApatiteOre = true;
        generateCopperOre = true;
        generateTinOre = true;
        generateBeehives = true;
        generateBogEarth = false;
        enableBackpackResupply = true;
        usesHarvesters = true;
        tooltipLiquidAmount = false;
        planterSideSensitive = true;
        harvesterSideSensitive = true;
        craftingBronzeEnabled = true;
        craftingFarmsEnabled = true;
        craftingStampsEnabled = true;
        applePickup = true;
        mailAlertEnabled = true;
        disableHints = false;
        hints = new HashMap();
        disableEnergyStat = false;
    }
}

