/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import cpw.mods.fml.common.FMLLog;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.proxy.Proxies;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.IPlantable;

public class BlockSoil
extends amq {
    private int degradeDelimiter = 3;
    private int textureHumus = 1;
    private int textureBogEarth = 13;
    private int texturePeat = 15;

    public BlockSoil(int i) {
        super(i, agi.p);
        this.b(true);
        this.c(0.5f);
        this.b("humus");
        this.a(g);
        this.setTextureFile("/gfx/forestry/blocks/blocks.png");
        this.a(tj.b);
    }

    public int r_() {
        return 500;
    }

    public ArrayList getBlockDropped(yc world, int x2, int y2, int z2, int metadata, int fortune) {
        ArrayList<ur> ret = new ArrayList<ur>();
        int type = metadata & 3;
        int maturity = metadata >> 2;
        if (maturity >= this.degradeDelimiter && type == 1) {
            ret.add(new ur(ForestryItem.peat));
            ret.add(new ur(amq.y));
        } else {
            ret.add(new ur((amq)this, 1, type));
        }
        return ret;
    }

    public void b(yc world, int i, int j, int k, Random random) {
        if (!Proxies.common.isSimulating(world)) {
            return;
        }
        int meta = world.h(i, j, k);
        int type = meta & 3;
        if (type == 0) {
            this.updateTickHumus(world, i, j, k, random);
        } else if (type == 1) {
            this.updateTickBogEarth(world, i, j, k, random);
        } else {
            FMLLog.warning((String)(((Object)((Object)this)).getClass() + " with unknown type " + type + " encountered."), (Object[])new Object[0]);
        }
    }

    private void updateTickHumus(yc world, int i, int j, int k, Random random) {
        if (this.isEnrooted(world, i, j, k)) {
            this.degradeSoil(world, i, j, k);
        }
    }

    private void updateTickBogEarth(yc world, int i, int j, int k, Random random) {
        if (this.isMoistened(world, i, j, k)) {
            this.matureBog(world, i, j, k);
        }
    }

    private boolean isEnrooted(yc world, int x2, int y2, int z2) {
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                int blockid = world.a(x2 + i, y2 + 1, z2 + j);
                if (blockid != amq.M.cm && blockid != amq.B.cm && blockid != ForestryBlock.firsapling.cm) continue;
                return i != 0 || j != 0;
            }
        }
        return false;
    }

    private void degradeSoil(yc world, int i, int j, int k) {
        if (world.t.nextInt(70) != 0) {
            return;
        }
        int meta = world.h(i, j, k);
        int type = meta & 3;
        int grade = meta >> 2;
        meta = ++grade << 2 | type;
        if (grade >= this.degradeDelimiter) {
            world.e(i, j, k, amq.H.cm);
        } else {
            world.c(i, j, k, meta);
        }
        world.i(i, j, k);
    }

    private boolean isMoistened(yc world, int x2, int y2, int z2) {
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                int blockid = world.a(x2 + i, y2, z2 + j);
                if (blockid != amq.E.cm && blockid != amq.D.cm) continue;
                return true;
            }
        }
        return false;
    }

    private void matureBog(yc world, int i, int j, int k) {
        if (world.t.nextInt(13) != 0) {
            return;
        }
        int meta = world.h(i, j, k);
        int type = meta & 3;
        int maturity = meta >> 2;
        if (maturity >= this.degradeDelimiter) {
            return;
        }
        meta = ++maturity << 2 | type;
        world.c(i, j, k, meta);
        world.i(i, j, k);
    }

    public boolean canSustainPlant(yc world, int x2, int y2, int z2, ForgeDirection direction, IPlantable plant) {
        EnumPlantType plantType = plant.getPlantType(world, x2, y2, z2);
        if (plantType != EnumPlantType.Crop && plantType != EnumPlantType.Plains) {
            return false;
        }
        int meta = world.h(x2, y2, z2);
        return (meta & 3) == 0;
    }

    public void a(int par1, tj par2CreativeTabs, List itemList) {
        itemList.add(new ur((amq)this, 1, 0));
        itemList.add(new ur((amq)this, 1, 1));
    }

    public int a(int i, int j) {
        int meta = j;
        int type = meta & 3;
        int maturity = meta >> 2;
        if (type == 0) {
            return this.textureHumus;
        }
        if (type == 1) {
            if (maturity < this.degradeDelimiter) {
                return this.textureBogEarth;
            }
            return this.texturePeat;
        }
        return 0;
    }
}

