/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.core.gadgets.Gadget;
import forestry.core.gadgets.TileMachine;
import forestry.core.interfaces.IBlockRenderer;
import forestry.core.network.ClassMap;
import forestry.core.network.IndexInPayload;
import forestry.core.network.PacketPayload;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.TankSlot;
import ic2.api.Direction;
import net.minecraftforge.liquids.LiquidContainerData;

public abstract class Machine
extends Gadget {
    public IBlockRenderer customRender = null;

    @Override
    public PacketPayload getPacketPayload() {
        if (!ClassMap.classMappers.containsKey(this.getClass())) {
            ClassMap.classMappers.put(this.getClass(), new ClassMap(this.getClass()));
        }
        ClassMap classmap = (ClassMap)ClassMap.classMappers.get(this.getClass());
        PacketPayload payload = new PacketPayload(classmap.intSize, classmap.floatSize, classmap.stringSize);
        try {
            classmap.setData(this, payload.intPayload, payload.floatPayload, payload.stringPayload, new IndexInPayload(0, 0, 0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return payload;
    }

    @Override
    public void fromPacketPayload(PacketPayload payload, IndexInPayload index) {
        if (payload.isEmpty()) {
            return;
        }
        if (!ClassMap.classMappers.containsKey(this.getClass())) {
            ClassMap.classMappers.put(this.getClass(), new ClassMap(this.getClass()));
        }
        ClassMap classmap = (ClassMap)ClassMap.classMappers.get(this.getClass());
        try {
            classmap.fromData(this, payload.intPayload, payload.floatPayload, payload.stringPayload, index);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Machine(TileMachine tile) {
        super(tile);
    }

    public abstract String getName();

    public void onRemoval() {
    }

    public boolean canInteractWith(qx player) {
        return true;
    }

    public abstract boolean doWork();

    public abstract boolean isWorking();

    public boolean hasResourcesMin(float percentage) {
        return false;
    }

    public boolean hasFuelMin(float percentage) {
        return false;
    }

    public boolean hasWork() {
        return false;
    }

    public boolean isClimatized() {
        return false;
    }

    public EnumTemperature getTemperature() {
        return EnumTemperature.NORMAL;
    }

    public EnumHumidity getHumidity() {
        return EnumHumidity.NORMAL;
    }

    protected void replenishByContainer(ur inventoryStack, TankSlot tank) {
        LiquidContainerData container = LiquidHelper.getLiquidContainer(inventoryStack);
        this.replenishByContainer(inventoryStack, container, tank);
    }

    protected ur replenishByContainer(ur inventoryStack, LiquidContainerData container, TankSlot tank) {
        if (container == null) {
            return inventoryStack;
        }
        if (tank.fill(container.stillLiquid, false) >= container.stillLiquid.amount) {
            tank.fill(container.stillLiquid, true);
            if (container.filled != null && container.filled.b().s()) {
                inventoryStack = container.container.l();
            } else {
                --inventoryStack.a;
            }
            this.tile.sendNetworkUpdate();
        }
        return inventoryStack;
    }

    protected ur bottleIntoContainer(ur canStack, ur outputStack, LiquidContainerData container, TankSlot tank) {
        if (tank.quantity < container.stillLiquid.amount) {
            return outputStack;
        }
        if (canStack.a <= 0) {
            return outputStack;
        }
        if (outputStack != null && !outputStack.a(container.filled)) {
            return outputStack;
        }
        if (outputStack != null && outputStack.a >= outputStack.d()) {
            return outputStack;
        }
        tank.quantity -= container.stillLiquid.amount;
        --canStack.a;
        if (outputStack == null) {
            outputStack = container.filled.l();
        } else {
            ++outputStack.a;
        }
        return outputStack;
    }

    public EnumTankLevel getPrimaryLevel() {
        return EnumTankLevel.EMPTY;
    }

    public EnumTankLevel getSecondaryLevel() {
        return EnumTankLevel.EMPTY;
    }

    public boolean isIndirectlyPoweringTo(ym world, int i, int j, int k, int l) {
        return false;
    }

    public boolean isPoweringTo(ym iblockaccess, int i, int j, int k, int l) {
        return false;
    }

    public void onNeighborBlockChange() {
    }

    public boolean emitsEnergyTo(any receiver, Direction direction) {
        return false;
    }

    public boolean isAddedToEnergyNet() {
        return false;
    }

    public int getMaxEnergyOutput() {
        return 0;
    }

    public void performAction(any entity) {
    }
}

