/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import forestry.api.core.IStructureLogic;
import forestry.api.core.ITileStructure;
import forestry.core.gadgets.BlockStructure;
import forestry.core.utils.Schemata;
import java.util.HashMap;

public abstract class StructureLogic
implements IStructureLogic {
    protected ITileStructure structure;
    protected any structureTile;
    protected String uid;
    protected Schemata[] schematas;
    protected short activeSchemata = (short)-1;
    protected boolean rotated = false;
    protected HashMap metaOnValid = new HashMap();

    public StructureLogic(String uid, ITileStructure structure) {
        this.uid = uid;
        this.structure = structure;
        this.structureTile = (any)structure;
    }

    @Override
    public String getTypeUID() {
        return this.uid;
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        if (nbttagcompound.b("SchemataOrdinal")) {
            this.activeSchemata = nbttagcompound.d("SchemataOrdinal");
        }
        if (nbttagcompound.b("Rotated")) {
            this.rotated = nbttagcompound.n("Rotated");
        }
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        if (this.activeSchemata >= 0) {
            nbttagcompound.a("SchemataOrdinal", this.activeSchemata);
        }
        nbttagcompound.a("Rotated", this.rotated);
    }

    @Override
    public void validateStructure() {
        ITileStructure master = this.structure.getCentralTE();
        if (!this.structure.isMaster() && master != null) {
            master.validateStructure();
        }
        BlockStructure.EnumStructureState state = BlockStructure.EnumStructureState.INDETERMINATE;
        boolean rotate = false;
        for (int i = 0; i < this.schematas.length; ++i) {
            state = this.determineMasterState(this.schematas[i], false);
            rotate = false;
            if (state == BlockStructure.EnumStructureState.INVALID && this.schematas[i].getWidth() != this.schematas[i].getDepth()) {
                state = this.determineMasterState(this.schematas[i], true);
                rotate = true;
            }
            if (state != BlockStructure.EnumStructureState.VALID) continue;
            this.activeSchemata = (short)i;
            this.rotated = rotate;
            break;
        }
        if (state == BlockStructure.EnumStructureState.INDETERMINATE) {
            return;
        }
        if (state == BlockStructure.EnumStructureState.VALID) {
            this.structure.makeMaster();
            this.markStructureBlocks(this.schematas[this.activeSchemata]);
        } else if (this.structure.isMaster()) {
            this.resetStructureBlocks(this.schematas[this.activeSchemata]);
        }
    }

    protected void resetStructureBlocks(Schemata schemata) {
        int maxW = schemata.getWidth();
        int maxD = schemata.getDepth();
        int offsetX = schemata.getxOffset();
        int offsetZ = schemata.getzOffset();
        if (this.rotated) {
            System.out.println("Resetting blocks with rotation.");
            maxW = schemata.getDepth();
            maxD = schemata.getWidth();
            offsetX = schemata.getzOffset();
            offsetZ = schemata.getxOffset();
        }
        for (int i = 0; i < maxW; ++i) {
            for (int j = 0; j < schemata.getHeight(); ++j) {
                for (int k = 0; k < maxD; ++k) {
                    ITileStructure part;
                    int z2;
                    int x2 = this.structureTile.l + i + offsetX;
                    int y2 = this.structureTile.m + j + schemata.getyOffset();
                    any tile = this.structureTile.k.q(x2, y2, z2 = this.structureTile.n + k + offsetZ);
                    if (!(tile instanceof ITileStructure) || !(part = (ITileStructure)tile).getTypeUID().equals(this.getTypeUID())) continue;
                    part.onStructureReset();
                }
            }
        }
    }

    protected void markStructureBlocks(Schemata schemata) {
        int maxW = schemata.getWidth();
        int maxD = schemata.getDepth();
        int offsetX = schemata.getxOffset();
        int offsetZ = schemata.getzOffset();
        if (this.rotated) {
            System.out.println("Marking blocks with rotation.");
            maxW = schemata.getDepth();
            maxD = schemata.getWidth();
            offsetX = schemata.getzOffset();
            offsetZ = schemata.getxOffset();
        }
        for (int i = 0; i < maxW; ++i) {
            for (int j = 0; j < schemata.getHeight(); ++j) {
                for (int k = 0; k < maxD; ++k) {
                    int z2;
                    int x2 = this.structureTile.l + i + offsetX;
                    int y2 = this.structureTile.m + j + schemata.getyOffset();
                    any tile = this.structureTile.k.q(x2, y2, z2 = this.structureTile.n + k + offsetZ);
                    if (!(tile instanceof ITileStructure) || !((ITileStructure)tile).getTypeUID().equals(this.getTypeUID())) continue;
                    ((ITileStructure)tile).setCentralTE((any)this.structure);
                    Schemata.EnumStructureBlock type = schemata.getAt(i, j, k, this.rotated);
                    if (!this.metaOnValid.containsKey((Object)type)) continue;
                    this.structureTile.k.c(x2, y2, z2, ((Integer)this.metaOnValid.get((Object)type)).intValue());
                    this.structureTile.k.i(x2, y2, z2);
                }
            }
        }
    }

    protected abstract BlockStructure.EnumStructureState determineMasterState(Schemata var1, boolean var2);
}

