/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import buildcraft.api.core.Position;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import cpw.mods.fml.common.FMLLog;
import forestry.core.gadgets.Engine;
import forestry.core.gadgets.EngineFactory;
import forestry.core.gadgets.EnginePackage;
import forestry.core.gadgets.Gadget;
import forestry.core.gadgets.GadgetManager;
import forestry.core.gadgets.TileForestry;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.interfaces.IParticularInventory;
import forestry.core.interfaces.ISocketable;
import forestry.core.network.IndexInPayload;
import forestry.core.network.PacketPayload;
import forestry.core.proxy.Proxies;
import forestry.core.utils.EnumAccess;
import forestry.plugins.PluginBuildCraft;
import ic2.api.Direction;
import ic2.api.energy.tile.IEnergySink;
import java.util.LinkedList;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;

public class TileEngine
extends TileForestry
implements IPowerReceptor,
ISidedInventory,
ILiquidTankContainer,
IParticularInventory,
IEnergySink,
ISocketable {
    public Engine engine;
    public boolean isActive = false;
    public int stagePiston = 0;
    public float pistonSpeedServer = 0.0f;
    private IPowerProvider powerProvider = PowerFramework.currentFramework.createPowerProvider();

    public TileEngine() {
        this.powerProvider.configure(0, 10, 200, 10, 100000);
    }

    @Override
    public void initialize() {
        if (!Proxies.common.isSimulating(this.k)) {
            return;
        }
        if (this.engine == null) {
            this.createEngine();
        }
    }

    private void createEngine() {
        if (this.engine != null) {
            return;
        }
        int meta = this.k.h(this.l, this.m, this.n);
        if (!GadgetManager.hasPlanterPackage(meta)) {
            FMLLog.info((String)("Encountered an engine with meta " + meta + ". However no such EnginePackage exists. Reverting to 0."), (Object[])new Object[0]);
            meta = 0;
        }
        this.pack = GadgetManager.getEnginePackage(meta);
        EngineFactory factory = ((EnginePackage)this.pack).factory;
        if (factory == null) {
            throw new RuntimeException("Missing EngineFactory for meta " + meta);
        }
        this.engine = factory.createEngine(this);
        this.k.h(this.l, this.m, this.n, meta);
    }

    @Override
    public void g() {
        if (!Proxies.common.isSimulating(this.k)) {
            if (this.stagePiston != 0) {
                this.engine.progress += this.pistonSpeedServer;
                if (this.engine.progress > 1.0f) {
                    this.stagePiston = 0;
                    this.engine.progress = 0.0f;
                }
            } else if (this.isActive) {
                this.stagePiston = 1;
            }
            return;
        }
        super.g();
        this.engine.updateServerSide();
        Position posTarget = new Position(this.l, this.m, this.n, this.getOrientation());
        posTarget.moveForwards(1.0);
        any tile = this.k.q((int)posTarget.x, (int)posTarget.y, (int)posTarget.z);
        float newPistonSpeed = this.engine.getPistonSpeed();
        if (newPistonSpeed != this.pistonSpeedServer) {
            this.pistonSpeedServer = newPistonSpeed;
            this.sendNetworkUpdate();
        }
        if (this.stagePiston != 0) {
            this.engine.progress += this.pistonSpeedServer;
            if ((double)this.engine.progress > 0.5 && this.stagePiston == 1) {
                IPowerReceptor receptor;
                int extractedEnergy;
                this.stagePiston = 2;
                if (this.isPoweredTile(tile) && (extractedEnergy = this.engine.extractEnergy((receptor = (IPowerReceptor)tile).getPowerProvider().getMinEnergyReceived(), receptor.getPowerProvider().getMaxEnergyReceived(), true)) > 0) {
                    PluginBuildCraft.instance.invokeReceiveEnergyMethod(receptor.getPowerProvider(), extractedEnergy);
                }
            } else if (this.engine.progress >= 1.0f) {
                this.engine.progress = 0.0f;
                this.stagePiston = 0;
            }
        } else if (this.canPowerTo(tile)) {
            IPowerReceptor receptor = (IPowerReceptor)tile;
            if (this.engine.extractEnergy(receptor.getPowerProvider().getMinEnergyReceived(), receptor.getPowerProvider().getMaxEnergyReceived(), false) > 0) {
                this.stagePiston = 1;
                this.setActive(true);
            } else {
                this.setActive(false);
            }
        } else {
            this.setActive(false);
        }
        this.engine.dissipateHeat();
        this.engine.generateHeat();
        if (this.engine.mayBurn()) {
            this.engine.burn();
        } else {
            this.engine.extractEnergy(0, 2, true);
        }
    }

    private void setActive(boolean isActive) {
        if (this.isActive == isActive) {
            return;
        }
        this.isActive = isActive;
        this.sendNetworkUpdate();
    }

    private boolean canPowerTo(any tile) {
        return this.isActivated() && this.isPoweredTile(tile);
    }

    public boolean isBurning() {
        return this.engine.isBurning();
    }

    public int getBurnTimeRemainingScaled(int i) {
        return this.engine.getBurnTimeRemainingScaled(i);
    }

    @Override
    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        PowerFramework.currentFramework.loadPowerProvider(this, nbttagcompound);
        int kind = nbttagcompound.e("Kind");
        this.pack = GadgetManager.getEnginePackage(kind);
        this.engine = ((EnginePackage)this.pack).factory.createEngine(this);
        this.engine.readFromNBT(nbttagcompound);
        this.stagePiston = nbttagcompound.e("stagePiston");
    }

    @Override
    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        PowerFramework.currentFramework.savePowerProvider(this, nbttagcompound);
        int kind = this.k.h(this.l, this.m, this.n);
        if (GadgetManager.hasEnginePackage(kind)) {
            nbttagcompound.a("Kind", kind);
        } else {
            nbttagcompound.a("Kind", 0);
        }
        this.engine.writeToNBT(nbttagcompound);
        nbttagcompound.a("stagePiston", this.stagePiston);
    }

    public boolean isPoweredTile(any tile) {
        if (tile == null) {
            return false;
        }
        if (!(tile instanceof IPowerReceptor)) {
            return false;
        }
        IPowerReceptor receptor = (IPowerReceptor)tile;
        return receptor.getPowerProvider() != null;
    }

    public void rotateEngine() {
        if (this.engine == null) {
            this.initialize();
            this.isInited = true;
        }
        for (int i = this.getOrientation().ordinal() + 1; i <= this.getOrientation().ordinal() + 6; ++i) {
            ForgeDirection orient = ForgeDirection.values()[i % 6];
            Position pos = new Position(this.l, this.m, this.n, orient);
            pos.moveForwards(1.0);
            any tile = this.k.q((int)pos.x, (int)pos.y, (int)pos.z);
            if (!this.isPoweredTile(tile)) continue;
            if (this.engine != null) {
                this.setOrientation(orient);
            }
            this.k.o(this.l, this.m, this.n);
            break;
        }
    }

    @Override
    public Gadget getMachine() {
        return this.engine;
    }

    public Engine getEngine() {
        return this.engine;
    }

    @Override
    public boolean throwsErrors() {
        return true;
    }

    @Override
    public boolean hasHints() {
        if (this.engine != null) {
            return this.engine.hasHints();
        }
        return false;
    }

    @Override
    public String[] getHints() {
        if (this.engine != null) {
            return this.engine.getHints();
        }
        return null;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public void doWork() {
        if (!Proxies.common.isSimulating(this.k)) {
            return;
        }
        this.engine.addEnergy((int)(PluginBuildCraft.instance.invokeUseEnergyMethod(this.powerProvider, 1.0f, this.engine.maxEnergyReceived(), true) * 0.95f));
    }

    @Override
    public int powerRequest() {
        return 0;
    }

    public int k_() {
        if (this.engine != null) {
            return this.engine.k_();
        }
        return 0;
    }

    public ur a(int i) {
        if (this.engine != null) {
            return this.engine.a(i);
        }
        return null;
    }

    public ur a(int i, int j) {
        if (this.engine != null) {
            return this.engine.a(i, j);
        }
        return null;
    }

    public void a(int i, ur itemstack) {
        if (this.engine != null) {
            this.engine.a(i, itemstack);
        }
    }

    public String b() {
        if (this.engine != null) {
            return this.engine.b();
        }
        return "";
    }

    public int c() {
        if (this.engine != null) {
            return this.engine.c();
        }
        return 64;
    }

    @Override
    public void l_() {
    }

    @Override
    public void f() {
    }

    public ur a_(int slot) {
        if (this.engine != null) {
            return this.engine.a_(slot);
        }
        return null;
    }

    public int getStartInventorySide(ForgeDirection side) {
        if (this.engine == null) {
            return 0;
        }
        return this.engine.getStartInventorySide(side.ordinal());
    }

    public int getSizeInventorySide(ForgeDirection side) {
        if (this.engine == null) {
            return 0;
        }
        return this.engine.getSizeInventorySide(side.ordinal());
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        if (this.getAccess() == EnumAccess.PRIVATE) {
            return 0;
        }
        if (from == this.getOrientation()) {
            return 0;
        }
        if (this.engine != null) {
            return this.engine.addItem(stack, doAdd, from);
        }
        return 0;
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        if (this.getAccess() == EnumAccess.PRIVATE) {
            return new ur[0];
        }
        if (from == this.getOrientation()) {
            return new ur[0];
        }
        if (this.engine != null) {
            return this.engine.extractItem(doRemove, from, maxItemCount);
        }
        return new ur[0];
    }

    @Override
    public PacketPayload getPacketPayload() {
        PacketPayload payload = new PacketPayload(1, 1, 0);
        payload.intPayload[0] = this.isActive ? 1 : 0;
        payload.floatPayload[0] = this.pistonSpeedServer;
        if (this.engine != null) {
            payload.append(this.engine.getPacketPayload());
        }
        return payload;
    }

    @Override
    public void fromPacketPayload(PacketPayload payload) {
        this.isActive = payload.intPayload[0] > 0;
        this.pistonSpeedServer = payload.floatPayload[0];
        if (this.engine == null) {
            this.createEngine();
        }
        this.engine.fromPacketPayload(payload, new IndexInPayload(1, 1, 0));
    }

    @Override
    public boolean acceptsEnergyFrom(any emitter, Direction direction) {
        if (this.engine != null) {
            return this.engine.acceptsEnergyFrom(emitter, direction);
        }
        return false;
    }

    @Override
    public boolean isAddedToEnergyNet() {
        if (this.engine != null) {
            return this.engine.isAddedToEnergyNet();
        }
        return false;
    }

    @Override
    public int demandsEnergy() {
        if (this.engine != null) {
            return this.engine.demandsEnergy();
        }
        return 0;
    }

    @Override
    public int getMaxSafeInput() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        if (this.engine != null) {
            return this.engine.injectEnergy(directionFrom, amount);
        }
        return 0;
    }

    @Override
    public LinkedList getCustomTriggers() {
        if (this.engine != null) {
            return this.engine.getCustomTriggers();
        }
        return null;
    }

    @Override
    public int getSocketCount() {
        if (this.engine != null) {
            return this.engine.getSocketCount();
        }
        return 0;
    }

    @Override
    public ur getSocket(int slot) {
        if (this.engine != null) {
            return this.engine.getSocket(slot);
        }
        return null;
    }

    @Override
    public void setSocket(int slot, ur stack) {
        if (this.engine != null) {
            this.engine.setSocket(slot, stack);
        }
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (this.engine == null) {
            return 0;
        }
        if (from == this.getOrientation()) {
            return 0;
        }
        return this.engine.fill(from, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        if (this.engine == null) {
            return 0;
        }
        return this.engine.fill(tankIndex, resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.engine == null) {
            return null;
        }
        if (from == this.getOrientation()) {
            return null;
        }
        return this.engine.drain(from, maxDrain, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        if (this.engine == null) {
            return null;
        }
        return this.engine.drain(tankIndex, maxDrain, doDrain);
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        if (this.engine != null) {
            return this.engine.getTanks(direction);
        }
        return new LiquidTank[0];
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        if (this.engine != null) {
            return this.engine.getTank(direction, type);
        }
        return null;
    }
}

