/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.PowerFramework;
import cpw.mods.fml.common.FMLLog;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.core.gadgets.Gadget;
import forestry.core.gadgets.GadgetManager;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.MachinePackage;
import forestry.core.gadgets.TileForestry;
import forestry.core.interfaces.IClimatised;
import forestry.core.interfaces.IEnergyConsumer;
import forestry.core.interfaces.ILinkedEntity;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.interfaces.IParticularInventory;
import forestry.core.network.IndexInPayload;
import forestry.core.network.PacketPayload;
import forestry.core.proxy.Proxies;
import forestry.core.utils.EnumAccess;
import forestry.core.utils.EnumTankLevel;
import forestry.plugins.PluginBuildCraft;
import ic2.api.Direction;
import ic2.api.energy.tile.IEnergySource;
import java.util.LinkedList;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;

public class TileMachine
extends TileForestry
implements ILiquidTankContainer,
ISidedInventory,
IParticularInventory,
IEnergyConsumer,
IEnergySource,
ILinkedEntity,
IClimatised {
    public Machine machine;
    private IPowerProvider powerProvider = PowerFramework.currentFramework.createPowerProvider();

    public TileMachine() {
        this.powerProvider.configure(1000, 5, 40, 75, 500);
    }

    protected MachinePackage getPackage(int meta) {
        return GadgetManager.getMachinePackage(meta);
    }

    @Override
    public Gadget getMachine() {
        return this.machine;
    }

    @Override
    public boolean throwsErrors() {
        if (this.machine != null) {
            return this.machine.throwsErrors();
        }
        return false;
    }

    @Override
    public boolean hasHints() {
        if (this.machine != null) {
            return this.machine.hasHints();
        }
        return false;
    }

    @Override
    public String[] getHints() {
        if (this.machine != null) {
            return this.machine.getHints();
        }
        return null;
    }

    @Override
    public boolean isClimatized() {
        if (this.machine != null) {
            return this.machine.isClimatized();
        }
        return false;
    }

    @Override
    public EnumTemperature getTemperature() {
        if (this.machine != null) {
            return this.machine.getTemperature();
        }
        return EnumTemperature.NORMAL;
    }

    @Override
    public EnumHumidity getHumidity() {
        if (this.machine != null) {
            return this.machine.getHumidity();
        }
        return EnumHumidity.NORMAL;
    }

    @Override
    public boolean isOwnable() {
        return true;
    }

    protected boolean hasPackage(int meta) {
        return GadgetManager.hasMachinePackage(meta);
    }

    protected void createMachine() {
        int meta = this.k.h(this.l, this.m, this.n);
        if (!this.hasPackage(meta)) {
            FMLLog.info((String)("Encountered a " + this.getClass() + " with meta " + meta + ". However no such MachinePackage exists. Falling back to meta=0."), (Object[])new Object[0]);
            meta = 0;
        }
        this.pack = this.getPackage(meta);
        MachinePackage packMachine = (MachinePackage)this.pack;
        PluginBuildCraft.instance.configurePowerProvider(this.powerProvider, packMachine.energyConfig);
        MachineFactory factory = packMachine.factory;
        if (factory == null) {
            throw new RuntimeException("Missing MachineFactory for " + this.getClass() + " and meta " + meta);
        }
        this.machine = factory.createMachine(this);
        this.k.h(this.l, this.m, this.n, meta);
    }

    @Override
    public void initialize() {
        if (!Proxies.common.isSimulating(this.k)) {
            return;
        }
        if (this.machine == null) {
            this.createMachine();
        }
    }

    @Override
    public void g() {
        super.g();
        if (this.machine != null) {
            if (!Proxies.common.isSimulating(this.k)) {
                this.machine.updateClientSide();
            } else {
                this.machine.updateServerSide();
            }
        }
    }

    @Override
    public void onRemoval() {
        if (this.machine != null) {
            this.machine.onRemoval();
        }
    }

    @Override
    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        PowerFramework.currentFramework.loadPowerProvider(this, nbttagcompound);
        int kind = nbttagcompound.e("Kind");
        this.pack = this.getPackage(kind);
        if (this.pack == null) {
            this.pack = this.getPackage(0);
        }
        this.machine = ((MachinePackage)this.pack).factory.createMachine(this);
        if (nbttagcompound.b("Machine")) {
            this.machine.readFromNBT(nbttagcompound.l("Machine"));
        }
        if (nbttagcompound.b("Boiler")) {
            this.machine.readFromNBT(nbttagcompound.l("Boiler"));
        }
    }

    @Override
    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        PowerFramework.currentFramework.savePowerProvider(this, nbttagcompound);
        int kind = this.k.h(this.l, this.m, this.n);
        if (this.hasPackage(kind)) {
            nbttagcompound.a("Kind", kind);
        } else {
            nbttagcompound.a("Kind", 0);
        }
        if (this.machine != null) {
            bq NBTmachine = new bq();
            this.machine.writeToNBT(NBTmachine);
            nbttagcompound.a("Machine", (cd)NBTmachine);
        } else {
            FMLLog.warning((String)("Saved a " + this.getClass() + " without machine."), (Object[])new Object[0]);
        }
    }

    public boolean isWorking() {
        if (this.machine != null) {
            return this.machine.isWorking();
        }
        return false;
    }

    public int getChargeReceivedScaled(int i) {
        return this.energyReceived * i / this.powerProvider.getMaxEnergyReceived();
    }

    public static EnumTankLevel rateTankLevel(int scaled) {
        if (scaled < 5) {
            return EnumTankLevel.EMPTY;
        }
        if (scaled < 30) {
            return EnumTankLevel.LOW;
        }
        if (scaled < 60) {
            return EnumTankLevel.MEDIUM;
        }
        if (scaled < 90) {
            return EnumTankLevel.HIGH;
        }
        return EnumTankLevel.MAXIMUM;
    }

    public boolean isIndirectlyPoweringTo(ym world, int i, int j, int k, int l) {
        if (this.machine != null) {
            return this.machine.isIndirectlyPoweringTo(world, i, j, k, l);
        }
        return false;
    }

    public boolean isPoweringTo(ym iblockaccess, int i, int j, int k, int l) {
        if (this.machine != null) {
            return this.machine.isPoweringTo(iblockaccess, i, j, k, l);
        }
        return false;
    }

    @Override
    public void doWork() {
        if (!Proxies.common.isSimulating(this.k)) {
            return;
        }
        if (this.k.G() % 5L * 10L != 0L) {
            return;
        }
        PluginBuildCraft.instance.invokeUseEnergyMethod(this.powerProvider, this.powerProvider.getActivationEnergy(), this.powerProvider.getActivationEnergy(), false);
        if (!this.machine.doWork()) {
            return;
        }
        PluginBuildCraft.instance.invokeUseEnergyMethod(this.powerProvider, this.powerProvider.getActivationEnergy(), this.powerProvider.getActivationEnergy(), true);
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public int powerRequest() {
        if (this.isWorking()) {
            return Math.min(this.getPowerProvider().getMaxEnergyReceived(), this.getPowerProvider().getActivationEnergy() / 5 + 1);
        }
        return 0;
    }

    public int k_() {
        if (this.machine != null) {
            return this.machine.k_();
        }
        return 0;
    }

    public ur a(int i) {
        if (this.machine != null) {
            return this.machine.a(i);
        }
        return null;
    }

    public ur a(int i, int j) {
        if (this.machine != null) {
            return this.machine.a(i, j);
        }
        return null;
    }

    public void a(int i, ur itemstack) {
        if (this.machine != null) {
            this.machine.a(i, itemstack);
        }
    }

    public String b() {
        if (this.machine != null) {
            return this.machine.getName();
        }
        return "[Unknown]";
    }

    public int c() {
        if (this.machine != null) {
            return this.machine.c();
        }
        return 64;
    }

    @Override
    public void l_() {
    }

    @Override
    public void f() {
    }

    public ur a_(int slot) {
        if (this.machine != null) {
            return this.machine.a_(slot);
        }
        return null;
    }

    public int getStartInventorySide(ForgeDirection side) {
        if (this.getAccess() == EnumAccess.PRIVATE) {
            return 0;
        }
        if (this.machine != null) {
            return this.machine.getStartInventorySide(side.ordinal());
        }
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        if (this.getAccess() == EnumAccess.PRIVATE) {
            return 0;
        }
        if (this.machine != null) {
            return this.machine.getSizeInventorySide(side.ordinal());
        }
        return 0;
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        if (this.getAccess() == EnumAccess.PRIVATE) {
            return 0;
        }
        if (this.machine != null) {
            return this.machine.addItem(stack, doAdd, from);
        }
        return 0;
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        if (this.getAccess() == EnumAccess.PRIVATE) {
            return new ur[0];
        }
        if (this.machine != null) {
            return this.machine.extractItem(doRemove, from, maxItemCount);
        }
        return new ur[0];
    }

    @Override
    public PacketPayload getPacketPayload() {
        PacketPayload payload = null;
        if (this.machine != null) {
            payload = this.machine.getPacketPayload();
        }
        return payload;
    }

    @Override
    public void fromPacketPayload(PacketPayload payload) {
        if (this.machine == null) {
            this.createMachine();
        }
        this.machine.fromPacketPayload(payload, new IndexInPayload(0, 0, 0));
    }

    public void onNeighborBlockChange() {
        if (this.machine == null) {
            return;
        }
        this.machine.onNeighborBlockChange();
    }

    @Override
    public boolean emitsEnergyTo(any receiver, Direction direction) {
        if (this.machine != null) {
            return this.machine.emitsEnergyTo(receiver, direction);
        }
        return false;
    }

    @Override
    public boolean isAddedToEnergyNet() {
        if (this.machine != null) {
            return this.machine.isAddedToEnergyNet();
        }
        return false;
    }

    @Override
    public int getMaxEnergyOutput() {
        if (this.machine != null) {
            return this.machine.getMaxEnergyOutput();
        }
        return 0;
    }

    @Override
    public LinkedList getCustomTriggers() {
        if (this.machine != null) {
            return this.machine.getCustomTriggers();
        }
        return null;
    }

    @Override
    public void performAction(any entity) {
        if (this.machine != null) {
            this.machine.performAction(entity);
        }
    }

    @Override
    public boolean consumesEnergy() {
        return this.powerProvider.getMaxEnergyReceived() > 0;
    }

    @Override
    public float getMaxEnergyStored() {
        return this.powerProvider.getMaxEnergyStored();
    }

    @Override
    public float getEnergyStored() {
        return this.powerProvider.getEnergyStored();
    }

    @Override
    public float getMaxEnergyReceived() {
        return this.powerProvider.getMaxEnergyReceived();
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (this.machine == null) {
            return 0;
        }
        return this.machine.fill(from, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        if (this.machine == null) {
            return 0;
        }
        return this.machine.fill(tankIndex, resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.machine == null) {
            return null;
        }
        return this.machine.drain(from, maxDrain, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        if (this.machine == null) {
            return null;
        }
        return this.machine.drain(tankIndex, maxDrain, doDrain);
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        if (this.machine != null) {
            return this.machine.getTanks(direction);
        }
        return new LiquidTank[0];
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        if (this.machine != null) {
            return this.machine.getTank(direction, type);
        }
        return null;
    }
}

