/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.ILegacyHandler;
import forestry.core.genetics.AlleleArea;
import forestry.core.genetics.AlleleBoolean;
import forestry.core.genetics.AlleleFloat;
import forestry.core.genetics.AlleleInteger;
import forestry.core.genetics.AllelePlantType;
import forestry.core.genetics.AlleleSpecies;
import forestry.core.genetics.AlleleTolerance;
import forestry.core.utils.Vect;
import java.util.EnumSet;
import net.minecraftforge.common.EnumPlantType;

public class Allele
implements IAllele {
    String uid;
    boolean isDominant;
    public static AlleleSpecies speciesForest;
    public static AlleleSpecies speciesMeadows;
    public static AlleleSpecies speciesCommon;
    public static AlleleSpecies speciesCultivated;
    public static AlleleSpecies speciesNoble;
    public static AlleleSpecies speciesMajestic;
    public static AlleleSpecies speciesImperial;
    public static AlleleSpecies speciesDiligent;
    public static AlleleSpecies speciesUnweary;
    public static AlleleSpecies speciesIndustrious;
    public static AlleleSpecies speciesSteadfast;
    public static AlleleSpecies speciesValiant;
    public static AlleleSpecies speciesHeroic;
    public static AlleleSpecies speciesSinister;
    public static AlleleSpecies speciesFiendish;
    public static AlleleSpecies speciesDemonic;
    public static AlleleSpecies speciesModest;
    public static AlleleSpecies speciesFrugal;
    public static AlleleSpecies speciesAustere;
    public static AlleleSpecies speciesTropical;
    public static AlleleSpecies speciesExotic;
    public static AlleleSpecies speciesEdenic;
    public static AlleleSpecies speciesEnded;
    public static AlleleSpecies speciesWintry;
    public static AlleleSpecies speciesIcy;
    public static AlleleSpecies speciesGlacial;
    public static AlleleSpecies speciesVindictive;
    public static AlleleSpecies speciesVengeful;
    public static AlleleSpecies speciesAvenging;
    public static AlleleSpecies speciesDarkened;
    public static AlleleSpecies speciesReddened;
    public static AlleleSpecies speciesOmega;
    public static AlleleSpecies speciesLeporine;
    public static AlleleSpecies speciesMerry;
    public static AlleleSpecies speciesTipsy;
    public static AlleleSpecies speciesRural;
    public static AlleleSpecies speciesMarshy;
    public static AlleleSpecies treeOak;
    public static AlleleSpecies treeBirch;
    public static AlleleSpecies treeSpruce;
    public static AlleleSpecies treePine;
    public static AlleleSpecies treeJungle;
    public static AlleleSpecies treeLarch;
    public static AlleleSpecies treeTeak;
    public static AlleleSpecies treeAcacia;
    public static AlleleSpecies treeLime;
    public static AlleleSpecies treeChestnut;
    public static AlleleSpecies treeWenge;
    public static AlleleSpecies treeBaobab;
    public static AlleleSpecies treeSequioa;
    public static AlleleSpecies treeKapok;
    public static AlleleSpecies treeEbony;
    public static AlleleSpecies treeMahogony;
    public static AlleleSpecies treeBalsa;
    public static AlleleSpecies treePalm;
    public static AlleleSpecies treeWalnut;
    public static AlleleSpecies treeBoojum;
    public static AlleleSpecies treeCherry;
    public static Allele boolFalse;
    public static Allele boolTrue;
    public static Allele speedSlowest;
    public static Allele speedSlower;
    public static Allele speedSlow;
    public static Allele speedNorm;
    public static Allele speedFast;
    public static Allele speedFaster;
    public static Allele speedFastest;
    public static Allele lifespanShortest;
    public static Allele lifespanShorter;
    public static Allele lifespanShort;
    public static Allele lifespanShortened;
    public static Allele lifespanNormal;
    public static Allele lifespanElongated;
    public static Allele lifespanLong;
    public static Allele lifespanLonger;
    public static Allele lifespanLongest;
    public static Allele fertilityLow;
    public static Allele fertilityNormal;
    public static Allele fertilityHigh;
    public static Allele fertilityMaximum;
    public static Allele growthLightlevel;
    public static Allele growthAcacia;
    public static Allele fruitNone;
    public static Allele fruitApple;
    public static Allele fruitLarch;
    public static Allele fruitTeak;
    public static Allele fruitAcacia;
    public static Allele fruitLime;
    public static Allele fruitChestnut;
    public static Allele fruitWenge;
    public static Allele fruitBaobab;
    public static Allele fruitSequoia;
    public static Allele fruitKapok;
    public static Allele fruitEbony;
    public static Allele fruitMahogany;
    public static Allele fruitBalsa;
    public static Allele fruitPalm;
    public static Allele fruitWalnut;
    public static Allele fruitBoojum;
    public static Allele fruitCherry;
    public static Allele heightSmallest;
    public static Allele heightSmaller;
    public static Allele heightSmall;
    public static Allele heightAverage;
    public static Allele heightLarge;
    public static Allele heightLarger;
    public static Allele heightLargest;
    public static Allele heightGigantic;
    public static Allele toleranceNone;
    public static Allele toleranceBoth1;
    public static Allele toleranceBoth2;
    public static Allele toleranceBoth3;
    public static Allele toleranceBoth4;
    public static Allele toleranceBoth5;
    public static Allele toleranceUp1;
    public static Allele toleranceUp2;
    public static Allele toleranceUp3;
    public static Allele toleranceUp4;
    public static Allele toleranceUp5;
    public static Allele toleranceDown1;
    public static Allele toleranceDown2;
    public static Allele toleranceDown3;
    public static Allele toleranceDown4;
    public static Allele toleranceDown5;
    public static Allele flowersVanilla;
    public static Allele flowersNether;
    public static Allele flowersCacti;
    public static Allele flowersMushrooms;
    public static Allele flowersEnd;
    public static Allele flowersJungle;
    public static Allele flowersSnow;
    public static Allele flowersWheat;
    public static Allele saplingsDefault;
    public static Allele saplingsDouble;
    public static Allele saplingsTriple;
    public static Allele yieldLower;
    public static Allele floweringSlowest;
    public static Allele floweringSlower;
    public static Allele floweringSlow;
    public static Allele floweringMaximum;
    public static Allele territoryDefault;
    public static Allele territoryLarge;
    public static Allele territoryLarger;
    public static Allele territoryLargest;
    public static Allele effectNone;
    public static Allele effectAggressive;
    public static Allele effectHeroic;
    public static Allele effectBeatific;
    public static Allele effectMiasmic;
    public static Allele effectMisanthrope;
    public static Allele effectGlacial;
    public static Allele effectRadioactive;
    public static Allele effectCreeper;
    public static Allele effectIgnition;
    public static Allele effectExploration;
    public static Allele effectFestiveEaster;
    public static Allele effectSnowing;
    public static Allele effectDrunkard;
    public static Allele leavesNone;
    public static Allele plantTypeNone;
    public static Allele plantTypePlains;
    public static Allele plantTypeDesert;
    public static Allele plantTypeBeach;
    public static Allele plantTypeCave;
    public static Allele plantTypeWater;
    public static Allele plantTypeNether;
    public static Allele plantTypeCrop;

    public Allele(String uid, boolean isDominant) {
        this(uid, isDominant, false);
    }

    protected Allele(String uid, boolean isDominant, boolean skipRegister) {
        this.uid = uid;
        this.isDominant = isDominant;
        if (!skipRegister) {
            AlleleManager.alleleRegistry.registerAllele(this);
        }
    }

    @Override
    public String getUID() {
        return "forestry." + this.uid;
    }

    @Override
    public boolean isDominant() {
        return this.isDominant;
    }

    public static void initialize() {
        boolFalse = new AlleleBoolean("boolFalse", false);
        boolTrue = new AlleleBoolean("boolTrue", true);
        speedSlowest = new AlleleFloat("speedSlowest", 0.3f, true);
        speedSlower = new AlleleFloat("speedSlower", 0.6f, true);
        speedSlow = new AlleleFloat("speedSlow", 0.8f, true);
        speedNorm = new AlleleFloat("speedNorm", 1.0f);
        speedFast = new AlleleFloat("speedFast", 1.2f, true);
        speedFaster = new AlleleFloat("speedFaster", 1.4f);
        speedFastest = new AlleleFloat("speedFastest", 1.7f);
        lifespanShortest = new AlleleInteger("lifespanShortest", 10, false);
        lifespanShorter = new AlleleInteger("lifespanShorter", 20, true);
        lifespanShort = new AlleleInteger("lifespanShort", 30, true);
        lifespanShortened = new AlleleInteger("lifespanShortened", 35, true);
        lifespanNormal = new AlleleInteger("lifespanNormal", 40);
        lifespanElongated = new AlleleInteger("lifespanElongated", 45, true);
        lifespanLong = new AlleleInteger("lifespanLong", 50);
        lifespanLonger = new AlleleInteger("lifespanLonger", 60);
        lifespanLongest = new AlleleInteger("lifespanLongest", 70);
        fertilityLow = new AlleleInteger("fertilityLow", 1, true);
        fertilityNormal = new AlleleInteger("fertilityNormal", 2, true);
        fertilityHigh = new AlleleInteger("fertilityHigh", 3);
        fertilityMaximum = new AlleleInteger("fertilityMaximum", 4);
        heightSmallest = new AlleleFloat("heightSmallest", 0.25f);
        heightSmaller = new AlleleFloat("heightSmaller", 0.5f);
        heightSmall = new AlleleFloat("heightSmall", 0.75f);
        heightAverage = new AlleleFloat("heightMax10", 1.0f);
        heightLarge = new AlleleFloat("heightLarge", 1.25f);
        heightLarger = new AlleleFloat("heightLarger", 1.5f);
        heightLargest = new AlleleFloat("heightLargest", 1.75f);
        heightGigantic = new AlleleFloat("heightGigantic", 2.0f);
        toleranceNone = new AlleleTolerance("toleranceNone", EnumTolerance.NONE);
        toleranceBoth1 = new AlleleTolerance("toleranceBoth1", EnumTolerance.BOTH_1, true);
        toleranceBoth2 = new AlleleTolerance("toleranceBoth2", EnumTolerance.BOTH_2);
        toleranceBoth3 = new AlleleTolerance("toleranceBoth3", EnumTolerance.BOTH_3);
        toleranceBoth4 = new AlleleTolerance("toleranceBoth4", EnumTolerance.BOTH_4);
        toleranceBoth5 = new AlleleTolerance("toleranceBoth5", EnumTolerance.BOTH_5);
        toleranceUp1 = new AlleleTolerance("toleranceUp1", EnumTolerance.UP_1, true);
        toleranceUp2 = new AlleleTolerance("toleranceUp2", EnumTolerance.UP_2);
        toleranceUp3 = new AlleleTolerance("toleranceUp3", EnumTolerance.UP_3);
        toleranceUp4 = new AlleleTolerance("toleranceUp4", EnumTolerance.UP_4);
        toleranceUp5 = new AlleleTolerance("toleranceUp5", EnumTolerance.UP_5);
        toleranceDown1 = new AlleleTolerance("toleranceDown1", EnumTolerance.DOWN_1, true);
        toleranceDown2 = new AlleleTolerance("toleranceDown2", EnumTolerance.DOWN_2);
        toleranceDown3 = new AlleleTolerance("toleranceDown3", EnumTolerance.DOWN_3);
        toleranceDown4 = new AlleleTolerance("toleranceDown4", EnumTolerance.DOWN_4);
        toleranceDown5 = new AlleleTolerance("toleranceDown5", EnumTolerance.DOWN_5);
        saplingsDefault = new AlleleFloat("saplingsDefault", 0.1f, true);
        saplingsDouble = new AlleleFloat("saplingsDouble", 0.2f, true);
        saplingsTriple = new AlleleFloat("saplingsTriple", 0.3f, true);
        yieldLower = new AlleleFloat("yieldDefault", 0.1f, true);
        floweringSlowest = new AlleleInteger("floweringSlowest", 10, true);
        floweringSlower = new AlleleInteger("floweringSlower", 20);
        floweringSlow = new AlleleInteger("floweringSlow", 30);
        floweringMaximum = new AlleleInteger("floweringMaximum", 99, true);
        territoryDefault = new AlleleArea("territoryDefault", new Vect(9, 3, 9));
        territoryLarge = new AlleleArea("territoryLarge", new Vect(11, 5, 11));
        territoryLarger = new AlleleArea("territoryLarger", new Vect(13, 7, 13));
        territoryLargest = new AlleleArea("territoryLargest", new Vect(15, 9, 15));
        plantTypeNone = new AllelePlantType("plantTypeNone", EnumSet.noneOf(EnumPlantType.class), true);
        plantTypePlains = new AllelePlantType("plantTypePlains", EnumPlantType.Plains);
        plantTypeDesert = new AllelePlantType("plantTypeDesert", EnumPlantType.Desert);
        plantTypeBeach = new AllelePlantType("plantTypeBeach", EnumPlantType.Beach);
        plantTypeCave = new AllelePlantType("plantTypeCave", EnumPlantType.Cave);
        plantTypeWater = new AllelePlantType("plantTypeWater", EnumPlantType.Water);
        plantTypeNether = new AllelePlantType("plantTypeNether", EnumPlantType.Nether);
        plantTypeCrop = new AllelePlantType("plantTypeCrop", EnumPlantType.Crop);
        ILegacyHandler legacy = (ILegacyHandler)((Object)AlleleManager.alleleRegistry);
        legacy.registerLegacyMapping(0, "forestry.speciesForest");
        legacy.registerLegacyMapping(1, "forestry.speciesMeadows");
        legacy.registerLegacyMapping(2, "forestry.speciesCommon");
        legacy.registerLegacyMapping(3, "forestry.speciesCultivated");
        legacy.registerLegacyMapping(4, "forestry.speciesNoble");
        legacy.registerLegacyMapping(5, "forestry.speciesMajestic");
        legacy.registerLegacyMapping(6, "forestry.speciesImperial");
        legacy.registerLegacyMapping(7, "forestry.speciesDiligent");
        legacy.registerLegacyMapping(8, "forestry.speciesUnweary");
        legacy.registerLegacyMapping(9, "forestry.speciesIndustrious");
        legacy.registerLegacyMapping(10, "forestry.speciesSteadfast");
        legacy.registerLegacyMapping(11, "forestry.speciesValiant");
        legacy.registerLegacyMapping(12, "forestry.speciesHeroic");
        legacy.registerLegacyMapping(13, "forestry.speciesSinister");
        legacy.registerLegacyMapping(14, "forestry.speciesFiendish");
        legacy.registerLegacyMapping(15, "forestry.speciesDemonic");
        legacy.registerLegacyMapping(16, "forestry.speciesModest");
        legacy.registerLegacyMapping(17, "forestry.speciesFrugal");
        legacy.registerLegacyMapping(18, "forestry.speciesAustere");
        legacy.registerLegacyMapping(19, "forestry.speciesTropical");
        legacy.registerLegacyMapping(20, "forestry.speciesExotic");
        legacy.registerLegacyMapping(21, "forestry.speciesEdenic");
        legacy.registerLegacyMapping(22, "forestry.speciesEnded");
        legacy.registerLegacyMapping(25, "forestry.speciesWintry");
        legacy.registerLegacyMapping(28, "forestry.speciesVindictive");
        legacy.registerLegacyMapping(29, "forestry.speciesVengeful");
        legacy.registerLegacyMapping(30, "forestry.speciesAvenging");
        legacy.registerLegacyMapping(32, "forestry.speciesDarkened");
        legacy.registerLegacyMapping(31, "forestry.speciesReddened");
        legacy.registerLegacyMapping(33, "forestry.speciesOmega");
        legacy.registerLegacyMapping(34, "forestry.speciesLeporine");
        legacy.registerLegacyMapping(40, "forestry.speciesRural");
        legacy.registerLegacyMapping(43, "forestry.speciesMarshy");
        legacy.registerLegacyMapping(1500, "forestry.flowersVanilla");
        legacy.registerLegacyMapping(1501, "forestry.flowersNether");
        legacy.registerLegacyMapping(1502, "forestry.flowersCacti");
        legacy.registerLegacyMapping(1503, "forestry.flowersMushrooms");
        legacy.registerLegacyMapping(1504, "forestry.flowersEnd");
        legacy.registerLegacyMapping(1505, "forestry.flowersJungle");
        legacy.registerLegacyMapping(1506, "forestry.flowersSnow");
        legacy.registerLegacyMapping(1507, "forestry.flowersWheat");
        legacy.registerLegacyMapping(1800, "forestry.effectNone");
        legacy.registerLegacyMapping(1801, "forestry.effectAggressive");
        legacy.registerLegacyMapping(1802, "forestry.effectHeroic");
        legacy.registerLegacyMapping(1803, "forestry.effectBeatific");
        legacy.registerLegacyMapping(1804, "forestry.effectMiasmic");
        legacy.registerLegacyMapping(1805, "forestry.effectMisanthrope");
        legacy.registerLegacyMapping(1806, "forestry.effectGlacial");
        legacy.registerLegacyMapping(1807, "forestry.effectRadioactive");
        legacy.registerLegacyMapping(1808, "forestry.effectCreeper");
        legacy.registerLegacyMapping(1809, "forestry.effectIgnition");
        legacy.registerLegacyMapping(1810, "forestry.effectExploration");
        legacy.registerLegacyMapping(1811, "forestry.effectFestiveEaster");
        legacy.registerLegacyMapping(1024, "forestry.boolFalse");
        legacy.registerLegacyMapping(1025, "forestry.boolTrue");
        legacy.registerLegacyMapping(1100, "forestry.speedSlowest");
        legacy.registerLegacyMapping(1101, "forestry.speedSlower");
        legacy.registerLegacyMapping(1102, "forestry.speedSlow");
        legacy.registerLegacyMapping(1103, "forestry.speedNorm");
        legacy.registerLegacyMapping(1104, "forestry.speedFast");
        legacy.registerLegacyMapping(1105, "forestry.speedFaster");
        legacy.registerLegacyMapping(1106, "forestry.speedFastest");
        legacy.registerLegacyMapping(1200, "forestry.lifespanShortest");
        legacy.registerLegacyMapping(1201, "forestry.lifespanShorter");
        legacy.registerLegacyMapping(1202, "forestry.lifespanShort");
        legacy.registerLegacyMapping(1203, "forestry.lifespanShortened");
        legacy.registerLegacyMapping(1204, "forestry.lifespanNormal");
        legacy.registerLegacyMapping(1205, "forestry.lifespanElongated");
        legacy.registerLegacyMapping(1206, "forestry.lifespanLong");
        legacy.registerLegacyMapping(1207, "forestry.lifespanLonger");
        legacy.registerLegacyMapping(1208, "forestry.lifespanLongest");
        legacy.registerLegacyMapping(1300, "forestry.fertilityLow");
        legacy.registerLegacyMapping(1301, "forestry.fertilityNormal");
        legacy.registerLegacyMapping(1302, "forestry.fertilityHigh");
        legacy.registerLegacyMapping(1303, "forestry.fertilityMaximum");
        legacy.registerLegacyMapping(1450, "forestry.toleranceNone");
        legacy.registerLegacyMapping(1451, "forestry.toleranceBoth1");
        legacy.registerLegacyMapping(1452, "forestry.toleranceBoth2");
        legacy.registerLegacyMapping(1453, "forestry.toleranceBoth3");
        legacy.registerLegacyMapping(1454, "forestry.toleranceBoth4");
        legacy.registerLegacyMapping(1455, "forestry.toleranceBoth5");
        legacy.registerLegacyMapping(1456, "forestry.toleranceUp1");
        legacy.registerLegacyMapping(1457, "forestry.toleranceUp2");
        legacy.registerLegacyMapping(1458, "forestry.toleranceUp3");
        legacy.registerLegacyMapping(1459, "forestry.toleranceUp4");
        legacy.registerLegacyMapping(1460, "forestry.toleranceUp5");
        legacy.registerLegacyMapping(1461, "forestry.toleranceDown1");
        legacy.registerLegacyMapping(1462, "forestry.toleranceDown2");
        legacy.registerLegacyMapping(1463, "forestry.toleranceDown3");
        legacy.registerLegacyMapping(1464, "forestry.toleranceDown4");
        legacy.registerLegacyMapping(1465, "forestry.toleranceDown5");
        legacy.registerLegacyMapping(1700, "forestry.floweringSlowest");
        legacy.registerLegacyMapping(1701, "forestry.floweringSlower");
        legacy.registerLegacyMapping(1702, "forestry.floweringSlow");
        legacy.registerLegacyMapping(1710, "forestry.floweringMaximum");
        legacy.registerLegacyMapping(1750, "forestry.territoryDefault");
        legacy.registerLegacyMapping(1751, "forestry.territoryLarge");
        legacy.registerLegacyMapping(1752, "forestry.territoryLarger");
        legacy.registerLegacyMapping(1753, "forestry.territoryLargest");
    }
}

