/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleHandler;
import forestry.api.genetics.IAlleleRegistry;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBranch;
import forestry.api.genetics.ILegacyHandler;
import forestry.core.utils.IDAllocator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class AlleleRegistry
implements IAlleleRegistry,
ILegacyHandler {
    public static final int ALLELE_ARRAY_SIZE = 2048;
    private LinkedHashMap alleleMap = new LinkedHashMap(2048);
    private LinkedHashMap branchMap = new LinkedHashMap(128);
    private HashMap metaMapToUID = new HashMap();
    private HashMap uidMapToMeta = new HashMap();
    private HashMap legacyMap = new HashMap();
    private HashSet alleleHandlers = new HashSet();

    @Override
    public LinkedHashMap getRegisteredAlleles() {
        return this.alleleMap;
    }

    @Override
    public LinkedHashMap getRegisteredBranches() {
        return this.branchMap;
    }

    @Override
    public void registerAllele(IAllele allele) {
        IBranch branch;
        this.alleleMap.put(allele.getUID(), allele);
        if (allele instanceof IAlleleSpecies && (branch = ((IAlleleSpecies)allele).getBranch()) != null) {
            branch.addMember((IAlleleSpecies)allele);
        }
        for (IAlleleHandler handler : this.alleleHandlers) {
            handler.onRegisterAllele(allele);
        }
    }

    @Override
    public IAllele getAllele(String uid) {
        return (IAllele)this.alleleMap.get(uid);
    }

    @Override
    public void reloadMetaMap(yc world) {
        this.metaMapToUID.clear();
        this.uidMapToMeta.clear();
        for (Map.Entry entry : this.alleleMap.entrySet()) {
            if (!(entry.getValue() instanceof IAlleleSpecies)) continue;
            int meta = IDAllocator.getIDAllocator(world, "speciesMetaMap").getId((String)entry.getKey());
            this.metaMapToUID.put(meta, entry.getKey());
            this.uidMapToMeta.put(entry.getKey(), meta);
        }
    }

    @Override
    public IAllele getFromMetaMap(int meta) {
        if (!this.metaMapToUID.containsKey(meta)) {
            return null;
        }
        return this.getAllele((String)this.metaMapToUID.get(meta));
    }

    @Override
    public int getFromUIDMap(String uid) {
        if (!this.uidMapToMeta.containsKey(uid)) {
            return 0;
        }
        return (Integer)this.uidMapToMeta.get(uid);
    }

    @Override
    public void registerBranch(IBranch branch) {
        this.branchMap.put(branch.getUID(), branch);
        for (IAlleleHandler handler : this.alleleHandlers) {
            handler.onRegisterBranch(branch);
        }
    }

    @Override
    public IBranch getBranch(String uid) {
        return (IBranch)this.branchMap.get(uid);
    }

    @Override
    public void registerLegacyMapping(int id, String uid) {
        this.legacyMap.put(id, uid);
    }

    @Override
    public IAllele getFromLegacyMap(int id) {
        if (!this.legacyMap.containsKey(id)) {
            return null;
        }
        return this.getAllele((String)this.legacyMap.get(id));
    }

    @Override
    public void registerAlleleHandler(IAlleleHandler handler) {
        this.alleleHandlers.add(handler);
    }
}

