/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBranch;
import forestry.core.utils.StringUtil;
import java.util.ArrayList;

public class Branch
implements IBranch {
    private String uid;
    private BranchType type = BranchType.BEES;
    private String scientific;
    private ArrayList members = new ArrayList();

    public Branch(String uid, BranchType type, String scientific) {
        this(uid, scientific);
        this.type = type;
    }

    public Branch(String uid, String scientific) {
        this.uid = uid;
        this.scientific = scientific;
        AlleleManager.alleleRegistry.registerBranch(this);
    }

    @Override
    public String getUID() {
        return "forestry." + this.uid;
    }

    @Override
    public String getScientific() {
        return this.scientific;
    }

    @Override
    public String getName() {
        return StringUtil.localize(this.type.toString().toLowerCase() + ".branch." + this.uid);
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public IAlleleSpecies[] getMembers() {
        return this.members.toArray(new IAlleleSpecies[0]);
    }

    @Override
    public void addMember(IAlleleSpecies species) {
        this.members.add(species);
    }

    public static enum BranchType {
        BEES,
        TREES;

    }
}

