/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IGenome;
import forestry.core.config.Config;
import forestry.core.genetics.Chromosome;

public abstract class Genome
implements IGenome {
    private IChromosome[] chromosomes;
    protected IAllele[] defaultTemplate;

    public Genome(IAllele[] defaultTemplate, bq nbttagcompound) {
        this(defaultTemplate);
        this.chromosomes = new Chromosome[defaultTemplate.length];
        this.readFromNBT(nbttagcompound);
    }

    public Genome(IAllele[] defaultTemplate, IChromosome[] chromosomes) {
        this(defaultTemplate);
        this.chromosomes = chromosomes;
    }

    public Genome(IAllele[] defaultTemplate) {
        this.defaultTemplate = defaultTemplate;
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        by nbttaglist = nbttagcompound.m("Chromosomes");
        this.chromosomes = new Chromosome[this.chromosomes.length];
        for (int i = 0; i < nbttaglist.c(); ++i) {
            bq nbttagcompound1 = (bq)nbttaglist.b(i);
            byte byte0 = nbttagcompound1.c("Slot");
            if (byte0 < 0 || byte0 >= this.chromosomes.length) continue;
            Chromosome chromosome = Chromosome.loadChromosomeFromNBT(nbttagcompound1);
            this.chromosomes[byte0] = chromosome;
            if (!Config.clearInvalidChromosomes) continue;
            chromosome.overrideInvalidAlleles(this.defaultTemplate[byte0]);
        }
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        by nbttaglist = new by();
        for (int i = 0; i < this.chromosomes.length; ++i) {
            if (this.chromosomes[i] == null) continue;
            bq nbttagcompound1 = new bq();
            nbttagcompound1.a("Slot", (byte)i);
            this.chromosomes[i].writeToNBT(nbttagcompound1);
            nbttaglist.a((cd)nbttagcompound1);
        }
        nbttagcompound.a("Chromosomes", (cd)nbttaglist);
    }

    @Override
    public IChromosome[] getChromosomes() {
        return this.chromosomes;
    }

    @Override
    public IAllele getActiveAllele(int chromosome) {
        return this.chromosomes[chromosome].getActiveAllele();
    }

    @Override
    public IAllele getInactiveAllele(int chromosome) {
        return this.chromosomes[chromosome].getInactiveAllele();
    }

    @Override
    public boolean isGeneticEqual(IGenome other) {
        IChromosome[] genetics = other.getChromosomes();
        if (this.chromosomes.length != genetics.length) {
            return false;
        }
        for (int i = 0; i < this.chromosomes.length; ++i) {
            IChromosome chromosome = this.chromosomes[i];
            if (chromosome == null && genetics[i] != null) {
                return false;
            }
            if (chromosome != null && genetics[i] == null) {
                return false;
            }
            if (!chromosome.getPrimaryAllele().getUID().equals(genetics[i].getPrimaryAllele().getUID())) {
                return false;
            }
            if (chromosome.getSecondaryAllele().getUID().equals(genetics[i].getSecondaryAllele().getUID())) continue;
            return false;
        }
        return true;
    }
}

