/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import forestry.api.arboriculture.ITree;
import forestry.api.genetics.IIndividual;

public abstract class Individual
implements IIndividual {
    protected boolean isAnalyzed = false;
    protected int generation;
    protected boolean isNatural;
    protected boolean isIrregularMating;

    @Override
    public boolean isAnalyzed() {
        return this.isAnalyzed;
    }

    @Override
    public boolean analyze() {
        if (this.isAnalyzed) {
            return false;
        }
        this.isAnalyzed = true;
        return true;
    }

    @Override
    public IIndividual setNatural(boolean flag) {
        this.isNatural = flag;
        return this;
    }

    @Override
    public boolean isIrregularMating() {
        return this.isIrregularMating;
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        if (nbttagcompound == null) {
            return;
        }
        this.isAnalyzed = nbttagcompound.n("IsAnalyzed");
        this.isNatural = nbttagcompound.b("NA") ? nbttagcompound.n("NA") : true;
        this.isIrregularMating = nbttagcompound.n("IM");
        this.generation = nbttagcompound.e("GEN");
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        nbttagcompound.a("IsAnalyzed", this.isAnalyzed);
        nbttagcompound.a("NA", this.isNatural);
        nbttagcompound.a("IM", this.isIrregularMating);
        nbttagcompound.a("GEN", this.generation);
    }

    @Override
    public boolean isNatural() {
        return this.isNatural;
    }

    @Override
    public int getGeneration() {
        return this.generation;
    }

    @Override
    public boolean hasEffect() {
        return this.getGenome().getPrimary().hasEffect();
    }

    @Override
    public boolean isSecret() {
        return this.getGenome().getPrimary().isSecret();
    }

    @Override
    public boolean isGeneticEqual(IIndividual other) {
        if (!(other instanceof ITree)) {
            return false;
        }
        ITree tree = (ITree)other;
        return this.getGenome().isGeneticEqual(tree.getGenome());
    }
}

