/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.gui.Ledger;
import forestry.core.gui.LedgerManager;
import forestry.core.interfaces.IOwnable;
import forestry.core.network.PacketCoordinates;
import forestry.core.proxy.Proxies;
import forestry.core.utils.EnumAccess;
import forestry.core.utils.StringUtil;

public class OwnerLedger
extends Ledger {
    IOwnable tile;

    public OwnerLedger(LedgerManager manager, IOwnable tile) {
        super(manager);
        this.tile = tile;
    }

    public boolean isAccessButton(int mouseX, int mouseY) {
        int shiftX = this.currentShiftX;
        int shiftY = this.currentShiftY + 44;
        return mouseX >= shiftX && mouseX <= this.currentShiftX + this.currentWidth && mouseY >= shiftY && mouseY <= shiftY + 12;
    }

    public boolean isOwnerChangeButton(int mouseX, int mouseY) {
        return false;
    }

    @Override
    public void draw(int x2, int y2) {
        boolean playerIsOwner = this.tile.isOwner((qx)this.manager.minecraft.g);
        EnumAccess access = this.tile.getAccess();
        this.maxHeight = playerIsOwner ? 60 : 36;
        this.drawBackground(x2, y2);
        this.drawIcon("/gfx/forestry/gui/misc.png", access.getIconIndex(), x2 + 3, y2 + 4);
        if (!this.isFullyOpened()) {
            return;
        }
        this.manager.minecraft.p.a(StringUtil.localize("gui.owner"), x2 + 22, y2 + 8, this.manager.gui.fontColor.get("ledger.owner.header"));
        String owner = this.tile.getOwnerName();
        if (owner == null) {
            owner = StringUtil.localize("gui.derelict");
        }
        this.manager.minecraft.p.b(owner, x2 + 22, y2 + 20, this.manager.gui.fontColor.get("ledger.owner.text"));
        if (!playerIsOwner) {
            return;
        }
        this.manager.minecraft.p.a(StringUtil.localize("gui.access") + ":", x2 + 22, y2 + 32, this.manager.gui.fontColor.get("ledger.owner.subheader"));
        this.drawIcon("/gfx/forestry/gui/misc.png", access.getIconIndex(), x2 + 20, y2 + 40);
        this.manager.minecraft.p.b(StringUtil.localize(access.getName()), x2 + 38, y2 + 44, this.manager.gui.fontColor.get("ledger.owner.text"));
    }

    @Override
    public String getTooltip() {
        if (this.tile.getOwnerName() != null) {
            return StringUtil.localize("gui.owner") + ": " + this.tile.getOwnerName();
        }
        return StringUtil.localize("gui.derelict");
    }

    @Override
    public boolean handleMouseClicked(int x2, int y2, int mouseButton) {
        if (this.isAccessButton(x2, y2)) {
            if (!Proxies.common.isSimulating(((any)this.tile).k)) {
                any te = (any)this.tile;
                Proxies.net.sendToServer(new PacketCoordinates(50, te.l, te.m, te.n));
            }
            this.tile.switchAccessRule((qx)this.manager.minecraft.g);
            return true;
        }
        return false;
    }
}

