/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.gui.GfxSlotManager;
import forestry.core.gui.LiquidTankSlot;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.proxy.Proxies;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import org.lwjgl.opengl.GL11;

public class ReservoirSlot
extends LiquidTankSlot {
    public ReservoirSlot(GfxSlotManager manager, int xPos, int yPos, ILiquidTankContainer tile, int slot) {
        super(manager, xPos, yPos, tile, slot);
        this.height = 16;
    }

    @Override
    public void draw(int startX, int startY) {
        int x2;
        up content = null;
        int liquidImgIndex = 0;
        ILiquidTank tank = this.tile.getTanks(ForgeDirection.UNKNOWN)[this.slot];
        int liquidId = tank.getLiquid().itemID;
        int liquidMeta = tank.getLiquid().itemMeta;
        int squaled = tank.getLiquid().amount * this.height / tank.getCapacity();
        if (squaled > this.height) {
            squaled = this.height;
        }
        if (liquidId <= 0) {
            return;
        }
        if (liquidId < amq.p.length && amq.p[liquidId] != null) {
            content = amq.p[liquidId];
            liquidImgIndex = amq.p[liquidId].cl;
            Proxies.common.bindTexture(((amq)content).getTextureFile());
        } else {
            content = up.e[liquidId];
            liquidImgIndex = up.e[liquidId].b(liquidMeta);
            Proxies.common.bindTexture(content.getTextureFile());
        }
        int imgLine = liquidImgIndex / 16;
        int imgColumn = liquidImgIndex - imgLine * 16;
        int start = 0;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        do {
            x2 = 0;
            if (squaled > 16) {
                x2 = 16;
                squaled -= 16;
            } else {
                x2 = squaled;
                squaled = 0;
            }
            this.manager.gui.b(startX + this.xPos, startY + this.yPos + this.height - x2 - start, imgColumn * 16, imgLine * 16, 16, 16 - (16 - x2));
            start += 16;
        } while (x2 != 0 && squaled != 0);
        int tex = this.manager.minecraft.o.b(this.manager.gui.textureFile);
        this.manager.minecraft.o.b(tex);
    }
}

