/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import buildcraft.api.tools.IToolPipette;
import forestry.api.core.INBTTagable;
import forestry.core.items.ItemForestry;
import forestry.core.proxy.Proxies;
import java.util.List;
import net.minecraftforge.liquids.LiquidStack;

public class ItemPipette
extends ItemForestry
implements IToolPipette {
    public ItemPipette(int i) {
        super(i);
        this.d(1);
        this.a(tj.i);
    }

    public boolean q() {
        return true;
    }

    @Override
    public boolean canPipette(ur itemstack) {
        PipetteContents contained = new PipetteContents(itemstack.p());
        return !contained.isFull(1000);
    }

    @Override
    public int fill(ur itemstack, LiquidStack liquid, boolean doFill) {
        PipetteContents contained = new PipetteContents(itemstack.p());
        int limit = this.getCapacity(itemstack);
        int filled = 0;
        if (contained.contents == null) {
            filled = liquid.amount > limit ? limit : liquid.amount;
            contained.contents = new LiquidStack(liquid.itemID, filled, liquid.itemMeta);
            filled = liquid.amount;
        } else {
            if (contained.contents.amount >= limit) {
                return 0;
            }
            if (!contained.contents.isLiquidEqual(liquid)) {
                return 0;
            }
            int space = limit - contained.contents.amount;
            filled = liquid.amount > space ? space : liquid.amount;
            contained.contents.amount += filled;
        }
        if (doFill) {
            bq nbttagcompound = new bq();
            contained.writeToNBT(nbttagcompound);
            itemstack.d(nbttagcompound);
            itemstack.b(1);
        }
        return filled;
    }

    public void a(ur itemstack, qx player, List list, boolean flag) {
        PipetteContents contained = new PipetteContents(itemstack.p());
        contained.addTooltip(list);
    }

    public int b(int damage) {
        if (damage > 0) {
            return 21;
        }
        return 20;
    }

    @Override
    public LiquidStack drain(ur pipette, int maxDrain, boolean doDrain) {
        PipetteContents contained = new PipetteContents(pipette.p());
        if (contained.contents == null || contained.contents.itemID <= 0) {
            return null;
        }
        int drained = maxDrain;
        if (contained.contents.amount < drained) {
            drained = contained.contents.amount;
        }
        if (doDrain) {
            contained.contents.amount -= drained;
            if (contained.contents.amount <= 0) {
                pipette.d(null);
                pipette.b(0);
            } else {
                bq nbttagcompound = new bq();
                contained.writeToNBT(nbttagcompound);
                pipette.d(nbttagcompound);
            }
        }
        return new LiquidStack(contained.contents.itemID, drained, contained.contents.itemMeta);
    }

    @Override
    public int getCapacity(ur pipette) {
        return 1000;
    }

    class PipetteContents
    implements INBTTagable {
        LiquidStack contents;

        public PipetteContents(bq nbttagcompound) {
            if (nbttagcompound != null) {
                this.readFromNBT(nbttagcompound);
            }
        }

        @Override
        public void readFromNBT(bq nbttagcompound) {
            this.contents = LiquidStack.loadLiquidStackFromNBT((bq)nbttagcompound);
        }

        @Override
        public void writeToNBT(bq nbttagcompound) {
            if (this.contents != null) {
                this.contents.writeToNBT(nbttagcompound);
            }
        }

        public boolean isFull(int limit) {
            if (this.contents == null) {
                return false;
            }
            return this.contents.itemID > 0 && this.contents.amount >= limit;
        }

        public void addTooltip(List list) {
            if (this.contents == null) {
                return;
            }
            if (this.contents.itemID <= 0) {
                return;
            }
            String descr = Proxies.common.getItemDisplayName(up.e[this.contents.itemID]);
            list.add(descr);
        }
    }
}

