/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import buildcraft.core.Version;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.network.ForestryPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;

public class PacketConfig
extends ForestryPacket {
    private String version;
    private ArrayList config;

    public PacketConfig() {
        super(5);
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        this.version = Version.getVersion();
        this.config = this.getConfig();
        data.writeUTF(this.version);
        data.writeInt(this.config.size());
        for (IdConfig conf : this.config) {
            conf.writeData(data);
        }
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        this.config = new ArrayList();
        this.version = data.readUTF();
        int count = data.readInt();
        for (int i = 0; i < count; ++i) {
            byte type = data.readByte();
            String ident = data.readUTF();
            int value = data.readInt();
            this.config.add(new IdConfig(ConfigType.values()[type], ident, value));
        }
    }

    public boolean matches() {
        return true;
    }

    private ArrayList getConfig() {
        ArrayList<IdConfig> configs = new ArrayList<IdConfig>();
        for (Field field : ForestryItem.class.getDeclaredFields()) {
            try {
                if (!(field.get(null) instanceof up)) continue;
                configs.add(new IdConfig(ConfigType.Item, field.getName(), ((up)field.get(null)).cj));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        for (Field field : ForestryBlock.class.getDeclaredFields()) {
            try {
                if (!(field.get(null) instanceof amq)) continue;
                configs.add(new IdConfig(ConfigType.Block, field.getName(), ((amq)field.get(null)).cm));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return configs;
    }

    static class IdConfig {
        final ConfigType type;
        final String ident;
        final int value;

        public IdConfig(ConfigType type, String ident, int value) {
            this.type = type;
            this.ident = ident;
            this.value = value;
        }

        public void writeData(DataOutputStream data) throws IOException {
            data.writeByte(this.type.ordinal());
            data.writeUTF(this.ident);
            data.writeInt(this.value);
        }
    }

    static enum ConfigType {
        Block,
        Item;

    }
}

