/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.network;

import forestry.core.network.ForestryPacket;
import forestry.core.proxy.Proxies;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class PacketFXSignal
extends ForestryPacket {
    private FXType type;
    private int xCoord;
    private int yCoord;
    private int zCoord;
    private int blockid;
    private int meta;

    public PacketFXSignal() {
    }

    public PacketFXSignal(FXType type, int xCoord, int yCoord, int zCoord, int blockid, int meta) {
        super(3);
        this.type = type;
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
        this.blockid = blockid;
        this.meta = meta;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeShort(this.type.ordinal());
        data.writeInt(this.xCoord);
        data.writeInt(this.yCoord);
        data.writeInt(this.zCoord);
        data.writeInt(this.blockid);
        data.writeInt(this.meta);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        this.type = FXType.values()[data.readShort()];
        this.xCoord = data.readInt();
        this.yCoord = data.readInt();
        this.zCoord = data.readInt();
        this.blockid = data.readInt();
        this.meta = data.readInt();
    }

    public void executeFX() {
        Proxies.common.addBlockDestroyEffects(Proxies.common.getRenderWorld(), this.xCoord, this.yCoord, this.zCoord, this.blockid, this.meta);
    }

    public static enum FXType {
        BLOCK_DESTROY;

    }
}

