/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import forestry.core.ForestryClient;
import forestry.core.gadgets.Mill;
import forestry.core.gadgets.TileMill;
import forestry.core.interfaces.IBlockRenderer;
import forestry.core.proxy.Proxies;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderMill
implements IBlockRenderer {
    private axa model = new axa(){};
    private String gfxBase;
    private byte charges = 1;
    private ayf pedestal = new ayf(this.model, 0, 0);
    private ayf column;
    private ayf extension;
    private ayf blade1;
    private ayf blade2;

    public RenderMill() {
        this.pedestal.a(-8.0f, -8.0f, -8.0f, 16, 1, 16);
        this.pedestal.c = 8.0f;
        this.pedestal.d = 8.0f;
        this.pedestal.e = 8.0f;
        this.column = new ayf(this.model, 0, 0);
        this.column.a(-2.0f, -7.0f, -2.0f, 4, 15, 4);
        this.column.c = 8.0f;
        this.column.d = 8.0f;
        this.column.e = 8.0f;
        this.extension = new ayf(this.model, 0, 0);
        this.extension.a(1.0f, 8.0f, 7.0f, 14, 2, 2);
        this.extension.c = 0.0f;
        this.extension.d = 0.0f;
        this.extension.e = 0.0f;
        this.blade1 = new ayf(this.model, 0, 0);
        this.blade1.a(-4.0f, -5.0f, -3.0f, 8, 12, 1);
        this.blade1.c = 8.0f;
        this.blade1.d = 8.0f;
        this.blade1.e = 8.0f;
        this.blade2 = new ayf(this.model, 0, 0);
        this.blade2.a(-4.0f, -5.0f, 2.0f, 8, 12, 1);
        this.blade2.c = 8.0f;
        this.blade2.d = 8.0f;
        this.blade2.e = 8.0f;
    }

    public RenderMill(String baseTexture) {
        this();
        this.gfxBase = baseTexture;
    }

    public RenderMill(String baseTexture, byte charges) {
        this(baseTexture);
    }

    @Override
    public void preloadTextures() {
        ForestryClient.preloadTexture(this.gfxBase + "pedestal.png");
        ForestryClient.preloadTexture(this.gfxBase + "extension.png");
        ForestryClient.preloadTexture(this.gfxBase + "blade1.png");
        ForestryClient.preloadTexture(this.gfxBase + "blade2.png");
        for (int i = 0; i < this.charges; ++i) {
            ForestryClient.preloadTexture(this.gfxBase + "column_" + i + ".png");
        }
    }

    @Override
    public void inventoryRender(double x2, double y2, double z2, float f, float f1) {
        int charge = 0;
        this.render(0.0f, charge, ForgeDirection.WEST, this.gfxBase, x2, y2, z2);
    }

    @Override
    public void renderTileEntityAt(any tileentity, double d, double d1, double d2, float f) {
        Mill tile = (Mill)((TileMill)tileentity).machine;
        this.render(tile.progress, tile.charge, ForgeDirection.WEST, this.gfxBase, d, d1, d2);
    }

    private void render(float progress, int charge, ForgeDirection orientation, String gfxBase, double x2, double y2, double z2) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glTranslatef((float)((float)x2), (float)((float)y2), (float)((float)z2));
        float step = (double)progress > 0.5 ? 3.99f - (progress - 0.5f) * 2.0f * 3.99f : progress * 2.0f * 3.99f;
        float[] angle = new float[]{0.0f, 0.0f, 0.0f};
        float[] translate = new float[]{0.0f, 0.0f, 0.0f};
        float tfactor = step / 16.0f;
        if (orientation == null) {
            orientation = ForgeDirection.WEST;
        }
        switch (orientation) {
            case EAST: {
                angle[1] = (float)Math.PI;
                angle[2] = -1.5707964f;
                translate[0] = 1.0f;
                break;
            }
            case WEST: {
                angle[2] = 1.5707964f;
                translate[0] = -1.0f;
                break;
            }
            case UP: {
                translate[1] = 1.0f;
                break;
            }
            case DOWN: {
                angle[2] = (float)Math.PI;
                translate[1] = -1.0f;
                break;
            }
            case SOUTH: {
                angle[0] = 1.5707964f;
                angle[2] = 1.5707964f;
                translate[2] = 1.0f;
                break;
            }
            default: {
                angle[0] = -1.5707964f;
                angle[2] = 1.5707964f;
                translate[2] = -1.0f;
            }
        }
        this.pedestal.f = angle[0];
        this.pedestal.g = angle[2];
        this.pedestal.h = angle[1];
        this.column.f = angle[0];
        this.column.g = angle[2];
        this.column.h = angle[1];
        this.blade1.f = angle[0];
        this.blade1.g = angle[2];
        this.blade1.h = angle[1];
        this.blade2.f = angle[0];
        this.blade2.g = angle[2];
        this.blade2.h = angle[1];
        float factor = 0.0625f;
        Proxies.common.bindTexture(gfxBase + "pedestal.png");
        this.pedestal.a(factor);
        Proxies.common.bindTexture(gfxBase + "column_" + charge + ".png");
        this.column.a(factor);
        Proxies.common.bindTexture(gfxBase + "extension.png");
        this.extension.a(factor);
        Proxies.common.bindTexture(gfxBase + "blade1.png");
        GL11.glTranslatef((float)(translate[0] * tfactor), (float)(translate[1] * tfactor), (float)(translate[2] * tfactor));
        this.blade1.a(factor);
        GL11.glTranslatef((float)(-translate[0] * tfactor), (float)(-translate[1] * tfactor), (float)(-translate[2] * tfactor));
        Proxies.common.bindTexture(gfxBase + "blade2.png");
        GL11.glTranslatef((float)(-translate[0] * tfactor), (float)(translate[1] * tfactor), (float)(-translate[2] * tfactor));
        this.blade2.a(factor);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }
}

